/*
 * Decompiled with CFR 0.152.
 */
package lanse.lanses.challenge.modpack.challenges.nuclearstorm;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lanse.lanses.challenge.modpack.MainControl;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class NuclearStorm {
    private static int tickCount = 0;
    private static final int LEAF_DECAY_RADIUS = 64;
    private static final List<class_2338> leavesToDecay = new ArrayList<class_2338>();

    public static void tick(MinecraftServer server) {
        ++tickCount;
        Random random = new Random();
        if (random.nextInt(185) == 25) {
            NuclearStorm.summonLightning(server);
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            class_3218 world = player.method_51469();
            NuclearStorm.spawnParticles(player.method_19538(), world);
            NuclearStorm.skyCheck(world);
            if (tickCount != 500) continue;
            NuclearStorm.scheduleLeafDecay(world, player.method_24515());
            tickCount = 0;
        }
        NuclearStorm.processLeafDecay(server);
    }

    private static void summonLightning(MinecraftServer server) {
        Random random = new Random();
        for (class_3222 player : server.method_3760().method_14571()) {
            class_1937 world = player.method_5770();
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double radius = random.nextDouble() * 128.0;
            double x = player.method_23317() + radius * Math.cos(angle);
            double z = player.method_23321() + radius * Math.sin(angle);
            class_2338 pos = new class_2338((int)x, world.method_31600(), (int)z);
            pos = world.method_8598(class_2902.class_2903.field_13202, pos);
            double y = pos.method_10264();
            class_1538 lightning = (class_1538)class_1299.field_6112.method_5883(world);
            if (lightning == null) continue;
            lightning.method_24203(x, y, z);
            world.method_8649((class_1297)lightning);
            int power = random.nextInt(6) + 6;
            world.method_8537((class_1297)lightning, x, y, z, (float)power, true, class_1937.class_7867.field_40891);
        }
    }

    private static void skyCheck(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            int radius = 64;
            class_238 boundingBox = new class_238(player.method_23317() - (double)radius, (double)world.method_31607(), player.method_23321() - (double)radius, player.method_23317() + (double)radius, (double)world.method_31600(), player.method_23321() + (double)radius);
            world.method_8390(class_1309.class, boundingBox, entity -> true).forEach(entity -> {
                class_2338 entityPos = entity.method_24515();
                boolean isInDanger = true;
                for (int i = 1; i <= 15; ++i) {
                    class_2338 checkPos = entityPos.method_10086(i);
                    if (world.method_22347(checkPos)) continue;
                    isInDanger = false;
                    break;
                }
                if (isInDanger) {
                    entity.method_6092(new class_1293(class_1294.field_5899, 20, 100));
                    entity.method_6092(new class_1293(class_1294.field_5920, 20, 100));
                }
            });
        }
    }

    private static void spawnParticles(class_243 playerPos, class_3218 world) {
        int particleRange = 42;
        Random random = new Random();
        class_2400 sporeBlossomParticle = class_2398.field_28802;
        for (int i = 0; i < 75; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 2.0 * (double)particleRange;
            double offsetZ = (random.nextDouble() - 0.5) * 2.0 * (double)particleRange;
            world.method_14199((class_2394)sporeBlossomParticle, playerPos.field_1352 + offsetX, playerPos.field_1351 + 15.0, playerPos.field_1350 + offsetZ, 1, 0.0, -0.2, 0.0, 0.0);
        }
    }

    private static void scheduleLeafDecay(class_3218 world, class_2338 playerPos) {
        if (world.method_27983() != class_1937.field_25179) {
            return;
        }
        int startX = playerPos.method_10263() - 64;
        int startY = playerPos.method_10264() - 64;
        int startZ = playerPos.method_10260() - 64;
        int endX = playerPos.method_10263() + 64;
        int endY = playerPos.method_10264() + 64;
        int endZ = playerPos.method_10260() + 64;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (!(world.method_8320(pos).method_26204() instanceof class_2397)) continue;
                    leavesToDecay.add(pos);
                }
            }
        }
    }

    private static void processLeafDecay(MinecraftServer server) {
        if (!leavesToDecay.isEmpty()) {
            int clearAmount = leavesToDecay.size() / 250 + 1;
            class_3218 world = server.method_3847(class_1937.field_25179);
            for (int i = 0; i < clearAmount; ++i) {
                int randomIndex = new Random().nextInt(leavesToDecay.size());
                class_2338 pos = leavesToDecay.get(randomIndex);
                if (pos == null || world == null || !(world.method_8320(pos).method_26204() instanceof class_2397)) continue;
                world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                leavesToDecay.remove(randomIndex);
            }
        }
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"LCP_Preset_NuclearStorm").requires(source -> source.method_9259(2))).executes(context -> {
            MainControl.modPreset = MainControl.Preset.NUCLEARSTORM;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Challenge Mod Preset set to NuclearStorm!"), true);
            return 1;
        }));
    }
}

