/*
 * Decompiled with CFR 0.152.
 */
package lanse.lanses.challenge.modpack.challenges.potionrain;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Random;
import lanse.lanses.challenge.modpack.MainControl;
import net.minecraft.class_1297;
import net.minecraft.class_1686;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class PotionRain {
    public static double potionRange = 42.0;
    public static int potionCount = 3;

    public static void tick(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) {
            for (class_3222 player : world.method_18456()) {
                PotionRain.spawnRandomPotions(player.method_19538(), world);
            }
        }
    }

    private static void spawnRandomPotions(class_243 playerPos, class_3218 world) {
        Random random = new Random();
        for (int i = 0; i < potionCount; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 2.0 * potionRange;
            double offsetZ = (random.nextDouble() - 0.5) * 2.0 * potionRange;
            class_1686 potionEntity = new class_1686((class_1937)world, playerPos.field_1352 + offsetX, playerPos.field_1351 + 20.0, playerPos.field_1350 + offsetZ);
            potionEntity.method_16940(class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8436), (class_1842)PotionRain.getRandomPotion(random)));
            world.method_8649((class_1297)potionEntity);
        }
    }

    private static class_1842 getRandomPotion(Random random) {
        List potions = class_7923.field_41179.method_10220().toList();
        class_1842 selectedPotion = (class_1842)potions.get(random.nextInt(potions.size()));
        if (selectedPotion == class_1847.field_8963 || selectedPotion == class_1847.field_8980) {
            return class_1847.field_8973;
        }
        if (selectedPotion == class_1847.field_8986 || selectedPotion == class_1847.field_8992 || selectedPotion == class_1847.field_9003) {
            return class_1847.field_8972;
        }
        return selectedPotion;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"LCP_PotionRainOn").requires(source -> source.method_9259(2))).executes(context -> {
            potionRange = 42.0;
            potionCount = 3;
            MainControl.modPreset = MainControl.Preset.POTIONRAIN;
            MainControl.isModEnabled = true;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Potion Rain has begun. (Range: 42. Count: 3.)"), true);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"LCP_PotionHeavyRainOn").requires(source -> source.method_9259(2))).executes(context -> {
            potionRange = 35.0;
            potionCount = 8;
            MainControl.modPreset = MainControl.Preset.POTIONRAIN;
            MainControl.isModEnabled = true;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Heavy Potion Rain has begun. (Range: 35. Count: 8.)"), true);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"LCP_PotionDeathRayOn").requires(source -> source.method_9259(2))).executes(context -> {
            potionRange = 0.1;
            potionCount = 3;
            MainControl.modPreset = MainControl.Preset.POTIONRAIN;
            MainControl.isModEnabled = true;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Potion Death Ray has begun. (Range: 0.1. Count: 3.)"), true);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"LCP_PotionRainOff").requires(source -> source.method_9259(2))).executes(context -> {
            MainControl.isModEnabled = false;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Potion Rain has stopped."), true);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"LCP_PotionRainCustom").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"potionRange", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"potionCount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            MainControl.modPreset = MainControl.Preset.POTIONRAIN;
            MainControl.isModEnabled = true;
            potionRange = Math.max((double)IntegerArgumentType.getInteger((CommandContext)context, (String)"potionRange"), 0.1);
            potionCount = Math.min(Math.max(IntegerArgumentType.getInteger((CommandContext)context, (String)"potionCount"), 1), 25);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)("Custom Potion Rain has begun with range " + potionRange + " and count " + potionCount + ".")), true);
            return 1;
        }))));
    }
}

