/*
 * Decompiled with CFR 0.152.
 */
package lanse.lanses.challenge.modpack.challenges.worldcorruptor;

import java.util.Random;
import lanse.lanses.challenge.modpack.challenges.worldcorruptor.WorldCorrupter;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class BlockSpreader {
    private static final class_5819 random = class_5819.method_43047();
    private static final Random javaRandom = new Random();
    private static final int MIN_Y = -64;
    private static final int MAX_Y = 320;
    private static final int MIN_DIM_Y = 0;
    private static final int MAX_DIM_Y = 256;

    public static void spreadBlocks(class_3218 world) {
        world.method_18456().forEach(player -> {
            class_2338 pos1 = BlockSpreader.getRandomPositionAroundPlayer(player.method_24515(), world, 64);
            if (javaRandom.nextInt(50) == 25) {
                class_2338 pos2 = BlockSpreader.getRandomPositionAroundPlayer(player.method_24515(), world, 128);
                class_2248 block1 = world.method_8320(pos1).method_26204();
                class_2248 block2 = world.method_8320(pos2).method_26204();
                world.method_8501(pos1, block2.method_9564());
                world.method_8501(pos2, block1.method_9564());
                return;
            }
            class_2338 pos2 = BlockSpreader.getRandomNearbyPosition(pos1, world);
            if (world.method_8320(pos1).method_26204() == world.method_8320(pos2).method_26204()) {
                if (world.method_8320(pos1).method_26204() == class_2246.field_10340) {
                    world.method_8501(pos1, class_2246.field_10277.method_9564());
                    world.method_8501(pos2, class_2246.field_10277.method_9564());
                }
                if (world.method_8320(pos1).method_26204() == class_2246.field_28888) {
                    world.method_8501(pos1, class_2246.field_29224.method_9564());
                    world.method_8501(pos2, class_2246.field_29224.method_9564());
                }
                return;
            }
            if (BlockSpreader.isAllowedBlock(pos1, world) && BlockSpreader.isAllowedBlock(pos2, world)) {
                world.method_8501(pos2, world.method_8320(pos1));
                if (javaRandom.nextInt(25) == 0) {
                    BlockSpreader.brokenSpreadInCardinalDirection(pos2, world);
                }
                if (javaRandom.nextInt(25) == 5) {
                    BlockSpreader.createStraightPillar(pos2, (class_1937)world, 0);
                }
                if (javaRandom.nextInt(30) == 25) {
                    world.method_8501(pos1, class_2246.field_10124.method_9564());
                }
            }
        });
    }

    private static void brokenSpreadInCardinalDirection(class_2338 startPos, class_3218 world) {
        int direction = javaRandom.nextInt(6);
        int spreadDistance = class_3532.method_15395((class_5819)random, (int)1, (int)WorldCorrupter.stormPower);
        for (int i = 0; i < spreadDistance; ++i) {
            class_2338 nextPos = BlockSpreader.getNextPositionInDirection(startPos, direction, i + 1);
            if (!BlockSpreader.isAllowedBlock(startPos, world) || !BlockSpreader.isAllowedBlock(nextPos, world)) break;
            world.method_8501(nextPos, world.method_8320(startPos));
            startPos = nextPos;
        }
    }

    public static void createStraightPillar(class_2338 startPos, class_1937 world, int spreadDistance) {
        int direction = javaRandom.nextInt(6);
        spreadDistance = class_3532.method_15395((class_5819)random, (int)(1 + spreadDistance), (int)(15 + spreadDistance));
        class_2338 currentPos = startPos;
        for (int i = 0; i < spreadDistance; ++i) {
            class_2338 nextPos = BlockSpreader.getNextPositionInDirection(currentPos, direction, 1);
            if (!BlockSpreader.isAllowedBlock(currentPos, (class_3218)world) || !BlockSpreader.isAllowedBlock(nextPos, (class_3218)world)) break;
            world.method_8501(nextPos, world.method_8320(currentPos));
            currentPos = nextPos;
        }
    }

    private static class_2338 getNextPositionInDirection(class_2338 origin, int direction, int distance) {
        return switch (direction) {
            case 0 -> origin.method_10076(distance);
            case 1 -> origin.method_10089(distance);
            case 2 -> origin.method_10077(distance);
            case 3 -> origin.method_10088(distance);
            case 4 -> origin.method_10086(distance);
            case 5 -> origin.method_10087(distance);
            default -> origin;
        };
    }

    public static void createDiagonalPillar(class_2338 startPos, class_3218 world) {
        int diagonalDirection = javaRandom.nextInt(4);
        int verticalMovement = javaRandom.nextInt(3);
        int height = class_3532.method_15395((class_5819)random, (int)3, (int)20);
        int spreadDistance = class_3532.method_15395((class_5819)random, (int)1, (int)10);
        class_2338 currentPos = startPos;
        for (int i = 0; i < height; ++i) {
            currentPos = BlockSpreader.getNextDiagonalPosition(currentPos, diagonalDirection, spreadDistance, verticalMovement);
            if (!BlockSpreader.isAllowedBlock(startPos, world) || !BlockSpreader.isAllowedBlock(currentPos, world)) break;
            world.method_8501(currentPos, world.method_8320(startPos));
        }
    }

    private static class_2338 getNextDiagonalPosition(class_2338 origin, int diagonalDirection, int distance, int verticalMovement) {
        return switch (diagonalDirection) {
            case 0 -> origin.method_10076(distance).method_10088(distance).method_10086(BlockSpreader.verticalStepDiag(verticalMovement));
            case 1 -> origin.method_10076(distance).method_10089(distance).method_10086(BlockSpreader.verticalStepDiag(verticalMovement));
            case 2 -> origin.method_10077(distance).method_10088(distance).method_10086(BlockSpreader.verticalStepDiag(verticalMovement));
            case 3 -> origin.method_10077(distance).method_10089(distance).method_10086(BlockSpreader.verticalStepDiag(verticalMovement));
            default -> origin;
        };
    }

    private static int verticalStepDiag(int verticalMovement) {
        return switch (verticalMovement) {
            case 1 -> 1;
            case 2 -> -1;
            default -> 0;
        };
    }

    private static class_2338 getRandomPositionAroundPlayer(class_2338 playerPos, class_3218 world, int distance) {
        int x = playerPos.method_10263() + class_3532.method_15395((class_5819)random, (int)(-distance), (int)distance);
        int y = BlockSpreader.clampYLevel(playerPos.method_10264() + class_3532.method_15395((class_5819)random, (int)(-distance), (int)distance), world, x, playerPos.method_10260());
        int z = playerPos.method_10260() + class_3532.method_15395((class_5819)random, (int)(-distance), (int)distance);
        return new class_2338(x, y, z);
    }

    private static class_2338 getRandomNearbyPosition(class_2338 origin, class_3218 world) {
        int xOffset = class_3532.method_15395((class_5819)random, (int)-1, (int)1);
        int yOffset = class_3532.method_15395((class_5819)random, (int)-1, (int)1);
        int zOffset = class_3532.method_15395((class_5819)random, (int)-1, (int)1);
        int newY = BlockSpreader.clampYLevel(origin.method_10264() + yOffset, world, origin.method_10263(), origin.method_10260());
        return new class_2338(origin.method_10263() + xOffset, newY, origin.method_10260() + zOffset);
    }

    private static int clampYLevel(int y, class_3218 world, int x, int z) {
        if (!world.method_8597().comp_648()) {
            return class_3532.method_15340((int)y, (int)0, (int)256);
        }
        int surfaceY = world.method_8624(class_2902.class_2903.field_13202, x, z);
        return class_3532.method_15340((int)y, (int)-64, (int)Math.min(320, surfaceY));
    }

    private static boolean isAllowedBlock(class_2338 pos, class_3218 world) {
        return world.method_8320(pos).method_26204() != class_2246.field_10316 && world.method_8320(pos).method_26204() != class_2246.field_10027 && world.method_8320(pos).method_26204() != class_2246.field_10398 && world.method_8320(pos).method_26204() != class_2246.field_10613 && world.method_8320(pos).method_26204() != class_2246.field_10260 && world.method_8320(pos).method_26204() != class_2246.field_10540;
    }

    public static void createParticles(class_3218 world) {
        int particleRange = 40;
        class_2400 corruptedParticle = class_2398.field_11216;
        world.method_18456().forEach(arg_0 -> BlockSpreader.lambda$createParticles$1(particleRange, world, (class_2394)corruptedParticle, arg_0));
    }

    private static /* synthetic */ void lambda$createParticles$1(int particleRange, class_3218 world, class_2394 corruptedParticle, class_3222 player) {
        class_243 playerPos = player.method_19538();
        for (int i = 0; i < 100; ++i) {
            double offsetX = (javaRandom.nextDouble() - 0.5) * 2.0 * (double)particleRange;
            double offsetY = (javaRandom.nextDouble() - 0.5) * 2.0 * (double)particleRange;
            double offsetZ = (javaRandom.nextDouble() - 0.5) * 2.0 * (double)particleRange;
            world.method_14199(corruptedParticle, playerPos.field_1352 + offsetX, playerPos.field_1351 + offsetY, playerPos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.15);
        }
    }
}

