/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.mouse.mob.mouse;

import aquariusplayz.animalgarden.mouse.mob.mouse.ModMobAnimations;
import aquariusplayz.animalgarden.mouse.mob.mouse.ModMobRenderState;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public class ModMobModel
extends EntityModel<ModMobRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_mouse", (String)"mouse"), "main");
    public static final ModelLayerLocation BABY_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.tryBuild((String)"animalgarden_mouse", (String)"baby_mouse"), "main");
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(Set.of("head"));
    private final ModelPart rootz;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart teeth;
    private final ModelPart nose;
    private final ModelPart righteye;
    private final ModelPart lefteye;
    private final ModelPart rightear;
    private final ModelPart leftear;
    private final ModelPart torso;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart rightHindLegFeet;
    private final ModelPart leftHindLeg;
    private final ModelPart leftHindLegFeet;
    private final ModelPart tail;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart tail4;
    private final ModelPart tail5;
    private final ModelPart tail6;
    private final ModelPart tail7;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public ModMobModel(ModelPart root) {
        super(root);
        this.rootz = root.getChild("rootz");
        this.body = this.rootz.getChild("body");
        this.head = this.body.getChild("head");
        this.teeth = this.head.getChild("teeth");
        this.nose = this.head.getChild("nose");
        this.righteye = this.head.getChild("righteye");
        this.lefteye = this.head.getChild("lefteye");
        this.rightear = this.head.getChild("rightear");
        this.leftear = this.head.getChild("leftear");
        this.torso = this.body.getChild("torso");
        this.rightFrontLeg = this.body.getChild("rightFrontLeg");
        this.leftFrontLeg = this.body.getChild("leftFrontLeg");
        this.rightHindLeg = this.body.getChild("rightHindLeg");
        this.rightHindLegFeet = this.rightHindLeg.getChild("rightHindLegFeet");
        this.leftHindLeg = this.body.getChild("leftHindLeg");
        this.leftHindLegFeet = this.leftHindLeg.getChild("leftHindLegFeet");
        this.tail = this.body.getChild("tail");
        this.tail2 = this.tail.getChild("tail2");
        this.tail3 = this.tail2.getChild("tail3");
        this.tail4 = this.tail3.getChild("tail4");
        this.tail5 = this.tail4.getChild("tail5");
        this.tail6 = this.tail5.getChild("tail6");
        this.tail7 = this.tail6.getChild("tail7");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition rootz = partdefinition.addOrReplaceChild("rootz", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = rootz.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, -2.0f, 10.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-1.0f));
        PartDefinition teeth = head.addOrReplaceChild("teeth", CubeListBuilder.create().texOffs(45, 33).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.45f)), PartPose.offset((float)0.0f, (float)-1.975f, (float)-2.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(45, 38).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-2.5f));
        PartDefinition righteye = head.addOrReplaceChild("righteye", CubeListBuilder.create().texOffs(48, 10).addBox(-1.0f, -1.5f, 0.04f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(15, 29).addBox(-0.5f, -2.0f, -0.63f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.66f)), PartPose.offset((float)-3.0f, (float)-3.5f, (float)-2.05f));
        PartDefinition lefteye = head.addOrReplaceChild("lefteye", CubeListBuilder.create().texOffs(0, 49).addBox(-1.0f, -1.5f, 0.04f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 44).addBox(-0.5f, -2.0f, -0.63f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.66f)), PartPose.offset((float)3.0f, (float)-3.5f, (float)-2.05f));
        PartDefinition rightear = head.addOrReplaceChild("rightear", CubeListBuilder.create().texOffs(33, 0).addBox(-4.0f, -5.0f, -1.0f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 29).addBox(-3.0f, -6.0f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 42).addBox(-3.0f, 0.0f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-6.0f, (float)1.0f));
        PartDefinition leftear = head.addOrReplaceChild("leftear", CubeListBuilder.create().texOffs(15, 35).addBox(-1.0f, -5.0f, -1.0f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(41, 42).addBox(0.0f, -6.0f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(11, 43).addBox(0.0f, 0.0f, -1.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-6.0f, (float)1.0f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 15).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(25, 15).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)3.0f));
        PartDefinition rightFrontLeg = body.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(40, 15).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)-0.1f, (float)0.0f));
        PartDefinition leftFrontLeg = body.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(40, 22).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)-0.1f, (float)0.0f));
        PartDefinition rightHindLeg = body.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(25, 26).addBox(-2.0f, -1.4f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)2.4f, (float)2.1f));
        PartDefinition rightHindLegFeet = rightHindLeg.addOrReplaceChild("rightHindLegFeet", CubeListBuilder.create().texOffs(33, 8).addBox(-1.0f, 1.0f, -3.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)-1.0f, (float)-0.4f, (float)0.0f));
        PartDefinition leftHindLeg = body.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(0, 29).addBox(-5.0f, -1.4f, -2.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)2.4f, (float)2.1f));
        PartDefinition leftHindLegFeet = leftHindLeg.addOrReplaceChild("leftHindLegFeet", CubeListBuilder.create().texOffs(30, 35).addBox(-1.0f, 1.0f, -3.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)-4.0f, (float)-0.4f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 38).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)4.0f));
        PartDefinition tail2 = tail.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(22, 46).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.75f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(31, 46).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.02f)), PartPose.offset((float)0.0f, (float)0.0f, (float)1.7f));
        PartDefinition tail4 = tail3.addOrReplaceChild("tail4", CubeListBuilder.create().texOffs(40, 46).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.03f)), PartPose.offset((float)0.0f, (float)0.0f, (float)1.7f));
        PartDefinition tail5 = tail4.addOrReplaceChild("tail5", CubeListBuilder.create().texOffs(9, 47).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.04f)), PartPose.offset((float)0.0f, (float)0.0f, (float)1.7f));
        PartDefinition tail6 = tail5.addOrReplaceChild("tail6", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.05f)), PartPose.offset((float)0.0f, (float)0.0f, (float)1.7f));
        PartDefinition tail7 = tail6.addOrReplaceChild("tail7", CubeListBuilder.create().texOffs(48, 5).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.06f)), PartPose.offset((float)0.0f, (float)0.0f, (float)1.7f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(ModMobRenderState p_368486_) {
        super.setupAnim((Object)p_368486_);
        this.animate(p_368486_.winkAnimationState, ModMobAnimations.wink_animation, p_368486_.ageInTicks, 1.0f);
        if (!p_368486_.isSitting) {
            if (p_368486_.walkAnimationSpeed > 0.002f && p_368486_.walkAnimationSpeed < 10.0f) {
                this.animateWalk(ModMobAnimations.walk_animation, p_368486_.walkAnimationPos, p_368486_.walkAnimationSpeed, 6.0f, 2.5f);
            } else {
                this.animate(p_368486_.idleAnimationState, ModMobAnimations.idle_breathing_animation, p_368486_.ageInTicks, 1.0f);
                this.animate(p_368486_.idleTailAnimationState, ModMobAnimations.idle_tail_animation, p_368486_.ageInTicks, 1.0f);
                this.animate(p_368486_.idleLeftEarAnimationState, ModMobAnimations.idle_leftear_animation, p_368486_.ageInTicks, 1.0f);
                this.animate(p_368486_.idleRightEarAnimationState, ModMobAnimations.idle_rightear_animation, p_368486_.ageInTicks, 1.0f);
                this.animate(p_368486_.begAnimationState, ModMobAnimations.beg_animation, p_368486_.ageInTicks, 1.0f);
            }
        } else {
            this.animate(p_368486_.sitAnimationState, ModMobAnimations.sitting_loop_animation, p_368486_.ageInTicks, 1.0f);
            this.animate(p_368486_.idleLeftEarAnimationState, ModMobAnimations.idle_leftear_animation, p_368486_.ageInTicks, 1.0f);
            this.animate(p_368486_.idleRightEarAnimationState, ModMobAnimations.idle_rightear_animation, p_368486_.ageInTicks, 1.0f);
        }
    }

    protected void animate(AnimationState p_361867_, AnimationDefinition p_365477_, float p_361961_) {
        this.animate(p_361867_, p_365477_, p_361961_, 1.0f);
    }

    protected void animateWalk(AnimationDefinition p_363127_, float p_364817_, float p_364163_, float p_365350_, float p_365167_) {
        long i = (long)(p_364817_ * 50.0f * p_365350_);
        float f = Math.min(p_364163_ * p_365167_, 1.0f);
        ModMobModel.animate((Model)this, p_363127_, i, f, ANIMATION_VECTOR_CACHE);
    }

    protected void animate(AnimationState p_368871_, AnimationDefinition p_365491_, float p_363110_, float p_368202_) {
        p_368871_.ifStarted(p_368242_ -> ModMobModel.animate((Model)this, p_365491_, (long)((float)p_368242_.getTimeInMillis(p_363110_) * p_368202_), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    protected void applyStatic(AnimationDefinition p_369884_) {
        ModMobModel.animate((Model)this, p_369884_, 0L, 1.0f, ANIMATION_VECTOR_CACHE);
    }

    public static Optional<ModelPart> getAnyDescendantWithName(Model p_362391_, String p_363872_) {
        Stream stream = p_362391_.root().getAllParts().stream();
        return p_363872_.equals("root") ? Optional.of(p_362391_.root()) : stream.filter(p_364767_ -> p_364767_.hasChild(p_363872_)).findFirst().map(p_366385_ -> p_366385_.getChild(p_363872_));
    }

    public static void animate(Model p_362391_, AnimationDefinition p_232321_, long p_232322_, float p_232323_, Vector3f p_253861_) {
        float f = ModMobModel.getElapsedSeconds(p_232321_, p_232322_);
        for (Map.Entry entry : p_232321_.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = ModMobModel.getAnyDescendantWithName(p_362391_, (String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(p_232330_ -> list.forEach(p_288241_ -> {
                Keyframe[] akeyframe = p_288241_.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)akeyframe.length, p_232315_ -> f <= akeyframe[p_232315_].timestamp()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.timestamp();
                float f2 = j != i ? Mth.clamp((float)(f1 / (keyframe1.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe1.interpolation().apply(p_253861_, f2, akeyframe, i, j, p_232323_);
                p_288241_.target().apply(p_232330_, p_253861_);
            }));
        }
    }

    public static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.looping() ? f % p_232317_.lengthInSeconds() : f;
    }
}

