var rawModels = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:models/717.obj"), null);
var rawModels2 = ModelManager.loadPartedRawModel(Resources.manager(), Resources.idRelative("mtr:models/714.obj"), null);

var modelsH = uploadPartedModels(rawModels)
var modelsM = uploadPartedModels(rawModels2)

function create(ctx, state, train) {

}

function dispose(ctx, state, train) {

}

function render(ctx, state, train) {
	let matrices = new Matrices();
	renderHead(ctx, state, train, 0, matrices) // Голова
	if (train.trainCars() > 1) {
		for (var i = 1; i < train.trainCars() - 1; i++) {
			renderMiddle(ctx, state, train, i, matrices); // Средняя часть
		}
		renderTail(ctx, state, train, train.trainCars() - 1, matrices); // хвост
	}

}

function renderHead(ctx, state, train, i, matrices) {
	let m = modelsH;
	let doorValue = Math.min(train.doorValue() * 2, 1);
	let isLSDActive = doorValue > 0;
	let isLPTActive = train.speed() == 0;

	let isLeftOpen = train.doorLeftOpen[i];
	let isRightOpened = train.doorRightOpen[i];

	const doorLength = 0.63

	let leftCoef = isLeftOpen ? smoothCubic(doorValue) * doorLength : 0.0;
	let rightCoef = isRightOpened ? smoothCubic(doorValue) * doorLength : 0.0;

	// body
	ctx.drawCarModel(m["EXT"], i, matrices);
	ctx.drawCarModel(m["INT"], i, matrices);
	ctx.drawCarModel(m["INTLAMPS"], i, matrices);

	// lights
	if (train.isReversed()) {
		ctx.drawCarModel(m["BUF"], i, matrices);
	} else {
		ctx.drawCarModel(m["FARY"], i, matrices);
	}

	// signals
	if (isLSDActive) ctx.drawCarModel(m["lsd"], i, matrices); 
	if (isLPTActive) ctx.drawCarModel(m["lpt"], i, matrices); 

	// doors
	matrices.pushPose();
	matrices.translate(0,0, rightCoef)
	ctx.drawCarModel(m["D_RF_EXT"], i, matrices);
	ctx.drawCarModel(m["D_RF_INT"], i, matrices);
	matrices.popPose();

	matrices.pushPose();
	matrices.translate(0,0, -rightCoef)
	ctx.drawCarModel(m["D_RB_EXT"], i, matrices);
	ctx.drawCarModel(m["D_RB_INT"], i, matrices);
	matrices.popPose();

	matrices.pushPose();
	matrices.translate(0,0, leftCoef)
	ctx.drawCarModel(m["D_LF_EXT"], i, matrices);
	ctx.drawCarModel(m["D_LF_INT"], i, matrices);
	matrices.popPose();

	matrices.pushPose();
	matrices.translate(0,0, -leftCoef)
	ctx.drawCarModel(m["D_LB_EXT"], i, matrices);
	ctx.drawCarModel(m["D_LB_INT"], i, matrices);
	matrices.popPose();
}

function renderMiddle(ctx, state, train, i, matrices) {
	let m = modelsM;
	let doorValue = Math.min(train.doorValue() * 2, 1);;
	let isLSDActive = doorValue > 0;
	let isLPTActive = train.speed() == 0;

	let isLeftOpen = train.doorLeftOpen[i];
	let isRightOpened = train.doorRightOpen[i];

	const doorLength = 0.63

	let leftCoef = isLeftOpen ? smoothCubic(doorValue) * doorLength : 0.0;
	let rightCoef = isRightOpened ? smoothCubic(doorValue) * doorLength : 0.0;

	

	// body
	ctx.drawCarModel(m["EXT"], i, matrices);
	ctx.drawCarModel(m["INT"], i, matrices);
	ctx.drawCarModel(m["INTLAMPS"], i, matrices);

	// signals
	if (isLSDActive) ctx.drawCarModel(m["lsd"], i, matrices); 
	if (isLPTActive) ctx.drawCarModel(m["lpt"], i, matrices); 

	// doors
	matrices.pushPose();
	matrices.translate(0,0, rightCoef)
	ctx.drawCarModel(m["D_RF_EXT"], i, matrices);
	ctx.drawCarModel(m["D_RF_INT"], i, matrices);
	matrices.popPose();

	matrices.pushPose();
	matrices.translate(0,0, -rightCoef)
	ctx.drawCarModel(m["D_RB_EXT"], i, matrices);
	ctx.drawCarModel(m["D_RB_INT"], i, matrices);
	matrices.popPose();

	matrices.pushPose();
	matrices.translate(0,0, leftCoef)
	ctx.drawCarModel(m["D_LF_EXT"], i, matrices);
	ctx.drawCarModel(m["D_LF_INT"], i, matrices);
	matrices.popPose();

	matrices.pushPose();
	matrices.translate(0,0, -leftCoef)
	ctx.drawCarModel(m["D_LB_EXT"], i, matrices);
	ctx.drawCarModel(m["D_LB_INT"], i, matrices);
	matrices.popPose();
}

function renderTail(ctx, state, train, i, matrices) {
	let m = modelsH;
	let doorValue = Math.min(train.doorValue() * 2, 1);
	let isLSDActive = doorValue > 0;
	let isLPTActive = train.speed() == 0;

	let isLeftOpen = train.doorLeftOpen[i];
	let isRightOpened = train.doorRightOpen[i];

	const doorLength = 0.63
	let leftCoef = isRightOpened ? smoothCubic(doorValue) * doorLength : 0.0; // swaped because model turned 
	let rightCoef = isLeftOpen ? smoothCubic(doorValue) * doorLength : 0.0;

	

	matrices.pushPose();

	matrices.rotateY(3.141592);

	// body
	ctx.drawCarModel(m["EXT"], i, matrices);
	ctx.drawCarModel(m["INT"], i, matrices);
	ctx.drawCarModel(m["INTLAMPS"], i, matrices);

	// lights
	if (!train.isReversed()) {
		ctx.drawCarModel(m["BUF"], i, matrices);
	} else {
		ctx.drawCarModel(m["FARY"], i, matrices);
	}

	// signals
	if (isLSDActive) ctx.drawCarModel(m["lsd"], i, matrices); 
	if (isLPTActive) ctx.drawCarModel(m["lpt"], i, matrices); 

	// doors
	matrices.pushPose();
	matrices.translate(0,0, rightCoef)
	ctx.drawCarModel(m["D_RF_EXT"], i, matrices);
	ctx.drawCarModel(m["D_RF_INT"], i, matrices);
	matrices.popPose();

	matrices.pushPose();
	matrices.translate(0,0, -rightCoef)
	ctx.drawCarModel(m["D_RB_EXT"], i, matrices);
	ctx.drawCarModel(m["D_RB_INT"], i, matrices);
	matrices.popPose();

	matrices.pushPose();
	matrices.translate(0,0, leftCoef)
	ctx.drawCarModel(m["D_LF_EXT"], i, matrices);
	ctx.drawCarModel(m["D_LF_INT"], i, matrices);
	matrices.popPose();

	matrices.pushPose();
	matrices.translate(0,0, -leftCoef)
	ctx.drawCarModel(m["D_LB_EXT"], i, matrices);
	ctx.drawCarModel(m["D_LB_INT"], i, matrices);
	matrices.popPose();

	matrices.popPose();
}

function uploadPartedModels(rawModels) { 
	result = {};
	for (it = rawModels.entrySet().iterator(); it.hasNext(); ) {
		entry = it.next();

		let jsStringKey = "" + entry.getKey(); // строка в жс строку
		if (jsStringKey.includes("INT")) entry.getValue().setAllRenderType("interior"); //включение интерьера
		if (jsStringKey == "FARY" || jsStringKey == "BUF" || jsStringKey == "INTLAMPS"
		 || jsStringKey == "lsd" || jsStringKey == "lpt" || jsStringKey == "lpt") entry.getValue().setAllRenderType("light"); //включение света


		result[jsStringKey] = ModelManager.uploadVertArrays(entry.getValue());
	}
	return result;
}

function smoothCubic(x) { //кубическая функция - в отрезке 0-1 возвращает сглаженную функцию 0-1
	return x*x*(-2*x + 3);
}