importPackage(java.awt);
importPackage(java.awt.geom);
include(Resources.id('mtrsteamloco:scripts/display_helper.js'));

let timebaseCfg = {
    'renderType': 'exterior',
    version: 1,
    texSize: [1410, 206],
    slots: [
        {
            name: 'timebase',
            texArea: [0, 0, 1410, 206],
            pos: [
                [
                    [-1.2693, 0.7821, -0.481],
                    [-1.2693, 0.1925, -0.481],
                    [2.8346, 0.1925, -0.481],
                    [2.8346, 0.7821, -0.481],
                ],
            ],
            offsets: [[0, 0, 0]],
        },
    ],
};

let timeCfg = {
    version: 1,
    texSize: [1410, 206],
    slots: [
        {
            name: 'time',
            texArea: [0, 0, 1410, 206],
            pos: [
                [
                    [-1.2693, 0.7811, -0.48],
                    [-1.2693, 0.1925, -0.48],
                    [2.8346, 0.1925, -0.48],
                    [2.8346, 0.7821, -0.48],
                ],
            ],
            offsets: [[0, 0, 0]],
        },
    ],
};

let dhTimeBase = new DisplayHelper(timebaseCfg);
let dhTime = new DisplayHelper(timeCfg);

function create(ctx, state, entity) {
    state.pisRateLimit = new RateLimit(0.05);
    state.dhTimeBase = dhTimeBase.create();
    state.dhTime = dhTime.create();
}

function dispose(ctx, state, entity) {
    state.dhTimeBase.close();
    state.dhTime.close();
}

var cifriFont = Resources.readFont(
    Resources.idRelative('mtrsteamloco:eyecandies/fonts/interval-clock-2.ttf')
);

function render(ctx, state, entity) {
 	var matrices = new Matrices();
   if (state.pisRateLimit.shouldUpdate()) {
        let g;
        let g2;

	let date = new Date();
	let hours = date.getUTCHours() + 3;
	let minutes = date.getMinutes();
	let seconds = date.getSeconds();

	if (hours > 23) hours = hours - 24;
	else hours = hours;
	if (hours < 10) hours = "0" + (hours + "");
	else hours = hours + "";
	if (minutes < 10) minutes = "0" + (minutes + "");
	else minutes = minutes + "";
	if (seconds < 10) seconds = "0" + (seconds + "");
	else seconds = seconds + "";
	let time = hours + ":" + minutes + ":" + seconds;

        [
            { dhTime: state.dhTime, graphicsName: 'time' }
        ].forEach((element) => {
            let dh = element.dhTime;
            g = dh.graphicsFor(element.graphicsName);

 	g.setComposite(AlphaComposite.Clear);
	g.fillRect(0, 0, 1410, 206);
	g.setComposite(AlphaComposite.SrcOver);

	g.setColor(new Color(255 / 255, 117 / 255, 96 / 255));
            g.setFont(cifriFont.deriveFont(Font.PLAIN, 32));
            g.drawString(time, 33, 186);
            dh.upload();
        });

        [
            { dhTimeBase: state.dhTimeBase, graphicsName: 'timebase' }
        ].forEach((element) => {
            let dh2 = element.dhTimeBase;
            g2 = dh2.graphicsFor(element.graphicsName);

 	g2.setColor(new Color(0 / 255, 0 / 255, 0 / 255));
	g2.fillRect(0, 0, 865, 206);
	g2.fillRect(994, 0, 415, 206);

	g2.setColor(new Color(34 / 255, 0 / 255, 0 / 255));
            g2.setFont(cifriFont.deriveFont(Font.PLAIN, 32));
            g2.drawString("88:88:88", 33, 186);
            dh2.upload();
        });

    }

    ctx.drawModel(state.dhTimeBase.model, matrices);
    ctx.drawModel(state.dhTime.model, matrices);
}