/*
 * Decompiled with CFR 0.152.
 */
package com.nitron.nitrogen.render;

import java.util.ArrayList;
import java.util.Deque;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_7833;

public class RenderUtils {
    public static void renderSolidColorCube(class_4587 matrices, class_4588 vertices, int color, class_243 center, float inflation) {
        class_4587.class_4665 entry = matrices.method_23760();
        float x0 = (float)(center.method_10216() + 0.5 - (double)inflation);
        float x1 = (float)(center.method_10216() + 0.5 + (double)inflation);
        float y0 = (float)(center.method_10214() + 0.5 - (double)inflation);
        float y1 = (float)(center.method_10214() + 0.5 + (double)inflation);
        float z0 = (float)(center.method_10215() + 0.5 - (double)inflation);
        float z1 = (float)(center.method_10215() + 0.5 + (double)inflation);
        RenderUtils.renderQuad(entry, vertices, color, x0, y0, z1, x1, y0, z1, x1, y1, z1, x0, y1, z1);
        RenderUtils.renderQuad(entry, vertices, color, x1, y0, z0, x0, y0, z0, x0, y1, z0, x1, y1, z0);
        RenderUtils.renderQuad(entry, vertices, color, x0, y0, z0, x0, y0, z1, x0, y1, z1, x0, y1, z0);
        RenderUtils.renderQuad(entry, vertices, color, x1, y0, z1, x1, y0, z0, x1, y1, z0, x1, y1, z1);
        RenderUtils.renderQuad(entry, vertices, color, x0, y1, z1, x1, y1, z1, x1, y1, z0, x0, y1, z0);
        RenderUtils.renderQuad(entry, vertices, color, x0, y0, z0, x1, y0, z0, x1, y0, z1, x0, y0, z1);
    }

    private static void renderQuad(class_4587.class_4665 matrix, class_4588 vertices, int color, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        RenderUtils.renderVertex(matrix, vertices, color, x1, y1, z1);
        RenderUtils.renderVertex(matrix, vertices, color, x2, y2, z2);
        RenderUtils.renderVertex(matrix, vertices, color, x3, y3, z3);
        RenderUtils.renderVertex(matrix, vertices, color, x4, y4, z4);
    }

    private static void renderVertex(class_4587.class_4665 matrix, class_4588 vertices, int color, float x, float y, float z) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        vertices.method_56824(matrix, x, y, z).method_1336(r, g, b, a).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrix, 0.0f, 1.0f, 0.0f);
    }

    public static void renderTexturedCube(class_4587 matrices, class_4588 vertices, class_2338 center, float inflation, class_241 timeOffset, float tileSize) {
        class_4587.class_4665 entry = matrices.method_23760();
        float x0 = (float)center.method_10263() + 0.5f - inflation;
        float x1 = (float)center.method_10263() + 0.5f + inflation;
        float y0 = (float)center.method_10264() + 0.5f - inflation;
        float y1 = (float)center.method_10264() + 0.5f + inflation;
        float z0 = (float)center.method_10260() + 0.5f - inflation;
        float z1 = (float)center.method_10260() + 0.5f + inflation;
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        u0 *= tileSize;
        u1 *= tileSize;
        v0 *= tileSize;
        v1 *= tileSize;
        float textureOffsetX = timeOffset.field_1343;
        float textureOffsetY = timeOffset.field_1342;
        RenderUtils.renderQuad(entry, vertices, x0, y0, z1, x1, y0, z1, x1, y1, z1, x0, y1, z1, u0 += textureOffsetY, v0 += textureOffsetX, u1 += textureOffsetY, v1 += textureOffsetX);
        RenderUtils.renderQuad(entry, vertices, x1, y0, z0, x0, y0, z0, x0, y1, z0, x1, y1, z0, u0, v0, u1, v1);
        RenderUtils.renderQuad(entry, vertices, x0, y0, z0, x0, y0, z1, x0, y1, z1, x0, y1, z0, u0, v0, u1, v1);
        RenderUtils.renderQuad(entry, vertices, x1, y0, z1, x1, y0, z0, x1, y1, z0, x1, y1, z1, u0, v0, u1, v1);
        RenderUtils.renderQuad(entry, vertices, x0, y1, z1, x1, y1, z1, x1, y1, z0, x0, y1, z0, u0, v0, u1, v1);
        RenderUtils.renderQuad(entry, vertices, x0, y0, z0, x1, y0, z0, x1, y0, z1, x0, y0, z1, u0, v0, u1, v1);
    }

    private static void renderQuad(class_4587.class_4665 matrix, class_4588 vertices, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2) {
        RenderUtils.renderVertex(matrix, vertices, x1, y1, z1, u1, v1);
        RenderUtils.renderVertex(matrix, vertices, x2, y2, z2, u2, v1);
        RenderUtils.renderVertex(matrix, vertices, x3, y3, z3, u2, v2);
        RenderUtils.renderVertex(matrix, vertices, x4, y4, z4, u1, v2);
    }

    private static void renderVertex(class_4587.class_4665 matrix, class_4588 vertices, float x, float y, float z, float u, float v) {
        vertices.method_56824(matrix, x, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrix, 0.0f, 1.0f, 0.0f);
    }

    public static void renderTexturedSphere(class_4587 matrices, class_4588 vertices, class_2338 center, float radius, int quality, float rotation) {
        float inflation = 1.0f;
        radius *= inflation;
        matrices.method_46416((float)center.method_10263(), (float)center.method_10264(), (float)center.method_10260());
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotation));
        for (int i = 0; i < quality; ++i) {
            float lat1 = (float)Math.PI * (-0.5f + (float)i / (float)quality);
            float lat2 = (float)Math.PI * (-0.5f + (float)(i + 1) / (float)quality);
            for (int j = 0; j < quality; ++j) {
                float lon1 = (float)(Math.PI * 2 * (double)j / (double)quality);
                float lon2 = (float)(Math.PI * 2 * (double)(j + 1) / (double)quality);
                float x1 = (float)((double)radius * Math.cos(lat1) * Math.cos(lon1));
                float y1 = (float)((double)radius * Math.sin(lat1));
                float z1 = (float)((double)radius * Math.cos(lat1) * Math.sin(lon1));
                float u1 = 1.0f - lon1 / ((float)Math.PI * 2);
                float v1 = 1.0f - (lat1 + 1.5707964f) / (float)Math.PI;
                float x2 = (float)((double)radius * Math.cos(lat1) * Math.cos(lon2));
                float y2 = y1;
                float z2 = (float)((double)radius * Math.cos(lat1) * Math.sin(lon2));
                float u2 = 1.0f - lon2 / ((float)Math.PI * 2);
                float v2 = v1;
                float x3 = (float)((double)radius * Math.cos(lat2) * Math.cos(lon2));
                float y3 = (float)((double)radius * Math.sin(lat2));
                float z3 = (float)((double)radius * Math.cos(lat2) * Math.sin(lon2));
                float u3 = u2;
                float v3 = 1.0f - (lat2 + 1.5707964f) / (float)Math.PI;
                float x4 = (float)((double)radius * Math.cos(lat2) * Math.cos(lon1));
                float y4 = y3;
                float z4 = (float)((double)radius * Math.cos(lat2) * Math.sin(lon1));
                float u4 = u1;
                float v4 = v3;
                RenderUtils.renderQuad(matrices.method_23760(), vertices, x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, u1, v1, u2, v2, u3, v3, u4, v4);
            }
        }
    }

    private static void renderQuad(class_4587.class_4665 matrix, class_4588 vertices, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2, float u3, float v3, float u4, float v4) {
        RenderUtils.renderVertex(matrix, vertices, x1, y1, z1, u1, v1);
        RenderUtils.renderVertex(matrix, vertices, x2, y2, z2, u2, v2);
        RenderUtils.renderVertex(matrix, vertices, x3, y3, z3, u3, v3);
        RenderUtils.renderVertex(matrix, vertices, x4, y4, z4, u4, v4);
    }

    public static void renderSkyBeam(class_4587 matrices, class_4588 vertices, class_2338 center, float radius, int height, float time) {
        class_4587.class_4665 entry = matrices.method_23760();
        float x = (float)center.method_10263() + 0.5f;
        float z = (float)center.method_10260() + 0.5f;
        float yStart = center.method_10264();
        float yEnd = yStart + (float)height;
        float angle = time * 0.2f % 1.0f;
        float r = radius;
        float[][] corners = new float[][]{{x - r, z - r}, {x + r, z - r}, {x + r, z + r}, {x - r, z + r}};
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = angle;
        float v1 = angle + (float)height / 8.0f;
        for (int i = 0; i < 4; ++i) {
            float[] corner1 = corners[i];
            float[] corner2 = corners[(i + 1) % 4];
            RenderUtils.renderBeamQuad(entry, vertices, corner1[0], yStart, corner1[1], corner2[0], yStart, corner2[1], corner2[0], yEnd, corner2[1], corner1[0], yEnd, corner1[1], u0, v0, u1, v1);
        }
    }

    private static void renderBeamQuad(class_4587.class_4665 matrix, class_4588 vertices, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float u1, float v1, float u2, float v2) {
        RenderUtils.renderVertex(matrix, vertices, x1, y1, z1, u1, v1);
        RenderUtils.renderVertex(matrix, vertices, x2, y2, z2, u2, v1);
        RenderUtils.renderVertex(matrix, vertices, x3, y3, z3, u2, v2);
        RenderUtils.renderVertex(matrix, vertices, x4, y4, z4, u1, v2);
    }

    public static void renderCone(class_4587 matrices, class_4588 vertices, class_2338 center, float radius, int height, float time) {
        class_4587.class_4665 entry = matrices.method_23760();
        float x = (float)center.method_10263() + 0.5f;
        float z = (float)center.method_10260() + 0.5f;
        float yBase = center.method_10264();
        float yTip = yBase + (float)height;
        float angleOffset = time * 0.2f % 1.0f;
        float u0 = 0.0f;
        float u1 = 1.0f;
        int segments = 16;
        for (int i = 0; i < segments; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)segments;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)segments;
            float x1 = x + (float)Math.cos(angle1) * radius;
            float z1 = z + (float)Math.sin(angle1) * radius;
            float x2 = x + (float)Math.cos(angle2) * radius;
            float z2 = z + (float)Math.sin(angle2) * radius;
            float v0 = angleOffset;
            float v1 = angleOffset + (float)height / 8.0f;
            RenderUtils.renderBeamQuad(entry, vertices, x1, yBase, z1, x2, yBase, z2, x, yTip, z, x, yTip, z, u0, v0, u1, v1);
        }
    }

    public static void renderEntityTrail(class_4587 matrices, class_4588 vertexConsumer, class_4184 camera, class_1297 entity, float tickDelta, Deque<class_243> trailPositions, int maxTrailLength, float startWidth, float endWidth, int endAlpha, int startAlpha, float red, float green, float blue, class_243 offset) {
        class_243 currentPos = new class_243(class_3532.method_16436((double)tickDelta, (double)entity.field_6014, (double)entity.method_23317()), class_3532.method_16436((double)tickDelta, (double)entity.field_6036, (double)entity.method_23318()), class_3532.method_16436((double)tickDelta, (double)entity.field_5969, (double)entity.method_23321())).method_1019(offset);
        trailPositions.addFirst(currentPos);
        while (trailPositions.size() > maxTrailLength) {
            trailPositions.removeLast();
        }
        if (trailPositions.size() < 2) {
            return;
        }
        class_243 camPos = camera.method_19326();
        ArrayList<class_243> positions = new ArrayList<class_243>(trailPositions);
        matrices.method_22903();
        matrices.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
        class_4587.class_4665 matrixEntry = matrices.method_23760();
        class_243 lastA = null;
        class_243 lastB = null;
        for (int i = 0; i < positions.size() - 1; ++i) {
            class_243 toCamera;
            class_243 p1 = (class_243)positions.get(i);
            class_243 p2 = (class_243)positions.get(i + 1);
            float t = (float)i / (float)(positions.size() - 2);
            float width = class_3532.method_16439((float)t, (float)startWidth, (float)endWidth);
            int alpha = class_3532.method_48781((float)t, (int)startAlpha, (int)endAlpha);
            alpha = class_3532.method_15340((int)alpha, (int)0, (int)255);
            class_243 segmentDir = p2.method_1020(p1).method_1029();
            class_243 camRight = segmentDir.method_1036(toCamera = p1.method_1020(camPos).method_1029());
            if (camRight.method_1027() < 1.0E-6 && (camRight = segmentDir.method_1036(new class_243(1.0, 0.0, 0.0))).method_1027() < 1.0E-6) {
                camRight = new class_243(0.0, 0.0, 1.0);
            }
            camRight = camRight.method_1029().method_1021((double)width);
            class_243 p1a = p1.method_1019(camRight);
            class_243 p1b = p1.method_1020(camRight);
            class_243 p2a = p2.method_1019(camRight);
            class_243 p2b = p2.method_1020(camRight);
            float u1 = 0.0f;
            float u2 = 1.0f;
            float v1 = (float)i / (float)(positions.size() - 1);
            float v2 = (float)(i + 1) / (float)(positions.size() - 1);
            if (lastA != null && lastB != null) {
                RenderUtils.renderVertex(matrixEntry, vertexConsumer, (float)lastA.field_1352, (float)lastA.field_1351, (float)lastA.field_1350, u1, v1, alpha, red, green, blue);
                RenderUtils.renderVertex(matrixEntry, vertexConsumer, (float)lastB.field_1352, (float)lastB.field_1351, (float)lastB.field_1350, u2, v1, alpha, red, green, blue);
                RenderUtils.renderVertex(matrixEntry, vertexConsumer, (float)p1b.field_1352, (float)p1b.field_1351, (float)p1b.field_1350, u2, v2, alpha, red, green, blue);
                RenderUtils.renderVertex(matrixEntry, vertexConsumer, (float)p1a.field_1352, (float)p1a.field_1351, (float)p1a.field_1350, u1, v2, alpha, red, green, blue);
            }
            lastA = p1a;
            lastB = p1b;
        }
        matrices.method_22909();
    }

    private static void renderVertex(class_4587.class_4665 matrix, class_4588 vertices, float x, float y, float z, float u, float v, float alpha, float red, float green, float blue) {
        vertices.method_56824(matrix, x, y, z).method_22915(red, green, blue, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrix, 0.0f, 1.0f, 0.0f);
    }
}

