/*
 * Decompiled with CFR 0.152.
 */
package com.nitron.nitrogen.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nitron.nitrogen.Nitrogen;
import com.nitron.nitrogen.util.interfaces.PlayerInfo;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;

public abstract class SupporterUtils {
    private List<PlayerInfo> cachedPlayers = new ArrayList<PlayerInfo>();
    private long lastFetchTime = 0L;

    protected SupporterUtils() {
    }

    public List<PlayerInfo> fetchPlayers() {
        long now = System.currentTimeMillis();
        long CACHE_DURATION = 300000L;
        if (!this.cachedPlayers.isEmpty() && now - this.lastFetchTime < CACHE_DURATION) {
            return this.cachedPlayers;
        }
        ArrayList<PlayerInfo> players = new ArrayList<PlayerInfo>();
        try {
            HttpURLConnection connection = (HttpURLConnection)this.getURL().openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            if (connection.getResponseCode() == 200) {
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (jsonObject.has("players") && jsonObject.get("players").isJsonArray()) {
                    JsonArray playerArray = jsonObject.getAsJsonArray("players");
                    for (JsonElement element : playerArray) {
                        JsonObject playerObj = element.getAsJsonObject();
                        String uuid = playerObj.get("uuid").getAsString();
                        String username = playerObj.get("username").getAsString();
                        players.add(new PlayerInfo(uuid, username));
                    }
                    this.cachedPlayers = players;
                    this.lastFetchTime = now;
                } else {
                    Nitrogen.LOGGER.error("Error: 'players' field is missing or not an array for " + this.getId());
                }
                reader.close();
            } else {
                Nitrogen.LOGGER.error("HTTP Error: " + connection.getResponseCode());
            }
            connection.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.cachedPlayers;
    }

    protected abstract String getId();

    protected abstract URL getURL() throws MalformedURLException;

    protected abstract boolean requiredSupporter();

    public boolean isPlayerSupporter(class_1657 player) {
        for (PlayerInfo playerInfo : this.fetchPlayers()) {
            if (!player.method_5845().equals(playerInfo.uuid())) continue;
            return true;
        }
        return false;
    }
}

