let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

function getDamageSourceBothSides(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType,
    /** @type {Internal.LivingEntity}*/ destEntity,
    /** @type {Internal.LivingEntity}*/ sourceEntity
    ) {
    var resourceKey = $ResourceKey_.create(DAMAGE_TYPE_KEY, Utils.id(damageType))
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE_KEY).getHolderOrThrow(resourceKey)
    var damagesourceholder = holder
    return new DamageSource(damagesourceholder, sourceEntity, destEntity)
}

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('p_sing:aoe_knockback')
    .icon(palladium.createItemIcon('minecraft:shield'))
    .addProperty("knockback_strength", "float", 3.0, "Knockback strength")
    .tick((entity, entry, holder, enabled) => global.doShove(entity, entry, holder, enabled))
});

global.doShove = (entity, entry, holder, enabled) => {
    if (enabled) {
        let myBoundingBox = entity.getBoundingBox().inflate(8); // Increase radius
        entity.getLevel().getEntitiesWithin(myBoundingBox).forEach(target => {
            if (target == entity) return;

            let dx = target.getX() - entity.getX();
            let dy = target.getY() - entity.getY();
            let dz = target.getZ() - entity.getZ();
            let dist = Math.sqrt((dx * dx) + (dy * dy) + (dz * dz));

            if (dist === 0) return;
            
            let knockbackStrength = entry.getPropertyByName("knockback_strength")
            let vx = (dx / dist) * knockbackStrength;
            let vy = ((dy / dist) * knockbackStrength) + 0.8;
            let vz = (dz / dist) * knockbackStrength;
            target.setMotion(vx, vy, vz);
            if (target.isPlayer()) {
                target.connection.send(new ClientboundSetEntityMotionPacket(target));
            }
            let damageSource = getDamageSourceBothSides(entity.getLevel(), "minecraft:player_attack", entity, target)
            target.attack(damageSource, 8)
        });
    }
}
