StartupEvents.registry('palladium:abilities', (event) => {
    event.create('p_sing:aura_manip_copy')
        .icon(palladium.createItemIcon('minecraft:diamond'))
        .tick((entity, entry, holder, enabled) => {
            if(enabled) {
             let maxSteal  = palladium.scoreboard.getScore(entity, "AuraManipulation.MaxSteal", 3);
            let stolen = palladium.scoreboard.getScore(entity, "AuraManipulation.StolenPowers", 0);
            if(stolen >= maxSteal) { return; }

            const radius = 20
            const targets = entity.serverLevel().getEntities(entity, AABB.ofSize(entity.position(), radius, radius, radius)).toArray();
            for (let j = 0; j < targets.length; j++) {
                let box = AABB.ofSize(entity.position(), radius, radius, radius);
                let entities = entity.serverLevel().getEntities(entity, box).toArray();
                for (let i = 0; i < entities.length; i++) {
                    if (entities[i] !== entity && entities[i].type !== "minecraft:item" && entities[i].type !== "minecraft:item_frame" && entities[i].type !== "minecraft:glow_item_frame" && entities[i].type !== "minecraft:armor_stand" && entities[i].type !== "palladium:suit_stand") {
                        //entity.server.runCommandSilent("execute as " + entities[i].uuid + " at @s run damage @s " + damage + " " + damage_type + " by " + entity.uuid);
                        copy(entity, entities[i]);
                    }
                }
            }
        }
        })
});

function copy(caster, target) {
    const copyablePowers = ['p_sing:afterimage', 'p_sing:aura_propulsion', 'p_sing:arachnae', 'p_sing:atom', 'p_sing:atlas', 'p_sing:barrier', 'p_sing:berserk_wings', 'p_sing:botanist', 'p_sing:bubble', 'p_sing:clairvoyance', 'p_sing:clutch',  'p_sing:darkness', 'p_sing:deku', 'p_sing:demon_claws', 'p_sing:demonism', 'p_sing:energy_discharge', 'p_sing:equinox', 'p_sing:eroder', 'p_sing:healer', 'p_sing:hide', 'p_sing:hornet', 'p_sing:hydro-freeze', 'p_sing:hypertrophic', 'p_sing:hypnosis', 'p_sing:immortality', 'p_sing:kaboom', 'p_sing:laser_emission', 'p_sing:light', 'p_sing:lightning', 'p_sing:manifess', 'p_sing:mariner', 'p_sing:metal', 'p_sing:nightmare', 'p_sing:particles', 'p_sing:phantom', 'p_sing:phase_shift', 'p_sing:planar', 'p_sing:psionic', 'p_sing:psycho', 'p_sing:pulse', 'p_sing:rabbit', 'p_sing:reactor', 'p_sing:rulebreaker', 'p_sing:shark', 'p_sing:solar', 'p_sing:shadow_flame', 'p_sing:sonic_manip', 'p_sing:strength', 'p_sing:sublimation', 'p_sing:teleporter', 'p_sing:thermal', 'p_sing:time', 'p_sing:tremor', 'p_sing:unbreakable', 'p_sing:voltguard', 'p_sing:warp', 'p_sing:whirlwind',]
    let powers = palladium.powers.getPowerIdsForNamespace(target, "p_sing")
    for(let k = 0; k < powers.length; k++) {
        let power = powers[k]
        if(copyablePowers.includes(power.toString())) {
            let powerName = `${power}`
            powerName = powerName.split(":")
            powerName[powerName.length - 1] = powerName[powerName.length - 1].split("_").map(word => word.charAt(0).toUpperCase() + word.slice(1)).join(" ")
            palladium.superpowers.addSuperpower(caster, power)
        }
    }
}