(function () {
    // Register the custom ability
    StartupEvents.registry('palladium:abilities', (event) => {
        event.create('p_sing:grant_effect')

            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
            .addProperty('range', 'float', 10.0, 'The range within which the effect will be granted')
            .addProperty('effect', 'string', 'minecraft:slowness', 'The effect to grant to the target')
            .addProperty('effect_duration', 'integer', 5, 'The duration of the effect in ticks')
            .addProperty('effect_amplifier', 'integer', 1, 'The amplifier of the effect')
            .addProperty('effect_particles', 'boolean', false, 'Whether the effect shows particles')

            // Every tick, check for nearby targets and apply the effect
            .tick((entity, entry, holder, enabled) => {
                if (enabled) {
                    const range = entry.getPropertyByName('range');
                    const effect = entry.getPropertyByName('effect');
                    const effect_duration = entry.getPropertyByName('effect_duration');
                    const effect_amplifier = entry.getPropertyByName('effect_amplifier');
                    const effect_particles = !!entry.getPropertyByName('effect_particles'); // force to primitive boolean
                    
                    let target = entity.rayTrace(range).entity;
                    if (target && target.isAlive() && target !== entity) {
                        // `false` is for ambient, `effect_particles` for showing particles
                        target.potionEffects.add(effect, effect_duration, effect_amplifier, false, effect_particles);
                    }
                }
            });
    });
})();
