(function () {
    StartupEvents.registry('palladium:abilities', event => {
        event.create('p_sing:power_detection')
            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
            .addProperty('range', 'float', 10.0, 'The range within which the effect will be granted')

            .tick((entity, entry, holder, enabled) => {
                if (!enabled) return;

                let range = entry.getPropertyByName('range');
                let target = entity.rayTrace(range).entity;

                let blacklist = [
                    'p_sing:effects/charged',
                    'p_sing:effects/dampened',
                    'p_sing:effects/decimated',
                    'p_sing:effects/disorientated',
                    'p_sing:effects/downwards',
                    'p_sing:effects/drowned',
                    'p_sing:effects/energy_shock',
                    'p_sing:effects/esper_telekinesis',
                    'p_sing:effects/exhaustion',
                    'p_sing:effects/exploded',
                    'p_sing:effects/feared',
                    'p_sing:effects/freeze',
                    'p_sing:effects/frozen',
                    'p_sing:effects/implosion',
                    'p_sing:effects/matter_warning',
                    'p_sing:effects/molecule_unstable',
                    'p_sing:effects/overheated',
                    'p_sing:effects/poison',
                    'p_sing:effects/pushed',
                    'p_sing:effects/shadow_marked',
                    'p_sing:effects/shocked',
                    'p_sing:effects/shutdown',
                    'p_sing:effects/soaked',
                    'p_sing:effects/soul_snatch',
                    'p_sing:effects/spectrum',
                    'p_sing:effects/telekinesis_throw',
                    'p_sing:effects/thunder_shock',
                    'p_sing:effects/time_forward',
                    'p_sing:effects/time_slow',
                    'p_sing:effects/time_stop',
                    'p_sing:effects/titan_death',
                ];

                if (target && target.isAlive() && target != entity) {
                    let powers = palladium.powers.getPowerIds(target);
                    let hasHelmet = powers.some(p => p.toString() === 'p_sing:joker_mask');

                    if (hasHelmet) {
                        entity.server.runCommandSilent(`execute as ${entity.name.string} run tellraw @s [{"text":"Player: ","color":"gray"},{"text":"Undetectable","color":"white"}]`);
                        entity.server.runCommandSilent(`execute as ${entity.name.string} run tellraw @s [{"text":"Power: ","color":"gray"},{"text":"Undetectable","color":"light_blue"}]`);
                        return;
                    }

                    entity.server.runCommandSilent(`execute as ${entity.name.string} run tellraw @s [{"text":"Player: ","color":"gray"},{"text":"${target.name.string}","color":"white"}]`);

                    powers.forEach(power => {
                        let powerId = power.toString();
                        if (!blacklist.includes(powerId)) {
                            entity.server.runCommandSilent(`execute as ${entity.name.string} run tellraw @s [{"text":"Power: ","color":"gray"},{"text":"${powerId}","color":"light_blue"}]`);
                        }
                    });
                }
            });
    });
})();
