PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/ground_pound', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:strength", "ground_pound")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:strength', 'ground_pound', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('head')
                    .setX(0)
                    .setY(0.5)
                    .setZ(-2)
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setX(-4)
                    .setY(5)
                    .setZ(-3)
                    .setXRotDegrees(0)
                    .setYRotDegrees(-77.5)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(54)
                    .setYRotDegrees(-12)
                    .setZRotDegrees(-16)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(2)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(5)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/telekinesis_minefield_place', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:telekinesis', 'push_point.animation_detonate', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-30).setZRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-50).setZRotDegrees(-40).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-30).setZRotDegrees(50).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-50).setZRotDegrees(40).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/planar', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:planar', 'planar.dimension.animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-30).setZRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-50).setZRotDegrees(-40).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-30).setZRotDegrees(50).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-50).setZRotDegrees(40).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/planar2', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:planar', 'planar.dimension.animation_return', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-30).setZRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-50).setZRotDegrees(-40).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-30).setZRotDegrees(50).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-50).setZRotDegrees(40).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/pulse_dodge', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:pulse", "Reflex.Dodge.First")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:pulse', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(-45).moveZ(1).moveX(-4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(-26)
                    .setZRotDegrees(-3).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(-4)
                    .setZRotDegrees(-4).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:pulse", "Reflex.Dodge.Second")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:pulse', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(45).moveZ(-1).moveX(4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(4)
                    .setZRotDegrees(4).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(26)
                    .setZRotDegrees(3).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(-7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(-5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/time_dodge', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:time", "Reflex.Dodge.First")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:time', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(-45).moveZ(1).moveX(-4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(-26)
                    .setZRotDegrees(-3).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(-4)
                    .setZRotDegrees(-4).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:time", "Reflex.Dodge.Second")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:time', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(45).moveZ(-1).moveX(4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(4)
                    .setZRotDegrees(4).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(26)
                    .setZRotDegrees(3).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(-7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(-5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/spider_dodge', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:arachne", "Reflex.Dodge.First")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:pulse', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(-45).moveZ(1).moveX(-4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(-26)
                    .setZRotDegrees(-3).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(-4)
                    .setZRotDegrees(-4).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:arachne", "Reflex.Dodge.Second")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:arachne', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(45).moveZ(-1).moveX(4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(4)
                    .setZRotDegrees(4).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(26)
                    .setZRotDegrees(3).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(-7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(-5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/restrict_dodge', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:aura_restriction", "Reflex.Dodge.First")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:aura_restriction', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(-45).moveZ(1).moveX(-4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(-26)
                    .setZRotDegrees(-3).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(-4)
                    .setZRotDegrees(-4).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:aura_restriction", "Reflex.Dodge.Second")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:aura_restriction', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(45).moveZ(-1).moveX(4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(4)
                    .setZRotDegrees(4).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(26)
                    .setZRotDegrees(3).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(-7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(-5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }

    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/shark_swim', 15, (builder) => {
        const animation = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:shark', 'shark_swim_animation', builder.getPartialTicks());
        if (animation > 0.0) {
            builder.get('right_arm').setYRotDegrees(0).setZRotDegrees(0).setXRotDegrees(0).rotateX(builder.getModel().rightLeg.xRot * -1)
            builder.get('left_arm').setYRotDegrees(0).setZRotDegrees(0).setXRotDegrees(0).rotateX(builder.getModel().leftLeg.xRot * -1)
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/shark_swim1', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:shark', 'shark_swim_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-80).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/hypnosis_sleep', 1, (builder) => {
        let progress_sleep = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:effects/hypnotized', 'sleep_anim', builder.getPartialTicks());

        if (progress_sleep > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('head')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_sleep);

                builder.get('body')
                    .setZRotDegrees(0)
                    .setXRotDegrees(90)
                    .setYRotDegrees(0)
                    .setZ(-14)
                    .setY(2)
                    .animate('InOutCubic', progress_sleep);

                builder.get('right_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_sleep);

                builder.get('left_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_sleep);

                builder.get('right_leg')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_sleep);

                builder.get('left_leg')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_sleep);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/demon_sleep', 1, (builder) => {
        let progress_sleep = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:effects/condemned', 'sleep_anim', builder.getPartialTicks());

        if (progress_sleep > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('head')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_sleep);

                builder.get('body')
                    .setZRotDegrees(0)
                    .setXRotDegrees(90)
                    .setYRotDegrees(0)
                    .setZ(-14)
                    .setY(2)
                    .animate('InOutCubic', progress_sleep);

                builder.get('right_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_sleep);

                builder.get('left_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_sleep);

                builder.get('right_leg')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_sleep);

                builder.get('left_leg')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutCubic', progress_sleep);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/clairvoyance_dodge', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:clairvoyance", "Reflex.Dodge.First")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:clairvoyance', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(-45).moveZ(1).moveX(-4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(-26)
                    .setZRotDegrees(-3).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(-4)
                    .setZRotDegrees(-4).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:clairvoyance", "Reflex.Dodge.Second")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:clairvoyance', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(45).moveZ(-1).moveX(4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(4)
                    .setZRotDegrees(4).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(26)
                    .setZRotDegrees(3).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(-7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(-5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/psycho_dodge', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:psycho", "Reflex.Dodge.First")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:psycho', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(-45).moveZ(1).moveX(-4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(-26)
                    .setZRotDegrees(-3).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(-4)
                    .setZRotDegrees(-4).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:psycho", "Reflex.Dodge.Second")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:psycho', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(45).moveZ(-1).moveX(4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(4)
                    .setZRotDegrees(4).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(26)
                    .setZRotDegrees(3).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(-7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(-5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/air_smash', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:deku", "air_smash")) {
            const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:deku', 'air_smash', builder.getPartialTicks(), 0, 4);
            if (progress > 0.0 && !builder.isFirstPerson()) {


                builder.get('right_arm')
                    .setZ(4)
                    .setXRotDegrees(-95)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', progress);
                builder.get('left_arm')
                    .setXRotDegrees(-28)
                    .setYRotDegrees(-7)
                    .setZRotDegrees(7)
                    .animate('InOutCubic', progress);
                builder.get('body')
                    .rotateYDegrees(-47)
                    .animate('InOutCubic', progress);
                builder.get('head')
                    .rotateYDegrees(-47)
                    .animate('InOutCubic', progress);
            }
            if (progress > 0.0 && builder.isFirstPerson()) {


                builder.get('right_arm')
                    .setY(-3)
                    .animate('InOutCubic', progress);
            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/soul_beam', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:immortality', 'soul_beam_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('body').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('body').setXRotDegrees(-15).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/gas_spew', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:sublimation', 'gas_spew_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('body').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('body').setXRotDegrees(-15).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/gas_spew_demon', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:demonism', 'gas_spew_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('body').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('body').setXRotDegrees(-15).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/bubble_spew', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:mariner', 'bubble_spew_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('body').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('body').setXRotDegrees(-15).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/sonic_swim', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:mariner', 'sonic_swim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-35).setXRotDegrees(20).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/poison_spew', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:botanist', 'poison_spew_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('body').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('body').setXRotDegrees(-15).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/deku_hands', 10, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:deku", "Punch.First")) {
            if (!builder.isFirstPerson()) {
                const halfPi = 1.57079632679;

                builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(2) //backwards and forwards
                    .translateY(6) //up and down
                    .translateX(6); // left and right

                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(-2) //backwards and forwards
                    .translateY(-1.5) //up and down
                    .translateX(-7); // left and right
            }
            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(-32)
                    .setZRotDegrees(-33)
                    .setY(0.5)
                    .setX(-4.5)
                    .setZ(2);

                builder.get('left_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(32)
                    .setZRotDegrees(33)
                    .setY(-4)
                    .setX(3)
                    .setZ(4);
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/deku_hands2', 10, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:deku", "Punch.Second")) {
            if (!builder.isFirstPerson()) {
                const halfPi = 1.57079632679;

                builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(-2) //backwards and forwards
                    .translateY(-1.5) //up and down
                    .translateX(7); // left and right

                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(2) //backwards and forwards
                    .translateY(6) //up and down
                    .translateX(-6); // left and right
            }
            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(-32.5)
                    .setZRotDegrees(-33)
                    .setY(-4)
                    .setX(-3)
                    .setZ(4);

                builder.get('left_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(32.5)
                    .setZRotDegrees(33)
                    .setY(0.5)
                    .setX(4.5)
                    .setZ(2);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/barrage_hands', 10, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:afterimage", "Punch.First")) {
            if (!builder.isFirstPerson()) {
                const halfPi = 1.57079632679;

                builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(2) //backwards and forwards
                    .translateY(6) //up and down
                    .translateX(6); // left and right

                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(-2) //backwards and forwards
                    .translateY(-1.5) //up and down
                    .translateX(-7); // left and right
            }
            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(-32)
                    .setZRotDegrees(-33)
                    .setY(0.5)
                    .setX(-4.5)
                    .setZ(2);

                builder.get('left_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(32)
                    .setZRotDegrees(33)
                    .setY(-4)
                    .setX(3)
                    .setZ(4);
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/barrage_hands2', 10, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:afterimage", "Punch.Second")) {
            if (!builder.isFirstPerson()) {
                const halfPi = 1.57079632679;

                builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(-2) //backwards and forwards
                    .translateY(-1.5) //up and down
                    .translateX(7); // left and right

                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(2) //backwards and forwards
                    .translateY(6) //up and down
                    .translateX(-6); // left and right
            }
            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(-32.5)
                    .setZRotDegrees(-33)
                    .setY(-4)
                    .setX(-3)
                    .setZ(4);

                builder.get('left_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(32.5)
                    .setZRotDegrees(33)
                    .setY(0.5)
                    .setX(4.5)
                    .setZ(2);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/barrage_hands_restricted', 10, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:aura_restriction", "Punch.First")) {
            if (!builder.isFirstPerson()) {
                const halfPi = 1.57079632679;

                builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(2) //backwards and forwards
                    .translateY(6) //up and down
                    .translateX(6); // left and right

                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(-2) //backwards and forwards
                    .translateY(-1.5) //up and down
                    .translateX(-7); // left and right
            }
            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(-32)
                    .setZRotDegrees(-33)
                    .setY(0.5)
                    .setX(-4.5)
                    .setZ(2);

                builder.get('left_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(32)
                    .setZRotDegrees(33)
                    .setY(-4)
                    .setX(3)
                    .setZ(4);
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/barrage_hands_restricted2', 10, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:aura_restriction", "Punch.Second")) {
            if (!builder.isFirstPerson()) {
                const halfPi = 1.57079632679;

                builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(-2) //backwards and forwards
                    .translateY(-1.5) //up and down
                    .translateX(7); // left and right

                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(2) //backwards and forwards
                    .translateY(6) //up and down
                    .translateX(-6); // left and right
            }
            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(-32.5)
                    .setZRotDegrees(-33)
                    .setY(-4)
                    .setX(-3)
                    .setZ(4);

                builder.get('left_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(32.5)
                    .setZRotDegrees(33)
                    .setY(0.5)
                    .setX(4.5)
                    .setZ(2);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/mariner_sink', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:mariner', 'sink_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/phase_hands', 10, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:phase_shift", "Punch.First_Phase")) {
            if (!builder.isFirstPerson()) {
                const halfPi = 1.57079632679;

                builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(2) //backwards and forwards
                    .translateY(6) //up and down
                    .translateX(6); // left and right

                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(-2) //backwards and forwards
                    .translateY(-1.5) //up and down
                    .translateX(-7); // left and right
            }
            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(-32)
                    .setZRotDegrees(-33)
                    .setY(0.5)
                    .setX(-4.5)
                    .setZ(2);

                builder.get('left_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(32)
                    .setZRotDegrees(33)
                    .setY(-4)
                    .setX(3)
                    .setZ(4);
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/phase_hands2', 10, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:phase_shift", "Punch.Second_Phase")) {
            if (!builder.isFirstPerson()) {
                const halfPi = 1.57079632679;

                builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(-2) //backwards and forwards
                    .translateY(-1.5) //up and down
                    .translateX(7); // left and right

                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(2) //backwards and forwards
                    .translateY(6) //up and down
                    .translateX(-6); // left and right
            }
            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(-32.5)
                    .setZRotDegrees(-33)
                    .setY(-4)
                    .setX(-3)
                    .setZ(4);

                builder.get('left_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(32.5)
                    .setZRotDegrees(33)
                    .setY(0.5)
                    .setX(4.5)
                    .setZ(2);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/hydro_spin', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:hydro-freeze", "water_spout")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:hydro-freeze', 'water_spout', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {

                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/web_spin', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:arachne", "web_spin")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:arachne', 'web_spin', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {

                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/typhoon', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:mariner", "typhoon")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:mariner', 'typhoon', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {

                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/charge_shark', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:shark", "charge")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:shark', 'charge', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {

                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/wind_spin', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:whirlwind", "wind_spin")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:whirlwind', 'wind_spin', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {

                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/gas_spin', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:sublimation", "gas_vortex")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:sublimation', 'gas_vortex', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {

                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/ice_spin', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:hydro-freeze", "blizzard")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:hydro-freeze', 'blizzard', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {

                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/luna_spin', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:rabbit", "luna_spin")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:rabbit', 'luna_spin', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {
                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/demon_claws2', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:demon_claws', 'demon_leap2', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-95).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-95).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(15).moveZ(-2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(25).moveZ(-2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/lunge_touch', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:eroder', 'lunge_touch', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-95).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-95).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/fiery_burst', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:thermal', 'fire_burst', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-95).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-95).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/time_stop', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:time', 'time_stop', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(-8).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-18).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/eruption', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:shadow_flame', 'eruption', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(-8).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-18).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/electric_absorb', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:voltguard', 'electric_absorb', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/tele_pin_animation', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:telekinesis', 'tele_pin_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/power_expell', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:aura_manipulation', 'power_expell_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/time_reverse_haste', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:time', 'time_haste_reversal_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/sonic_roar', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:mariner', 'sonic_roar', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(-8).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-18).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/dark_world', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:equinox', 'dark_world', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(-8).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-18).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/healing_pulse', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:equinox', 'healing_pulse', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(-8).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-18).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/boom_burst', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:kaboom', 'boom_burst', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/energy_burst', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:energy_discharge', 'energy_burst', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/cinder_burst', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:shadow_flame', 'cinder_burst', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/boom_beam', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:kaboom', 'boom_beam_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-40).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-70).setYRotDegrees(-15).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-40).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-70).setYRotDegrees(15).animate('InOutCubic', progress);
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/water_beam', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:hydro-freeze', 'water_beam_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-40).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-70).setYRotDegrees(-15).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-40).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-70).setYRotDegrees(15).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/ice_beam', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:hydro-freeze', 'ice_beam_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-40).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-70).setYRotDegrees(-15).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-40).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-70).setYRotDegrees(15).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/zeus_anim', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:lightning', 'zeus_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(-8).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-18).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/light_cannon', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:light', 'light_beam_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-18).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/energy_cannon', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:energy_discharge', 'energy_beam_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-18).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/angel_cannon', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:devmon', 'angel_beam_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-18).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/wall_crawl', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:demon_claws', 'wall_crawl_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('easeInOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-140).animate('easeInOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('easeInOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-140).animate('easeInOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/wall_climb', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:deku', 'wall_climb_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('easeInOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-140).animate('easeInOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('easeInOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-140).animate('easeInOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/time_stop_copied', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:aura_manipulation', 'time_stop_copied', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(-8).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-18).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/velocity_cancel', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:velocity', 'velocity_cancel', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/stun_grenade', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:kaboom', 'stun_grenade', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/conceal', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:equinox', 'conceal', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/time_slow', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:time', 'time_slow', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/healing_area', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:healer', 'healing_area', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/bubble_heal_area', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:bubble', 'healing_bubbles', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(70).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-70).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/diablos_area', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:immortality', 'diablos_area', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(70).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-70).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/blossom_area', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:botanist', 'blossom_area', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/rift_area', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:planar', 'rift_area', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(10).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-10).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/molecule_area', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:phantom', 'molecule_area', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/tree_area', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:botanist', 'tree_area', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/toxic_area', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:sublimation', 'gaseous_area', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/melt_down', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:reactor', 'melt_down', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/web_spin2', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:arachne', 'web_spin', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/electric_outburst', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:lightning', 'electric_outburst', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/healing_area_divine', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:messiah', 'healing_area_divine', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/velocity_area_imbue', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:velocity', 'velocity_imbue_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/muscle_pound', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:hypertrophic", "muscle_pound")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:hypertrophic', 'muscle_pound', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('head')
                    .setX(0)
                    .setY(0.5)
                    .setZ(-2)
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setX(-4)
                    .setY(5)
                    .setZ(-3)
                    .setXRotDegrees(0)
                    .setYRotDegrees(-77.5)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(54)
                    .setYRotDegrees(-12)
                    .setZRotDegrees(-16)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(5)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/phobos_crawl', 2, (builder) => {
        let animation = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:nightmare', 'phobos_crawl', builder.getPartialTicks());
        if (animation > 0 && !builder.isFirstPerson() && !builder.getPlayer().isSwimming()) {
            builder.get('body')
                .moveY(12).moveZ(15)
                .setXRotDegrees(-90)

                .animate('InOutCubic', animation);

            builder.get('head')
                .moveZ(-1)
                .rotateXDegrees(-83.5)
                .rotateYDegrees(-180)
                .animate('InOutCubic', animation);

            builder.get('chest')
                .rotateXDegrees(-12.5)
                .animate('InOutCubic', animation);

            builder.get('right_arm')
                .moveZ(-1.5)
                .rotateXDegrees(-90)
                .animate('InOutCubic', animation);

            builder.get('left_arm')
                .moveZ(-1.5)
                .rotateXDegrees(-90)
                .animate('InOutCubic', animation);

            builder.get('right_leg')
                .moveX(-1.5)
                .moveY(1)
                .moveZ(-1)
                .rotateXDegrees(-45)
                .animate('InOutCubic', animation);

            builder.get('left_leg')
                .moveX(1.5)
                .moveY(1)
                .moveZ(-1)
                .rotateXDegrees(-45)
                .animate('InOutCubic', animation);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/restrict_pound', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:aura_restriction", "ground_pound")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:aura_restriction', 'ground_pound', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('head')
                    .setX(0)
                    .setY(0.5)
                    .setZ(-2)
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setX(-4)
                    .setY(5)
                    .setZ(-3)
                    .setXRotDegrees(0)
                    .setYRotDegrees(-77.5)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(54)
                    .setYRotDegrees(-12)
                    .setZRotDegrees(-16)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(5)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/solar_pound', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:solar", "solar_pound")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:solar', 'solar_pound', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('head')
                    .setX(0)
                    .setY(0.5)
                    .setZ(-2)
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setX(-4)
                    .setY(5)
                    .setZ(-3)
                    .setXRotDegrees(0)
                    .setYRotDegrees(-77.5)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(54)
                    .setYRotDegrees(-12)
                    .setZRotDegrees(-16)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(5)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/aero_attraction', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:whirlwind", "aero_attraction")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:whirlwind', 'aero_attraction', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('head')
                    .setX(0)
                    .setY(0.5)
                    .setZ(-2)
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setX(-4)
                    .setY(5)
                    .setZ(-3)
                    .setXRotDegrees(0)
                    .setYRotDegrees(-77.5)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(54)
                    .setYRotDegrees(-12)
                    .setZRotDegrees(-16)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(5)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/warp_wormhole', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:warp", "wormhole")) {
            const progress_buff_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:warp', 'wormhole', builder.getPartialTicks());
            if (progress_buff_1 > 0.0 && !builder.isFirstPerson()) {

                builder.get('head').scaleY(0.02).moveY(26).animate('InOutCubic', progress_buff_1);

                builder.get('chest')
                    .scaleY(0.02).moveY(26).animate('InOutCubic', progress_buff_1);


                builder.get('right_arm')
                    .scaleY(0.02).moveY(25).animate('InOutCubic', progress_buff_1);

                builder.get('left_arm')
                    .scaleY(0.02).moveY(25).animate('InOutCubic', progress_buff_1);

                builder.get('left_leg').scaleY(0.02).moveY(14).animate('InOutCubic', progress_buff_1);

                builder.get('right_leg').scaleY(0.02).moveY(14).animate('InOutCubic', progress_buff_1);
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/shark', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:shark', 'chomp', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(30).setXRotDegrees(10).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-30).setXRotDegrees(10).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('body').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('body').setXRotDegrees(-15).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/titan_pound', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:atlas", "titan_pound")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:atlas', 'titan_pound', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-6)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-3)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(25)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(-25)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(8)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/ground_stomp', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:tremor", "ground_stomp")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:tremor', 'ground_stomp', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-6)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-3)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(25)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(-25)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(8)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/bullet_stomp', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:aura_restriction", "bullet_slam")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:aura_restriction', 'bullet_slam', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-6)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-3)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(25)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(-25)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(8)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/shock_slam', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:voltguard", "shock_slam")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:voltguard', 'shock_slam', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-6)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-3)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(25)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(-25)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(8)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/disintergration_wave', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:eroder", "disintergrate_stomp")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:eroder', 'disintergrate_stomp', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-6)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-3)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(25)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(-25)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(8)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/phantom_slam', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:spectral_hands", "phantom_slam")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:spectral_hands', 'phantom_slam', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(25)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(-25)
                    .animate('InOutCubic', animation_1);
            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/muscle_stomp', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:hypertrophic", "stomp_muscle")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:hypertrophic', 'stomp_muscle', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-6)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-3)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(25)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(-25)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(8)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/concussion_stomp', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:strength", "concussion_stomp")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:strength', 'concussion_stomp', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-6)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-3)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(25)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(-25)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(8)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/downwards_slam', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:strength", "downwards_slam")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:strength', 'downwards_slam', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-6)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-3)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(25)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(-25)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(8)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/transfer_kinetic', 15, (builder) => {
        let animation_block = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:deku', 'transfer_kinetic', builder.getPartialTicks());
        if (animation_block > 0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(-61)
                .animate('InOutCubic', animation_block);

        }
        if (animation_block > 0.0 && builder.isFirstPerson()) {
            // do first-person animations
            builder.get('right_arm').setXRotDegrees(-85).setYRotDegrees(-60).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
        } else {
            // do third-person animations
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/severance', 15, (builder) => {
        let animation_block = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:psycho', 'severance', builder.getPartialTicks());
        if (animation_block > 0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(-61)
                .animate('InOutCubic', animation_block);

        }
        if (animation_block > 0.0 && builder.isFirstPerson()) {
            // do first-person animations
            builder.get('right_arm').setXRotDegrees(-85).setYRotDegrees(-60).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
        } else {
            // do third-person animations
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/bullet_slam', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:strength", "bullet_slam")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:strength', 'bullet_slam', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-6)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-3)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(25)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(-25)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/light_pillar', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:light", "light_pillar")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:light', 'light_pillar', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('head')
                    .setX(0)
                    .setY(0.5)
                    .setZ(-2)
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setX(-4)
                    .setY(5)
                    .setZ(-3)
                    .setXRotDegrees(0)
                    .setYRotDegrees(-77.5)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(54)
                    .setYRotDegrees(-12)
                    .setZRotDegrees(-16)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(5)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/deku_run', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:deku", "home_run")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:deku', 'home_run', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setX(-4)
                    .setY(5)
                    .setZ(-3)
                    .setXRotDegrees(0)
                    .setYRotDegrees(-77.5)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(54)
                    .setYRotDegrees(-12)
                    .setZRotDegrees(-16)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(5)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/decay_lunge', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:eroder", "decay_lunge")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:eroder', 'decay_lunge', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setX(-4)
                    .setY(5)
                    .setZ(-3)
                    .setXRotDegrees(0)
                    .setYRotDegrees(-77.5)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(54)
                    .setYRotDegrees(-12)
                    .setZRotDegrees(-16)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(5)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/accelerant_run', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:afterimage", "accelerant_run")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:afterimage', 'accelerant_run', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(65)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setY(5)
                    .setZ(-2)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setY(5)
                    .setZ(-2)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2)
                    .setY(4)
                    .setZ(5)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2)
                    .setY(5)
                    .setZ(8)
                    .setXRotDegrees(30)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/volt_tackle_run', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:voltguard", "volt_tackle")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:voltguard', 'volt_tackle', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(65)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setY(5)
                    .setZ(-2)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setY(5)
                    .setZ(-2)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2)
                    .setY(4)
                    .setZ(5)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2)
                    .setY(5)
                    .setZ(8)
                    .setXRotDegrees(30)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/soul_steal', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:demonism', 'soul_steal_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(120).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-120).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/omen_grant', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:nightmare', 'omen_curse_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(130).setXRotDegrees(-45).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-130).setXRotDegrees(-45).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/time_accelerate', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:time', 'time_accelerate_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(120).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-120).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/power_copy', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:aura_manipulation', 'power_copy_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(120).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-120).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/quantum_run', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:phantom", "quantum_run")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:phantom', 'quantum_run', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(65)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setY(5)
                    .setZ(-2)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setY(5)
                    .setZ(-2)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2)
                    .setY(4)
                    .setZ(5)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2)
                    .setY(5)
                    .setZ(8)
                    .setXRotDegrees(30)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/wing_propell_leap', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "p_sing:berserk_wings", "wing_propell_leap")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:berserk_wings', 'wing_propell_leap', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setX(-4)
                    .setY(5)
                    .setZ(-3)
                    .setXRotDegrees(0)
                    .setYRotDegrees(-77.5)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(54)
                    .setYRotDegrees(-12)
                    .setZRotDegrees(-16)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(5)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/muscle_block', 15, (builder) => {
        let animation_block = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:hypertrophic', 'muscle_block', builder.getPartialTicks());
        if (animation_block > 0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(-50)
                .setZRotDegrees(-70)
                .animate('InOutCubic', animation_block);

            builder.get('left_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(50)
                .setZRotDegrees(70)
                .animate('InOutCubic', animation_block);

        }
        if (animation_block > 0.0 && builder.isFirstPerson()) {
            // do first-person animations
            builder.get('right_arm').setXRotDegrees(-55).setYRotDegrees(15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
            builder.get('left_arm').setXRotDegrees(-55).setYRotDegrees(-15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
        } else {
            // do third-person animations
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/titan_block', 15, (builder) => {
        let animation_block = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:atlas', 'titan_block', builder.getPartialTicks());
        if (animation_block > 0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(-50)
                .setZRotDegrees(-70)
                .animate('InOutCubic', animation_block);

            builder.get('left_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(50)
                .setZRotDegrees(70)
                .animate('InOutCubic', animation_block);

        }
        if (animation_block > 0.0 && builder.isFirstPerson()) {
            // do first-person animations
            builder.get('right_arm').setXRotDegrees(-55).setYRotDegrees(15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
            builder.get('left_arm').setXRotDegrees(-55).setYRotDegrees(-15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
        } else {
            // do third-person animations
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/phase_block', 15, (builder) => {
        let animation_block = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:phase_shift', 'phase_block', builder.getPartialTicks());
        if (animation_block > 0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(-50)
                .setZRotDegrees(-70)
                .animate('InOutCubic', animation_block);

            builder.get('left_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(50)
                .setZRotDegrees(70)
                .animate('InOutCubic', animation_block);

        }
        if (animation_block > 0.0 && builder.isFirstPerson()) {
            // do first-person animations
            builder.get('right_arm').setXRotDegrees(-55).setYRotDegrees(15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
            builder.get('left_arm').setXRotDegrees(-55).setYRotDegrees(-15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
        } else {
            // do third-person animations
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/metal_block', 15, (builder) => {
        let animation_block = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:metal', 'metal_block', builder.getPartialTicks());
        if (animation_block > 0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(-50)
                .setZRotDegrees(-70)
                .animate('InOutCubic', animation_block);

            builder.get('left_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(50)
                .setZRotDegrees(70)
                .animate('InOutCubic', animation_block);

        }
        if (animation_block > 0.0 && builder.isFirstPerson()) {
            // do first-person animations
            builder.get('right_arm').setXRotDegrees(-55).setYRotDegrees(15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
            builder.get('left_arm').setXRotDegrees(-55).setYRotDegrees(-15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
        } else {
            // do third-person animations
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/erosion_block', 15, (builder) => {
        let animation_block = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:eroder', 'erosion_block', builder.getPartialTicks());
        if (animation_block > 0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(-50)
                .setZRotDegrees(-70)
                .animate('InOutCubic', animation_block);

            builder.get('left_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(50)
                .setZRotDegrees(70)
                .animate('InOutCubic', animation_block);

        }
        if (animation_block > 0.0 && builder.isFirstPerson()) {
            // do first-person animations
            builder.get('right_arm').setXRotDegrees(-55).setYRotDegrees(15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
            builder.get('left_arm').setXRotDegrees(-55).setYRotDegrees(-15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
        } else {
            // do third-person animations
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/wing_block', 15, (builder) => {
        let animation_block = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:berserk_wings', 'wing_block', builder.getPartialTicks());
        if (animation_block > 0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(-50)
                .setZRotDegrees(-70)
                .animate('InOutCubic', animation_block);

            builder.get('left_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(50)
                .setZRotDegrees(70)
                .animate('InOutCubic', animation_block);

        }
        if (animation_block > 0.0 && builder.isFirstPerson()) {
            // do first-person animations
            builder.get('right_arm').setXRotDegrees(-55).setYRotDegrees(15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
            builder.get('left_arm').setXRotDegrees(-55).setYRotDegrees(-15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
        } else {
            // do third-person animations
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/kinetic_clap', 1, (builder) => {

        let air_clap = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:deku', 'kinetic_clap', builder.getPartialTicks(), 6, 9);
        if (air_clap > 0 && !builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(30)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(-30)
                .animate('InOutCubic', air_clap);

        }
        if (air_clap > 0.0 && builder.isFirstPerson()) {
            builder.get('left_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(70)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(-70)
                .animate('InOutCubic', air_clap);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/afterimage_clap', 1, (builder) => {

        let air_clap = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:afterimage', 'hyper_clap', builder.getPartialTicks(), 6, 9);
        if (air_clap > 0 && !builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(30)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(-30)
                .animate('InOutCubic', air_clap);

        }
        if (air_clap > 0.0 && builder.isFirstPerson()) {
            builder.get('left_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(70)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(-70)
                .animate('InOutCubic', air_clap);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/power_clap', 1, (builder) => {

        let air_clap = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:aura_restriction', 'power_clap', builder.getPartialTicks(), 6, 9);
        if (air_clap > 0 && !builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(30)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(-30)
                .animate('InOutCubic', air_clap);

        }
        if (air_clap > 0.0 && builder.isFirstPerson()) {
            builder.get('left_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(70)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(-70)
                .animate('InOutCubic', air_clap);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/air_clap_wind', 1, (builder) => {

        let air_clap = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:whirlwind', 'air_clap', builder.getPartialTicks(), 6, 9);
        if (air_clap > 0 && !builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(30)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(-30)
                .animate('InOutCubic', air_clap);

        }
        if (air_clap > 0.0 && builder.isFirstPerson()) {
            builder.get('left_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(70)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(-70)
                .animate('InOutCubic', air_clap);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/psionic_push', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:psionic', 'psionic_push', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-180).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-180).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/cold_clap', 1, (builder) => {

        let air_clap = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:hydro-freeze', 'cold_clap', builder.getPartialTicks(), 6, 9);
        if (air_clap > 0 && !builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(30)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(-30)
                .animate('InOutCubic', air_clap);

        }
        if (air_clap > 0.0 && builder.isFirstPerson()) {
            builder.get('left_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(70)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(-70)
                .animate('InOutCubic', air_clap);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/solar_clap', 1, (builder) => {

        let air_clap = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:solar', 'solar_clap', builder.getPartialTicks(), 6, 9);
        if (air_clap > 0 && !builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(30)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(-30)
                .animate('InOutCubic', air_clap);

        }
        if (air_clap > 0.0 && builder.isFirstPerson()) {
            builder.get('left_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(70)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(-70)
                .animate('InOutCubic', air_clap);
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/solar_flight', 1, (builder) => {
        let progress_flight = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:solar', 'flight_anim', builder.getPartialTicks());

        if (progress_flight > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('right_arm')
                    .setZRotDegrees(15)
                    .animate('InOutCubic', progress_flight);

                builder.get('left_arm')
                    .setZRotDegrees(-15)
                    .animate('InOutCubic', progress_flight);

                builder.get('right_leg')
                    .setZ(-2)
                    .setY(10)
                    .setXRotDegrees(20)
                    .animate('InOutCubic', progress_flight);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('p_sing/air_clap', 1, (builder) => {

        let air_clap = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'p_sing:hypertrophic', 'air_clap', builder.getPartialTicks(), 6, 9);
        if (air_clap > 0 && !builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(30)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(-30)
                .animate('InOutCubic', air_clap);

        }
        if (air_clap > 0.0 && builder.isFirstPerson()) {
            builder.get('left_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(70)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(-70)
                .animate('InOutCubic', air_clap);
        }
    });
});
