
const WeightFullList = [
    { power: 'p_sing:afterimage', weight: 3, name: "After-Image" },
    { power: 'p_sing:atlas', weight: 2, name: "Atlas" },
    { power: 'p_sing:atom', weight: 6, name: "Atomiser" },
    { power: 'p_sing:arachne', weight: 4, name: "Arachne" },
    { power: 'p_sing:aura_manipulation', weight: 0.5, name: "Aura Manipulation" },
    { power: 'p_sing:aura_propulsion', weight: 4, name: "Auratic Propulsion" },
    { power: 'p_sing:aura_restriction', weight: 1, name: "Auratic Restriction" },
    { power: 'p_sing:barrier', weight: 8, name: "Barrier" },
    { power: 'p_sing:botanist', weight: 10, name: "Botanist" },
    { power: 'p_sing:berserk_wings', weight: 7, name: "Berserker Wings" },
    { power: 'p_sing:bubble', weight: 9, name: "Berserker Wings" },
    { power: 'p_sing:clairvoyance', weight: 4, name: "Clairvoyance" },
    { power: 'p_sing:clutch', weight: 9, name: "Clutch" },
    { power: 'p_sing:deku', weight: 2, name: "Accumulation" },
    { power: 'p_sing:demon_claws', weight: 9, name: "Demon Claws" },
    { power: 'p_sing:demonism', weight: 2, name: "Demonism" },
    { power: 'p_sing:energy_discharge', weight: 3, name: "Energy Discharge" },
    { power: 'p_sing:equinox', weight: 2, name: "Equinox" },
    { power: 'p_sing:hornet', weight: 7, name: "Hornet" },
    { power: 'p_sing:hypnosis', weight: 9, name: "Hypnosis" },
    { power: 'p_sing:hydro-freeze', weight: 3, name: "Hydro-freeze" },
    { power: 'p_sing:hypertrophic', weight: 7, name: "Hypertrophic" },
    { power: 'p_sing:healer', weight: 5, name: "Healer" },
    { power: 'p_sing:immortality', weight: 3, name: "Immortality" },
    { power: 'p_sing:kaboom', weight: 2, name: "Explosion" },
    { power: 'p_sing:eroder', weight: 0.5, name: "Eroder" },
    { power: 'p_sing:laser_emission', weight: 10, name: "Laser Emission" },
    { power: 'p_sing:light', weight: 6, name: "Illumination" },
    { power: 'p_sing:lightning', weight: 3, name: "Lightning" },
    { power: 'p_sing:metal', weight: 9, name: "Armour Suit" },
    { power: 'p_sing:mariner', weight: 7, name: "Mariner" },
    { power: 'p_sing:manifest', weight: 8, name: "Manifest" },
    { power: 'p_sing:nightmare', weight: 10, name: "Nightmare" },
    { power: 'p_sing:particles', weight: 1, name: "Particles" },
    { power: 'p_sing:phantom', weight: 5, name: "Phantasmal" },
    { power: 'p_sing:phase_shift', weight: 10, name: "Phase Shift" },
    { power: 'p_sing:planar', weight: 1, name: "Planar" },
    { power: 'p_sing:pulse', weight: 2, name: "Pulse" },
    { power: 'p_sing:psycho', weight: 4, name: "Psycho" },
    { power: 'p_sing:rabbit', weight: 7, name: "Rabbit Mimicry" },
    { power: 'p_sing:reactor', weight: 2, name: "Reactor Core" },
    { power: 'p_sing:shadow_flame', weight: 3, name: "Shadow Flame" },
    { power: 'p_sing:sonic_manip', weight: 4, name: "Sonic Manipulation" },
    { power: 'p_sing:shark', weight: 7, name: "Shark Mimicry" },
    { power: 'p_sing:solar', weight: 2, name: "Solarity" },
    { power: 'p_sing:strength', weight: 2, name: "Super Strength" },
    { power: 'p_sing:sublimation', weight: 8, name: "Sublimation" },
    { power: 'p_sing:teleporter', weight: 8, name: "Teleportation" },
    { power: 'p_sing:telekinesis', weight: 5, name: "Telekinesis" },
    { power: 'p_sing:time', weight: 1, name: "Time Manipulation" },
    { power: 'p_sing:tremor', weight: 6, name: "Tremor" },
    { power: 'p_sing:unbreakable', weight: 8, name: "Unbreakable" },
    { power: 'p_sing:voltguard', weight: 3, name: "Voltguard" },
    { power: 'p_sing:wildcard', weight: 3, name: "Wildcard" },
    { power: 'p_sing:warp', weight: 5, name: "Warp" },
    { power: 'p_sing:whirlwind', weight: 5, name: "Whirlwind" },
];
// Function to pick a random power based on weights
function getRandomPowerW() {
    const totalWeight_Weight = WeightFullList.reduce((acc, power) => acc + power.weight, 0);
    let random = Math.random() * totalWeight_Weight;

    for (const power of WeightFullList) {
        if (random < power.weight) {
            return power;
        }
        random -= power.weight;
    }
}
// Function to get a random score within a given range
function getRandomScoreW(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}
ItemEvents.rightClicked(event => {
    const { player, item, server, hand } = event;

    // Check if the item is "p_sing:random_power"
    if (item.id === 'p_sing:spectrum_potion') {
        // Gives the tags for the powers
        server.runCommandSilent(`execute as ${player.name.string} run tag @s add P_Sing.Has.Power`);
        server.runCommandSilent(`execute as ${player.name.string} run tag @s add P_Sing.Power.Limiter`);
        server.runCommandSilent(`execute at ${player.name.string} run function p_sing:awakening_vfx`);
        server.runCommandSilent(`execute as ${player.name.string} run tellraw @a [{\"selector\":\"@s\",\"bold\":true},{\"text\":\"'s aura was awakened\",\"color\":\"gold\"}]]`);
        server.runCommandSilent(`execute as ${player.name.string} run advancement grant @s only p_sing:almighty`);

        // Remove all existing powers previously
        server.runCommandSilent(`execute as ${player.name.string} run superpower remove p_sing:all`);

        // Assign random power based on weights
        const assignedPower = getRandomPowerW();

        // Assign the player the corresponding power
        superpowerUtil.addSuperpower(player, assignedPower.power);

        // Send a message in the player's chat window
        player.tell(`You have awoken: ${assignedPower.name}`);

        // Remove the item from the player's hand
        player.setItemInHand(hand, item.of('minecraft:air'));


    }
});