
const HighFullList = [
    { power: 'p_sing:afterimage', weight: 5, name: "After-Image" },
    { power: 'p_sing:deku', weight: 5, name: "Accumulation" },
    { power: 'p_sing:demonism', weight: 5, name: "Demonism" },
    { power: 'p_sing:energy_discharge', weight: 8, name: "Energy Discharge" },
    { power: 'p_sing:equinox', weight: 6, name: "Equinox" },
    { power: 'p_sing:hydro-freeze', weight: 6, name: "Hydro-freeze" },
    { power: 'p_sing:kaboom', weight: 7, name: "Explosion" },
    { power: 'p_sing:eroder', weight: 1, name: "Eroder" },
    { power: 'p_sing:lightning', weight: 5, name: "Lightning" },
    { power: 'p_sing:particles', weight: 1, name: "Particles" },
    { power: 'p_sing:phantom', weight: 7, name: "Phantasmal" },
    { power: 'p_sing:planar', weight: 1, name: "Planar" },
    { power: 'p_sing:pulse', weight: 4, name: "Pulse" },
    { power: 'p_sing:reactor', weight: 4, name: "Reactor Core" },
    { power: 'p_sing:shadow_flame', weight: 5, name: "Shadow Flame" },
    { power: 'p_sing:sonic_manip', weight: 7, name: "Sonic Manipulation" },
    { power: 'p_sing:solar', weight: 4, name: "Solarity" },
    { power: 'p_sing:strength', weight: 6, name: "Super Strength" },
    { power: 'p_sing:time', weight: 1, name: "Time Manipulation" },
];
// Function to pick a random power based on weights
function getRandomPowerW() {
    const totalWeight_highfull = HighFullList.reduce((acc, power) => acc + power.weight, 0);
    let random = Math.random() * totalWeight_highfull;

    for (const power of HighFullList) {
        if (random < power.weight) {
            return power;
        }
        random -= power.weight;
    }
}
// Function to get a random score within a given range
function getRandomScoreW(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}
ItemEvents.rightClicked(event => {
    const { player, item, server, hand } = event;

    // Check if the item is "p_sing:random_power"
    if (item.id === 'p_sing:spectrum_potion_aura_manip') {
        // Gives the tags for the powers
        server.runCommandSilent(`execute as ${player.name.string} run tag @s add P_Sing.Has.Power`);
        server.runCommandSilent(`execute as ${player.name.string} run tag @s add P_Sing.Power.Limiter`);
        server.runCommandSilent(`execute at ${player.name.string} run function p_sing:aura_manip/awakening_vfx`);
        server.runCommandSilent(`execute as ${player.name.string} run tellraw @a [{\"selector\":\"@s\",\"bold\":true},{\"text\":\"'s power was rerolled!\",\"color\":\"gold\"}]]`);

        // Remove all existing powers previously
        server.runCommandSilent(`execute as ${player.name.string} run superpower remove p_sing:all`);

        // Assign random power based on weights
        const assignedPower = getRandomPowerW();

        // Assign the player the corresponding power
        superpowerUtil.addSuperpower(player, assignedPower.power);

        // Send a message in the player's chat window
        player.tell(`You have awoken: ${assignedPower.name}`);

        // Remove the item from the player's hand
        player.setItemInHand(hand, Item.of('minecraft:air'));
    }
});