ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event
    event.register(
        Commands.literal("PTP")
            .then(Commands.argument('x', Arguments.STRING.create(event))
                .then(Commands.argument('y', Arguments.STRING.create(event))
                    .then(Commands.argument('z', Arguments.STRING.create(event))
                        .executes(ctx => {
                            let x = Arguments.STRING.getResult(ctx, "x")
                            let y = Arguments.STRING.getResult(ctx, "y")
                            let z = Arguments.STRING.getResult(ctx, "z")


                            let server = ctx.source.getServer()
                            let player = ctx.source.player
                            let dim = player.getLevel().getDimension()

                            let username = player.getGameProfile().getName();

                            if (abilityUtil.isEnabled(player, 'p_sing:teleporter', 'global_tp_purchase')) {
                                server.runCommandSilent(`execute as ${username} at @s in ${dim} as @e[distance=..3] run tp @s ${x} ${y} ${z}`)

                            }

                            return 1;
                        })

                    ))));
});
ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event
    event.register(
        Commands.literal("warp_gate")
            .then(Commands.argument('x', Arguments.STRING.create(event))
                .then(Commands.argument('y', Arguments.STRING.create(event))
                    .then(Commands.argument('z', Arguments.STRING.create(event))
                        .executes(ctx => {
                            let x = Arguments.STRING.getResult(ctx, "x")
                            let y = Arguments.STRING.getResult(ctx, "y")
                            let z = Arguments.STRING.getResult(ctx, "z")


                            let server = ctx.source.getServer()
                            let player = ctx.source.player
                            let dim = player.getLevel().getDimension()

                            let username = player.getGameProfile().getName();

                            if (abilityUtil.isEnabled(player, 'p_sing:warp', 'coordinate_teleport_purchase')) {
                                server.runCommandSilent(`execute as ${username} at @s in ${dim} as @e[distance=..4,tag=Coordinate.Marked] run tp @e[tag=Coordinate.Marked] ${x} ${y} ${z}`)
                                server.runCommandSilent(`particle dust_color_transition 0 0.00 1.00 2 0 0 1 ~ ~1 ~ 1 1 1 1 500 force`)
                                return 1;
                            }
                        })

                    ))));
});
ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event
    event.register(
        Commands.literal("planar")
            .then(Commands.argument('x', Arguments.STRING.create(event))
                .then(Commands.argument('y', Arguments.STRING.create(event))
                    .then(Commands.argument('z', Arguments.STRING.create(event))
                        .executes(ctx => {
                            let x = Arguments.STRING.getResult(ctx, "x")
                            let y = Arguments.STRING.getResult(ctx, "y")
                            let z = Arguments.STRING.getResult(ctx, "z")


                            let server = ctx.source.getServer()
                            let player = ctx.source.player
                            let dim = player.getLevel().getDimension()

                            let username = player.getGameProfile().getName();

                            if (abilityUtil.isEnabled(player, 'p_sing:planar', 'global_planar_purchase')) {
                                server.runCommandSilent(`execute as ${username} at @s in ${dim} as @e[distance=..4] run tp @s ${x} ${y} ${z}`)
                                server.runCommandSilent(`particle dust_color_transition 0 0.00 1.00 2 0 0 1 ~ ~1 ~ 1 1 1 1 500 force`)

                            }

                            return 1;
                        })

                    ))));
});