/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.config;

import com.sheath.veinminer.config.AllowedBlocksConfig;
import com.sheath.veinminer.config.AllowedToolsConfig;
import com.sheath.veinminer.config.BlocksPerToolConfig;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.util.Log;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class ConfigService {
    public static final String HAND_KEY = "hand";
    private final GeneralConfig general = new GeneralConfig();
    private final AllowedToolsConfig tools = new AllowedToolsConfig();
    private final AllowedBlocksConfig blocks = new AllowedBlocksConfig();
    private final BlocksPerToolConfig blocksPerTool = new BlocksPerToolConfig();
    private volatile ConfigSnapshot snapshot;
    private static final Pattern LINE_PATTERN = Pattern.compile("(?:line|line:\\s*)(\\d+)", 2);

    public void loadAll() {
        this.tryLoad(this.general.path(), this.general::load);
        Collection<String> blockDefaults = this.general.blockListMode().whitelist() ? ConfigService.defaultBlockIds() : Collections.emptyList();
        Map perToolDefaults = this.general.blockListMode().perTool() && this.general.blockListMode().whitelist() ? ConfigService.defaultBlocksPerTool() : Collections.emptyMap();
        this.tryLoad(this.tools.path(), () -> this.tools.load(ConfigService.defaultToolIds()));
        this.tryLoad(this.blocks.path(), () -> this.blocks.load(blockDefaults));
        this.tryLoad(this.blocksPerTool.path(), () -> this.blocksPerTool.load(perToolDefaults));
        this.snapshot = this.buildSnapshot();
    }

    public void saveAll() {
        this.general.save();
        this.tools.save();
        this.blocks.save();
        this.blocksPerTool.save();
        this.snapshot = this.buildSnapshot();
    }

    private void tryLoad(Path path, Runnable action) {
        try {
            action.run();
        }
        catch (RuntimeException ex) {
            throw this.unwrap(path, ex);
        }
    }

    public ConfigSnapshot snapshot() {
        if (this.snapshot == null) {
            throw new IllegalStateException("Configs not loaded yet");
        }
        return this.snapshot;
    }

    private ConfigLoadException unwrap(Path path, RuntimeException ex) {
        int line = this.extractLine(ex);
        String message = ex.getMessage() != null ? ex.getMessage() : ex.getClass().getSimpleName();
        return new ConfigLoadException(path, line, message, ex);
    }

    private int extractLine(Throwable throwable) {
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            Matcher matcher;
            String message = current.getMessage();
            if (message == null || !(matcher = LINE_PATTERN.matcher(message)).find()) continue;
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public GeneralConfig general() {
        return this.general;
    }

    public AllowedToolsConfig toolsConfig() {
        return this.tools;
    }

    public AllowedBlocksConfig blocksConfig() {
        return this.blocks;
    }

    public BlocksPerToolConfig blocksPerToolConfig() {
        return this.blocksPerTool;
    }

    public ChangeResult addAllowedBlock(String entry) {
        String normalized = this.normalizeReference(entry);
        if (!this.isValidRegistryReference(normalized)) {
            return ChangeResult.INVALID;
        }
        if (!this.blocks.addValue(normalized)) {
            return ChangeResult.ALREADY_PRESENT;
        }
        this.blocks.save();
        this.snapshot = this.buildSnapshot();
        return ChangeResult.SUCCESS;
    }

    public ChangeResult removeAllowedBlock(String entry) {
        String normalized = this.normalizeReference(entry);
        if (!this.isValidRegistryReference(normalized)) {
            return ChangeResult.INVALID;
        }
        if (!this.blocks.removeValue(normalized)) {
            return ChangeResult.NOT_FOUND;
        }
        this.blocks.save();
        this.snapshot = this.buildSnapshot();
        return ChangeResult.SUCCESS;
    }

    public ChangeResult addAllowedTool(String entry) {
        String normalized = this.normalizeReference(entry);
        boolean hand = this.isHandReference(normalized);
        if (!hand && !this.isValidRegistryReference(normalized)) {
            return ChangeResult.INVALID;
        }
        if (!this.tools.addValue(normalized)) {
            return ChangeResult.ALREADY_PRESENT;
        }
        this.tools.save();
        this.snapshot = this.buildSnapshot();
        return ChangeResult.SUCCESS;
    }

    public ChangeResult removeAllowedTool(String entry) {
        String normalized = this.normalizeReference(entry);
        boolean hand = this.isHandReference(normalized);
        if (!hand && !this.isValidRegistryReference(normalized)) {
            return ChangeResult.INVALID;
        }
        if (!this.tools.removeValue(normalized)) {
            return ChangeResult.NOT_FOUND;
        }
        this.tools.save();
        this.snapshot = this.buildSnapshot();
        return ChangeResult.SUCCESS;
    }

    public ChangeResult addBlocksPerToolTool(String entry) {
        String tool = this.normalizeReference(entry);
        boolean hand = this.isHandReference(tool);
        if (!hand && !this.isValidRegistryReference(tool)) {
            return ChangeResult.INVALID;
        }
        if (this.blocksPerTool.containsTool(tool)) {
            return ChangeResult.ALREADY_PRESENT;
        }
        this.blocksPerTool.getOrCreate(tool);
        this.blocksPerTool.save();
        this.rebuildSnapshot();
        return ChangeResult.SUCCESS;
    }

    public ChangeResult removeBlocksPerToolTool(String entry) {
        String tool = this.normalizeReference(entry);
        boolean hand = this.isHandReference(tool);
        if (!hand && !this.isValidRegistryReference(tool)) {
            return ChangeResult.INVALID;
        }
        if (!this.blocksPerTool.removeTool(tool)) {
            return ChangeResult.NOT_FOUND;
        }
        this.blocksPerTool.save();
        this.rebuildSnapshot();
        return ChangeResult.SUCCESS;
    }

    public ChangeResult addBlocksPerToolBlock(String toolEntry, String blockEntry) {
        String tool = this.normalizeReference(toolEntry);
        String block = this.normalizeReference(blockEntry);
        boolean hand = this.isHandReference(tool);
        if (!hand && !this.isValidRegistryReference(tool) || !this.isValidRegistryReference(block)) {
            return ChangeResult.INVALID;
        }
        NavigableSet<String> blocksForTool = this.blocksPerTool.getOrCreate(tool);
        if (!blocksForTool.add(block)) {
            return ChangeResult.ALREADY_PRESENT;
        }
        this.blocksPerTool.save();
        this.rebuildSnapshot();
        return ChangeResult.SUCCESS;
    }

    public ChangeResult removeBlocksPerToolBlock(String toolEntry, String blockEntry) {
        String tool = this.normalizeReference(toolEntry);
        String block = this.normalizeReference(blockEntry);
        boolean hand = this.isHandReference(tool);
        if (!hand && !this.isValidRegistryReference(tool) || !this.isValidRegistryReference(block)) {
            return ChangeResult.INVALID;
        }
        NavigableSet<String> blocksForTool = this.blocksPerTool.get(tool);
        if (blocksForTool == null || !blocksForTool.remove(block)) {
            return ChangeResult.NOT_FOUND;
        }
        this.blocksPerTool.save();
        this.rebuildSnapshot();
        return ChangeResult.SUCCESS;
    }

    public NavigableSet<String> getBlocksForTool(String toolEntry) {
        String tool = this.normalizeReference(toolEntry);
        boolean hand = this.isHandReference(tool);
        if (!hand && !this.isValidRegistryReference(tool)) {
            return null;
        }
        return (NavigableSet)this.snapshot().blocksPerTool().rawMapping().get(tool);
    }

    public NavigableSet<String> getAllToolKeys() {
        return this.snapshot().blocksPerTool().rawMapping().navigableKeySet();
    }

    public void rebuildSnapshot() {
        this.snapshot = this.buildSnapshot();
    }

    private ConfigSnapshot buildSnapshot() {
        RegistryList<class_1792> toolRules = this.parseRegistryList(this.tools.values(), class_7924.field_41197, true);
        RegistryList<class_2248> blockRules = this.parseRegistryList(this.blocks.values(), class_7924.field_41254, false);
        BlocksPerToolRules perToolRules = this.buildBlocksPerToolRules(this.blocksPerTool.values());
        return new ConfigSnapshot(this.general, toolRules, blockRules, perToolRules);
    }

    private BlocksPerToolRules buildBlocksPerToolRules(NavigableMap<String, NavigableSet<String>> entries) {
        LinkedHashMap byToolId = new LinkedHashMap();
        LinkedHashMap byToolTag = new LinkedHashMap();
        RegistryList handRules = null;
        for (Map.Entry entry : entries.entrySet()) {
            String idString;
            String toolKey = (String)entry.getKey();
            if (toolKey == null || toolKey.isBlank()) continue;
            String trimmed = toolKey.trim();
            boolean isTag = trimmed.startsWith("#");
            String string = idString = isTag ? trimmed.substring(1) : trimmed;
            if (this.isHandReference(trimmed)) {
                handRules = this.parseRegistryList((Collection)entry.getValue(), class_7924.field_41254, false);
                continue;
            }
            class_2960 toolId = class_2960.method_12829((String)idString);
            if (toolId == null) {
                Log.warn("Invalid tool identifier '{}' in blocks-per-tool config", toolKey);
                continue;
            }
            RegistryList parsed = this.parseRegistryList((Collection)entry.getValue(), class_7924.field_41254, false);
            if (isTag) {
                byToolTag.put(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)toolId), parsed);
                continue;
            }
            byToolId.put(toolId, parsed);
        }
        return new BlocksPerToolRules(Collections.unmodifiableMap(byToolId), Collections.unmodifiableMap(byToolTag), entries, handRules);
    }

    private <T> RegistryList<T> parseRegistryList(Collection<String> values, class_5321<? extends class_2378<T>> registryKey, boolean allowHandKeyword) {
        TreeSet<String> raw = new TreeSet<String>();
        LinkedHashSet<class_2960> identifiers = new LinkedHashSet<class_2960>();
        LinkedHashSet<class_6862> tags = new LinkedHashSet<class_6862>();
        boolean allowHand = false;
        for (String entry : values) {
            String trimmed;
            if (entry == null || (trimmed = entry.trim()).isEmpty()) continue;
            raw.add(trimmed);
            if (allowHandKeyword && this.isHandReference(trimmed)) {
                allowHand = true;
                continue;
            }
            boolean isTag = trimmed.startsWith("#");
            String idString = isTag ? trimmed.substring(1) : trimmed;
            class_2960 id = class_2960.method_12829((String)idString);
            if (id == null) {
                Log.warn("Invalid identifier '{}' in {} config", trimmed, registryKey.method_29177());
                continue;
            }
            if (isTag) {
                class_6862 tagKey = class_6862.method_40092(registryKey, (class_2960)id);
                tags.add(tagKey);
                continue;
            }
            identifiers.add(id);
        }
        return new RegistryList(Collections.unmodifiableNavigableSet(raw), Collections.unmodifiableSet(identifiers), Collections.unmodifiableSet(tags), allowHandKeyword && allowHand);
    }

    private static Collection<String> defaultToolIds() {
        ArrayList<String> defaults = new ArrayList<String>();
        defaults.add(class_7923.field_41178.method_10221((Object)class_1802.field_8647).toString());
        defaults.add(class_7923.field_41178.method_10221((Object)class_1802.field_8387).toString());
        defaults.add(class_7923.field_41178.method_10221((Object)class_1802.field_8403).toString());
        defaults.add(class_7923.field_41178.method_10221((Object)class_1802.field_8335).toString());
        defaults.add(class_7923.field_41178.method_10221((Object)class_1802.field_8377).toString());
        defaults.add(class_7923.field_41178.method_10221((Object)class_1802.field_22024).toString());
        return defaults;
    }

    private static Collection<String> defaultBlockIds() {
        ArrayList<String> defaults = new ArrayList<String>();
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_10418).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_10212).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_27120).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_10571).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_10080).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_10090).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_10013).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_10442).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_29219).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_29027).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_29221).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_29026).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_29030).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_29028).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_29220).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_29029).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_23077).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_10213).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_23880).toString());
        defaults.add(class_7923.field_41175.method_10221((Object)class_2246.field_22109).toString());
        return defaults;
    }

    private static NavigableMap<String, NavigableSet<String>> defaultBlocksPerTool() {
        TreeMap<String, NavigableSet<String>> map = new TreeMap<String, NavigableSet<String>>();
        Collection<String> blocks = ConfigService.defaultBlockIds();
        for (String tool : ConfigService.defaultToolIds()) {
            map.put(tool, new TreeSet<String>(blocks));
        }
        return map;
    }

    private String normalizeReference(String entry) {
        if (entry == null) {
            return "";
        }
        String trimmed = entry.trim();
        if (trimmed.isEmpty()) {
            return trimmed;
        }
        if (HAND_KEY.equalsIgnoreCase(trimmed)) {
            return HAND_KEY;
        }
        if (trimmed.startsWith("#")) {
            String value = trimmed.substring(1).trim();
            if (value.isEmpty()) {
                return "";
            }
            return "#" + value.toLowerCase(Locale.ROOT);
        }
        return trimmed.toLowerCase(Locale.ROOT);
    }

    private boolean isHandReference(String entry) {
        return entry != null && HAND_KEY.equalsIgnoreCase(entry);
    }

    private boolean isValidRegistryReference(String entry) {
        return this.isValidRegistryReference(entry, false);
    }

    private boolean isValidRegistryReference(String entry, boolean allowHand) {
        if (entry == null || entry.isEmpty()) {
            return false;
        }
        if (allowHand && this.isHandReference(entry)) {
            return true;
        }
        if (entry.startsWith("#")) {
            if (entry.length() == 1) {
                return false;
            }
            return class_2960.method_12829((String)entry.substring(1)) != null;
        }
        return class_2960.method_12829((String)entry) != null;
    }

    public record ConfigSnapshot(GeneralConfig general, RegistryList<class_1792> allowedTools, RegistryList<class_2248> allowedBlocks, BlocksPerToolRules blocksPerTool) {
        public ConfigSnapshot {
            Objects.requireNonNull(general, "general");
            Objects.requireNonNull(allowedTools, "allowedTools");
            Objects.requireNonNull(allowedBlocks, "allowedBlocks");
            Objects.requireNonNull(blocksPerTool, "blocksPerTool");
        }
    }

    public static final class ConfigLoadException
    extends RuntimeException {
        private final Path path;
        private final int line;

        public ConfigLoadException(Path path, int line, String message, Throwable cause) {
            super(message, cause);
            this.path = path;
            this.line = line;
        }

        public Path path() {
            return this.path;
        }

        public int line() {
            return this.line;
        }
    }

    public static enum ChangeResult {
        SUCCESS,
        ALREADY_PRESENT,
        NOT_FOUND,
        INVALID;

    }

    public static final class BlocksPerToolRules {
        private final Map<class_2960, RegistryList<class_2248>> byToolId;
        private final Map<class_6862<class_1792>, RegistryList<class_2248>> byToolTag;
        private final NavigableMap<String, NavigableSet<String>> rawMapping;
        private final RegistryList<class_2248> handRules;

        private BlocksPerToolRules(Map<class_2960, RegistryList<class_2248>> byToolId, Map<class_6862<class_1792>, RegistryList<class_2248>> byToolTag, NavigableMap<String, NavigableSet<String>> rawMapping, RegistryList<class_2248> handRules) {
            this.byToolId = byToolId;
            this.byToolTag = byToolTag;
            this.handRules = handRules;
            TreeMap copy = new TreeMap();
            for (Map.Entry entry : rawMapping.entrySet()) {
                copy.put((String)entry.getKey(), Collections.unmodifiableNavigableSet(new TreeSet((SortedSet)entry.getValue())));
            }
            this.rawMapping = Collections.unmodifiableNavigableMap(copy);
        }

        public Map<class_2960, RegistryList<class_2248>> byToolId() {
            return this.byToolId;
        }

        public Map<class_6862<class_1792>, RegistryList<class_2248>> byToolTag() {
            return this.byToolTag;
        }

        public NavigableMap<String, NavigableSet<String>> rawMapping() {
            return this.rawMapping;
        }

        public RegistryList<class_2248> handRules() {
            return this.handRules;
        }

        public RegistryList<class_2248> forTool(class_2960 toolId) {
            return this.byToolId.get(toolId);
        }

        public RegistryList<class_2248> forTool(class_6862<class_1792> toolTag) {
            return this.byToolTag.get(toolTag);
        }
    }

    public static final class RegistryList<T> {
        private final NavigableSet<String> raw;
        private final Set<class_2960> identifiers;
        private final Set<class_6862<T>> tags;
        private final boolean allowEmptyHand;

        private RegistryList(NavigableSet<String> raw, Set<class_2960> identifiers, Set<class_6862<T>> tags, boolean allowEmptyHand) {
            this.raw = raw;
            this.identifiers = identifiers;
            this.tags = tags;
            this.allowEmptyHand = allowEmptyHand;
        }

        public NavigableSet<String> raw() {
            return this.raw;
        }

        public Set<class_2960> identifiers() {
            return this.identifiers;
        }

        public Set<class_6862<T>> tags() {
            return this.tags;
        }

        public boolean allowEmptyHand() {
            return this.allowEmptyHand;
        }
    }
}

