/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.visual;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import org.joml.Vector3f;

public final class ParticleOutlineManager {
    private static final int SPAWN_INTERVAL_TICKS = 5;
    private static final double[][] EDGE_OFFSETS = new double[][]{{0.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 1.0, 1.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 1.0}};
    private static final List<ParticleTask> TASKS = new ArrayList<ParticleTask>();
    private static boolean registered = false;

    private ParticleOutlineManager() {
    }

    public static synchronized void register() {
        if (registered) {
            return;
        }
        registered = true;
        ServerTickEvents.END_WORLD_TICK.register(ParticleOutlineManager::onWorldTick);
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            List<ParticleTask> list = TASKS;
            synchronized (list) {
                TASKS.removeIf(task -> task.world == world);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spawnOutline(class_3218 world, class_2338 pos, int red, int green, int blue, int durationTicks) {
        class_2390 effect = new class_2390(ParticleOutlineManager.toColorVector(red, green, blue), 1.0f);
        List<ParticleTask> list = TASKS;
        synchronized (list) {
            TASKS.removeIf(task -> task.world == world && task.pos.equals((Object)pos));
            TASKS.add(new ParticleTask(world, pos.method_10062(), effect, durationTicks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onWorldTick(class_3218 world) {
        List<ParticleTask> list = TASKS;
        synchronized (list) {
            Iterator<ParticleTask> iterator = TASKS.iterator();
            while (iterator.hasNext()) {
                ParticleTask task = iterator.next();
                if (task.world != world) continue;
                --task.remaining;
                --task.cooldown;
                if (task.cooldown <= 0) {
                    ParticleOutlineManager.spawnEdges(task.world, task.pos, task.effect);
                    task.cooldown = 5;
                }
                if (task.remaining > 0) continue;
                iterator.remove();
            }
        }
    }

    private static void spawnEdges(class_3218 world, class_2338 pos, class_2390 effect) {
        for (double[] offset : EDGE_OFFSETS) {
            double x = (double)pos.method_10263() + offset[0];
            double y = (double)pos.method_10264() + offset[1];
            double z = (double)pos.method_10260() + offset[2];
            world.method_14199((class_2394)effect, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    private static Vector3f toColorVector(int r, int g, int b) {
        float clampedR = (float)Math.max(0, Math.min(255, r)) / 255.0f;
        float clampedG = (float)Math.max(0, Math.min(255, g)) / 255.0f;
        float clampedB = (float)Math.max(0, Math.min(255, b)) / 255.0f;
        return new Vector3f(clampedR, clampedG, clampedB);
    }

    private static final class ParticleTask {
        final class_3218 world;
        final class_2338 pos;
        final class_2390 effect;
        int remaining;
        int cooldown = 0;

        ParticleTask(class_3218 world, class_2338 pos, class_2390 effect, int duration) {
            this.world = world;
            this.pos = pos;
            this.effect = effect;
            this.remaining = duration;
        }
    }
}

