/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.sheath.veinminer.config.ConfigFileFormatter;
import com.sheath.veinminer.config.TomlConfigFile;
import com.sheath.veinminer.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public final class AllowedToolsConfig
extends TomlConfigFile {
    private static final Pattern ID_PATTERN = Pattern.compile("^#?[a-z0-9_.-]+:[a-z0-9_/.-]+$");
    private final NavigableSet<String> allowedTools = new TreeSet<String>();

    public AllowedToolsConfig() {
        super("ToolsList.toml");
    }

    public void load(Collection<String> defaults) {
        this.allowedTools.clear();
        try (CommentedFileConfig config = this.loadConfig();){
            List raw = (List)config.get("tools");
            if (raw == null) {
                this.allowedTools.addAll(defaults);
            } else {
                for (String entry : raw) {
                    String trimmed;
                    if (entry == null || (trimmed = entry.trim()).isEmpty()) continue;
                    String lower = trimmed.toLowerCase(Locale.ROOT);
                    if (!"hand".equals(lower) && !ID_PATTERN.matcher(trimmed).matches()) {
                        Log.warn("Ignoring malformed tool entry '{}'", trimmed);
                        continue;
                    }
                    this.allowedTools.add("hand".equals(lower) ? "hand" : trimmed);
                }
                if (this.allowedTools.isEmpty()) {
                    this.allowedTools.addAll(defaults);
                }
            }
            this.writeBack(config);
            this.save(config);
        }
        ConfigFileFormatter.formatArraysOnePerLine(this.path());
    }

    public void save() {
        try (CommentedFileConfig config = this.loadConfig();){
            this.writeBack(config);
            this.save(config);
        }
        ConfigFileFormatter.formatArraysOnePerLine(this.path());
    }

    private void writeBack(CommentedFileConfig config) {
        config.set("tools", new ArrayList<String>(this.allowedTools));
        config.setComment("tools", "Allowed tool registry ids or tag strings starting with '#'. Use 'hand' to permit empty-hand veinmining.");
    }

    public NavigableSet<String> values() {
        return Collections.unmodifiableNavigableSet(this.allowedTools);
    }

    public void replaceValues(Collection<String> newValues) {
        this.allowedTools.clear();
        this.allowedTools.addAll(newValues);
    }

    public boolean addValue(String value) {
        return this.allowedTools.add(value);
    }

    public boolean removeValue(String value) {
        return this.allowedTools.remove(value);
    }
}

