/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.logic.rules;

import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.config.GeneralConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public final class RuleIndex {
    private final GeneralConfig.BlockListMode blockListMode;
    private final BlockRules globalBlockRules;
    private final boolean allowEmptyHand;
    private final Set<class_2960> allowedToolIds;
    private final Set<class_6862<class_1792>> allowedToolTags;
    private final Map<class_2960, BlockRules> perToolIdRules;
    private final Map<class_6862<class_1792>, BlockRules> perToolTagRules;
    private final BlockRules handRules;

    private RuleIndex(GeneralConfig.BlockListMode blockListMode, BlockRules globalBlockRules, boolean allowEmptyHand, Set<class_2960> allowedToolIds, Set<class_6862<class_1792>> allowedToolTags, Map<class_2960, BlockRules> perToolIdRules, Map<class_6862<class_1792>, BlockRules> perToolTagRules, BlockRules handRules) {
        this.blockListMode = blockListMode;
        this.globalBlockRules = globalBlockRules;
        this.allowEmptyHand = allowEmptyHand;
        this.allowedToolIds = allowedToolIds;
        this.allowedToolTags = allowedToolTags;
        this.perToolIdRules = perToolIdRules;
        this.perToolTagRules = perToolTagRules;
        this.handRules = handRules;
    }

    public static RuleIndex fromSnapshot(ConfigService.ConfigSnapshot snapshot) {
        ConfigService.RegistryList<class_2248> blocks = snapshot.allowedBlocks();
        ConfigService.RegistryList<class_1792> tools = snapshot.allowedTools();
        LinkedHashMap<class_2960, BlockRules> perToolIds = new LinkedHashMap<class_2960, BlockRules>();
        LinkedHashMap<class_6862, BlockRules> perToolTags = new LinkedHashMap<class_6862, BlockRules>();
        for (Map.Entry<class_2960, ConfigService.RegistryList<class_2248>> entry : snapshot.blocksPerTool().byToolId().entrySet()) {
            perToolIds.put(entry.getKey(), BlockRules.from(entry.getValue()));
        }
        for (Map.Entry<class_2960, ConfigService.RegistryList<class_2248>> entry : snapshot.blocksPerTool().byToolTag().entrySet()) {
            perToolTags.put((class_6862)entry.getKey(), BlockRules.from(entry.getValue()));
        }
        ConfigService.RegistryList<class_2248> handList = snapshot.blocksPerTool().handRules();
        BlockRules blockRules = handList != null ? BlockRules.from(handList) : null;
        return new RuleIndex(snapshot.general().blockListMode(), BlockRules.from(blocks), tools.allowEmptyHand(), Collections.unmodifiableSet(tools.identifiers()), Collections.unmodifiableSet(tools.tags()), Collections.unmodifiableMap(perToolIds), Collections.unmodifiableMap(perToolTags), blockRules);
    }

    public boolean isToolAllowed(class_1799 tool) {
        if (tool.method_7960()) {
            return this.allowEmptyHand;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)tool.method_7909());
        if (this.allowedToolIds.contains(id)) {
            return true;
        }
        for (class_6862<class_1792> tag : this.allowedToolTags) {
            if (!tool.method_31573(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockAllowed(class_2680 state, class_1799 tool) {
        BlockRules rules;
        BlockRules blockRules = rules = this.blockListMode.perTool() ? this.rulesFor(tool) : this.globalBlockRules;
        if (this.blockListMode.whitelist()) {
            return rules != null && rules.matches(state);
        }
        if (rules == null) {
            return true;
        }
        return !rules.matches(state);
    }

    public BlockRules rulesFor(class_1799 tool) {
        if (!this.blockListMode.perTool()) {
            return this.globalBlockRules;
        }
        if (tool.method_7960()) {
            return this.handRules;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)tool.method_7909());
        BlockRules rules = this.perToolIdRules.get(id);
        if (rules != null) {
            return rules;
        }
        for (class_6862<class_1792> tag : this.perToolTagRules.keySet()) {
            if (!tool.method_31573(tag)) continue;
            return this.perToolTagRules.get(tag);
        }
        return null;
    }

    public GeneralConfig.BlockListMode blockListMode() {
        return this.blockListMode;
    }

    public BlockRules globalBlockRules() {
        return this.globalBlockRules;
    }

    public Map<class_2960, BlockRules> perToolIdRules() {
        return this.perToolIdRules;
    }

    public Map<class_6862<class_1792>, BlockRules> perToolTagRules() {
        return this.perToolTagRules;
    }

    public boolean allowEmptyHand() {
        return this.allowEmptyHand;
    }

    public static final class BlockRules {
        private final Set<class_2960> identifiers;
        private final Set<class_6862<class_2248>> tags;

        private BlockRules(Set<class_2960> identifiers, Set<class_6862<class_2248>> tags) {
            this.identifiers = identifiers;
            this.tags = tags;
        }

        public static BlockRules from(ConfigService.RegistryList<class_2248> list) {
            Objects.requireNonNull(list, "registry list");
            return new BlockRules(Collections.unmodifiableSet(list.identifiers()), Collections.unmodifiableSet(list.tags()));
        }

        public boolean matches(class_2680 state) {
            class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
            if (this.identifiers.contains(id)) {
                return true;
            }
            for (class_6862<class_2248> tag : this.tags) {
                if (!state.method_26164(tag)) continue;
                return true;
            }
            return false;
        }

        public Set<class_2960> identifiers() {
            return this.identifiers;
        }

        public Set<class_6862<class_2248>> tags() {
            return this.tags;
        }
    }
}

