/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.dataManagement;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.sheath.veinminer.utils.ModLogger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;

public class PlayerDataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File DATA_FILE = FabricLoader.getInstance().getConfigDir().resolve("Veinminer/Players/PlayerData.json").toFile();
    private static Map<UUID, Boolean> playerVeinminerStates = new HashMap<UUID, Boolean>();
    private static Map<UUID, Boolean> playerParticlesStates = new HashMap<UUID, Boolean>();
    private static Map<UUID, MessageSettings> playerMessageStates = new HashMap<UUID, MessageSettings>();

    public static void load() {
        File parentDir = DATA_FILE.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            ModLogger.error("\u26a0 Failed to create directory: " + parentDir.getAbsolutePath(), new Object[0]);
        }
        if (!DATA_FILE.exists()) {
            PlayerDataManager.save();
            return;
        }
        try (FileReader fileReader = new FileReader(DATA_FILE);
             JsonReader reader = new JsonReader((Reader)fileReader);){
            reader.setLenient(true);
            JsonElement element = JsonParser.parseReader((JsonReader)reader);
            playerVeinminerStates = new HashMap<UUID, Boolean>();
            playerParticlesStates = new HashMap<UUID, Boolean>();
            playerMessageStates = new HashMap<UUID, MessageSettings>();
            if (element != null && element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                if (obj.has("veinminer") || obj.has("particles") || obj.has("messages")) {
                    if (obj.has("veinminer") && obj.get("veinminer").isJsonObject()) {
                        for (Iterator entry : obj.getAsJsonObject("veinminer").entrySet()) {
                            playerVeinminerStates.put(UUID.fromString((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsBoolean());
                        }
                    }
                    if (obj.has("particles") && obj.get("particles").isJsonObject()) {
                        for (Iterator entry : obj.getAsJsonObject("particles").entrySet()) {
                            playerParticlesStates.put(UUID.fromString((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsBoolean());
                        }
                    }
                    if (obj.has("messages") && obj.get("messages").isJsonObject()) {
                        JsonObject messagesObj = obj.getAsJsonObject("messages");
                        if (!messagesObj.entrySet().isEmpty() && ((JsonElement)((Map.Entry)messagesObj.entrySet().iterator().next()).getValue()).isJsonObject()) {
                            for (Map.Entry entry : messagesObj.entrySet()) {
                                MessageSettings settings = new MessageSettings();
                                JsonObject msgObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                                if (msgObj.has("permission")) {
                                    settings.permission = msgObj.get("permission").getAsBoolean();
                                }
                                if (msgObj.has("disabled")) {
                                    settings.disabled = msgObj.get("disabled").getAsBoolean();
                                }
                                if (msgObj.has("cooldown")) {
                                    settings.cooldown = msgObj.get("cooldown").getAsBoolean();
                                }
                                if (msgObj.has("durability")) {
                                    settings.durability = msgObj.get("durability").getAsBoolean();
                                }
                                playerMessageStates.put(UUID.fromString((String)entry.getKey()), settings);
                            }
                        } else {
                            for (Map.Entry entry : messagesObj.entrySet()) {
                                boolean enabled = ((JsonElement)entry.getValue()).getAsBoolean();
                                MessageSettings settings = new MessageSettings();
                                settings.permission = enabled;
                                settings.disabled = enabled;
                                settings.cooldown = enabled;
                                settings.durability = enabled;
                                playerMessageStates.put(UUID.fromString((String)entry.getKey()), settings);
                            }
                        }
                    }
                } else {
                    for (Map.Entry entry : obj.entrySet()) {
                        playerVeinminerStates.put(UUID.fromString((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsBoolean());
                    }
                }
            }
        }
        catch (IOException e) {
            ModLogger.error("Failed to load player data: " + e.getMessage(), new Object[0]);
            playerVeinminerStates = new HashMap<UUID, Boolean>();
            playerParticlesStates = new HashMap<UUID, Boolean>();
            playerMessageStates = new HashMap<UUID, MessageSettings>();
        }
        ModLogger.info("Registered and loaded PlayerData!", new Object[0]);
    }

    public static void save() {
        File parentDir = DATA_FILE.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            ModLogger.error("\u26a0 Failed to create directory: " + parentDir.getAbsolutePath(), new Object[0]);
        }
        try (FileWriter writer = new FileWriter(DATA_FILE);){
            GSON.toJson((JsonElement)PlayerDataManager.buildSerializableData(), (Appendable)writer);
        }
        catch (IOException e) {
            ModLogger.error("Failed to save player data: " + e.getMessage(), new Object[0]);
        }
    }

    private static JsonObject buildSerializableData() {
        JsonObject root = new JsonObject();
        JsonObject veinminerObj = new JsonObject();
        for (Map.Entry<UUID, Boolean> entry : playerVeinminerStates.entrySet()) {
            veinminerObj.addProperty(entry.getKey().toString(), entry.getValue());
        }
        root.add("veinminer", (JsonElement)veinminerObj);
        JsonObject particlesObj = new JsonObject();
        for (Map.Entry<UUID, Boolean> entry : playerParticlesStates.entrySet()) {
            particlesObj.addProperty(entry.getKey().toString(), entry.getValue());
        }
        root.add("particles", (JsonElement)particlesObj);
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<UUID, MessageSettings> entry : playerMessageStates.entrySet()) {
            JsonObject msg = new JsonObject();
            MessageSettings settings = entry.getValue();
            msg.addProperty("permission", Boolean.valueOf(settings.permission));
            msg.addProperty("disabled", Boolean.valueOf(settings.disabled));
            msg.addProperty("cooldown", Boolean.valueOf(settings.cooldown));
            msg.addProperty("durability", Boolean.valueOf(settings.durability));
            jsonObject.add(entry.getKey().toString(), (JsonElement)msg);
        }
        root.add("messages", (JsonElement)jsonObject);
        return root;
    }

    public static void setVeinminerEnabled(class_3222 player, boolean enabled) {
        playerVeinminerStates.put(player.method_5667(), enabled);
    }

    public static boolean isVeinminerEnabled(class_3222 player) {
        return playerVeinminerStates.getOrDefault(player.method_5667(), true);
    }

    public static void setParticlesEnabled(class_3222 player, boolean enabled) {
        playerParticlesStates.put(player.method_5667(), enabled);
    }

    public static boolean isParticlesEnabled(class_3222 player) {
        return playerParticlesStates.getOrDefault(player.method_5667(), true);
    }

    public static void setMessageEnabled(class_3222 player, MessageType type, boolean enabled) {
        MessageSettings settings = playerMessageStates.computeIfAbsent(player.method_5667(), k -> new MessageSettings());
        switch (type.ordinal()) {
            case 0: {
                settings.permission = enabled;
                break;
            }
            case 1: {
                settings.disabled = enabled;
                break;
            }
            case 2: {
                settings.cooldown = enabled;
                break;
            }
            case 3: {
                settings.durability = enabled;
            }
        }
    }

    public static boolean isMessageEnabled(class_3222 player, MessageType type) {
        MessageSettings settings = playerMessageStates.get(player.method_5667());
        if (settings == null) {
            return true;
        }
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> settings.permission;
            case 1 -> settings.disabled;
            case 2 -> settings.cooldown;
            case 3 -> settings.durability;
        };
    }

    private static class MessageSettings {
        boolean permission = true;
        boolean disabled = true;
        boolean cooldown = true;
        boolean durability = true;

        private MessageSettings() {
        }
    }

    public static enum MessageType {
        PERMISSION("permission"),
        DISABLED("disabled"),
        COOLDOWN("cooldown"),
        DURABILITY("durability");

        private final String id;

        private MessageType(String id) {
            this.id = id;
        }

        public String id() {
            return this.id;
        }

        public String display() {
            return Character.toUpperCase(this.id.charAt(0)) + this.id.substring(1);
        }
    }
}

