/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sheath.veinminer.command.BlockPerToolCommand;
import com.sheath.veinminer.command.BlocksCommand;
import com.sheath.veinminer.command.ParticlesCommand;
import com.sheath.veinminer.command.SettingsCommand;
import com.sheath.veinminer.command.TestCommand;
import com.sheath.veinminer.command.ToolsCommand;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.player.PlayerSettingsStore;
import com.sheath.veinminer.util.Log;
import com.sheath.veinminer.util.Translations;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public final class VeinMinerCommand {
    private static final Map<String, String> HELP_TOPICS = VeinMinerCommand.createHelpTopics();
    private final Bootstrap bootstrap;

    public VeinMinerCommand(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"veinminer").requires(source -> source.method_9259(0))).executes(ctx -> this.showHelp((class_2168)ctx.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(ctx -> this.showHelp((class_2168)ctx.getSource()))).then(class_2170.method_9244((String)"topic", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            HELP_TOPICS.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> this.showHelp((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"topic")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(this::canReload)).executes(ctx -> this.reload((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"toggle").executes(ctx -> this.withPlayer((class_2168)ctx.getSource(), this::toggleVeinminer)))).then(class_2170.method_9247((String)"toggleparticles").executes(ctx -> this.withPlayer((class_2168)ctx.getSource(), this::toggleParticles)))).then(this.buildToggleMessagesNode());
        root.then(BlocksCommand.build(this.bootstrap, this::canReload));
        root.then(ToolsCommand.build(this.bootstrap, this::canReload));
        root.then(BlockPerToolCommand.build(this.bootstrap, this::canReload));
        root.then(ParticlesCommand.build(this.bootstrap, this::canReload));
        root.then(SettingsCommand.build(this.bootstrap, this::canReload));
        root.then(this.buildActivationNode());
        root.then(TestCommand.build(this.bootstrap, this::canReload));
        dispatcher.register(root);
    }

    private int showHelp(class_2168 source) {
        return this.showHelp(source, "overview");
    }

    private int showHelp(class_2168 source, String topic) {
        String normalized = topic == null ? "overview" : topic.toLowerCase(Locale.ROOT);
        String key = HELP_TOPICS.getOrDefault(normalized, HELP_TOPICS.get("overview"));
        source.method_9226(() -> Translations.translate(key, new Object[0]), false);
        return 1;
    }

    private int reload(class_2168 source) {
        try {
            this.bootstrap.configService().loadAll();
            this.bootstrap.controller().reloadFromConfig();
            source.method_9226(() -> Translations.translate("command.veinminer.reload", new Object[0]), true);
            return 1;
        }
        catch (ConfigService.ConfigLoadException ex) {
            Log.error("Config reload failed", ex);
            String fileName = ex.path().getFileName().toString();
            int line = ex.line();
            Integer lineArg = line >= 0 ? Integer.valueOf(line) : class_2561.method_43470((String)"?");
            source.method_9213(Translations.translate("command.veinminer.reload_failed", fileName, lineArg, ex.getMessage()));
            return 0;
        }
        catch (Exception ex) {
            Log.error("Config reload failed", ex);
            String message = ex.getMessage() != null ? ex.getMessage() : ex.getClass().getSimpleName();
            source.method_9213(Translations.translate("command.veinminer.reload_failed", message));
            return 0;
        }
    }

    private void toggleVeinminer(class_3222 player) {
        PlayerSettingsStore store = this.bootstrap.playerSettings();
        boolean newState = !store.isVeinminerEnabled(player);
        store.setVeinminerEnabled(player, newState);
        store.saveAsync();
        player.method_7353(Translations.translate("command.veinminer.toggle", Translations.translate(newState ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
    }

    private void toggleParticles(class_3222 player) {
        PlayerSettingsStore store = this.bootstrap.playerSettings();
        boolean newState = !store.isParticlesEnabled(player);
        store.setParticlesEnabled(player, newState);
        store.saveAsync();
        player.method_7353(Translations.translate("command.veinminer.particles_player_toggle", Translations.translate(newState ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
    }

    private ArgumentBuilder<class_2168, ?> buildToggleMessagesNode() {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"togglemessages").executes(ctx -> this.showToggleMessagesHelp((class_2168)ctx.getSource()))).then(class_2170.method_9247((String)"help").executes(ctx -> this.showToggleMessagesHelp((class_2168)ctx.getSource())));
        for (PlayerSettingsStore.MessageType type : PlayerSettingsStore.MessageType.values()) {
            root.then(class_2170.method_9247((String)type.id()).executes(ctx -> this.withPlayer((class_2168)ctx.getSource(), player -> this.toggleMessage((class_3222)player, type))));
        }
        return root;
    }

    private ArgumentBuilder<class_2168, ?> buildActivationNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"activation").executes(ctx -> this.showActivationHelp((class_2168)ctx.getSource()))).then(class_2170.method_9247((String)"help").executes(ctx -> this.showActivationHelp((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"keybind").then(class_2170.method_9247((String)"enable").executes(ctx -> this.withPlayer((class_2168)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setUseKeybind((class_3222)player, true);
            store.resetKeyToggleState((class_3222)player);
            store.saveAsync();
            player.method_7353(Translations.translate("command.veinminer.activation.keybind", Translations.translate("command.veinminer.enabled", new Object[0])), true);
        })))).then(class_2170.method_9247((String)"disable").executes(ctx -> this.withPlayer((class_2168)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setUseKeybind((class_3222)player, false);
            store.resetKeyToggleState((class_3222)player);
            store.saveAsync();
            player.method_7353(Translations.translate("command.veinminer.activation.keybind", Translations.translate("command.veinminer.disabled", new Object[0])), true);
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"keymode").then(class_2170.method_9247((String)"hold").executes(ctx -> this.withPlayer((class_2168)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setKeyToggleMode((class_3222)player, false);
            store.resetKeyToggleState((class_3222)player);
            store.saveAsync();
            player.method_7353(Translations.translate("command.veinminer.activation.key_mode", Translations.translate("command.veinminer.activation.mode.hold", new Object[0])), true);
        })))).then(class_2170.method_9247((String)"toggle").executes(ctx -> this.withPlayer((class_2168)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setKeyToggleMode((class_3222)player, true);
            store.saveAsync();
            player.method_7353(Translations.translate("command.veinminer.activation.key_mode", Translations.translate("command.veinminer.activation.mode.toggle", new Object[0])), true);
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"crouchmode").then(class_2170.method_9247((String)"hold").executes(ctx -> this.withPlayer((class_2168)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setCrouchToggleMode((class_3222)player, false);
            store.resetCrouchToggleState((class_3222)player);
            store.saveAsync();
            player.method_7353(Translations.translate("command.veinminer.activation.crouch_mode", Translations.translate("command.veinminer.activation.mode.hold", new Object[0])), true);
        })))).then(class_2170.method_9247((String)"toggle").executes(ctx -> this.withPlayer((class_2168)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setCrouchToggleMode((class_3222)player, true);
            store.saveAsync();
            player.method_7353(Translations.translate("command.veinminer.activation.crouch_mode", Translations.translate("command.veinminer.activation.mode.toggle", new Object[0])), true);
        }))));
    }

    private void toggleMessage(class_3222 player, PlayerSettingsStore.MessageType type) {
        PlayerSettingsStore store = this.bootstrap.playerSettings();
        boolean newState = !store.isMessageEnabled(player, type);
        store.setMessageEnabled(player, type, newState);
        store.saveAsync();
        player.method_7353(Translations.translate("command.veinminer.togglemessage", class_2561.method_43470((String)VeinMinerCommand.capitalize(type.id())), Translations.translate(newState ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
    }

    private int withPlayer(class_2168 source, Consumer<class_3222> consumer) {
        try {
            class_3222 player = source.method_44023();
            if (player == null) {
                source.method_9213(Translations.translate("command.veinminer.player_only", new Object[0]));
                return 0;
            }
            consumer.accept(player);
            return 1;
        }
        catch (Exception ex) {
            Log.error("Command execution failed", ex);
            source.method_9213((class_2561)class_2561.method_43470((String)ex.getMessage()));
            return 0;
        }
    }

    private static String capitalize(String input) {
        if (input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    private int showToggleMessagesHelp(class_2168 source) {
        source.method_9226(() -> Translations.translate("command.veinminer.help.togglemessages", new Object[0]), false);
        return 1;
    }

    private int showActivationHelp(class_2168 source) {
        source.method_9226(() -> Translations.translate("command.veinminer.help.activation", new Object[0]), false);
        return 1;
    }

    private static Map<String, String> createHelpTopics() {
        return Map.ofEntries(Map.entry("overview", "command.veinminer.help"), Map.entry("blocks", "command.veinminer.help.blocks"), Map.entry("blockpertool", "command.veinminer.help.blockpertool"), Map.entry("tools", "command.veinminer.help.tools"), Map.entry("settings", "command.veinminer.help.settings"), Map.entry("blocklistmode", "command.veinminer.help.settings"), Map.entry("activation", "command.veinminer.help.activation"), Map.entry("togglemessages", "command.veinminer.help.togglemessages"), Map.entry("particles", "command.veinminer.help.particles"), Map.entry("reload", "command.veinminer.help.reload"), Map.entry("toggle", "command.veinminer.help.toggle"));
    }

    private boolean canReload(class_2168 source) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            return this.bootstrap.permissionService().hasPermission(player, "veinminer.reload");
        }
        return source.method_9259(2);
    }

    private static final class Command {
        static final int SINGLE_SUCCESS = 1;

        private Command() {
        }
    }
}

