/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.util;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;

public final class RegistryLookup {
    private RegistryLookup() {
    }

    public static <T> class_2378<T> requireRegistry(class_5455 manager, class_5321<class_2378<T>> key) {
        Objects.requireNonNull(manager, "manager");
        Objects.requireNonNull(key, "key");
        try {
            Method method = class_5455.class.getMethod("getOrThrow", class_5321.class);
            return (class_2378)method.invoke((Object)manager, key);
        }
        catch (NoSuchMethodException ignored) {
            return RegistryLookup.resolveWithoutGetOrThrow(manager, key);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Failed to resolve registry: " + String.valueOf(key.method_29177()), ex);
        }
    }

    private static <T> class_2378<T> resolveWithoutGetOrThrow(class_5455 manager, class_5321<class_2378<T>> key) {
        try {
            Method getOptional = class_5455.class.getMethod("getOptional", class_5321.class);
            Optional optional = (Optional)getOptional.invoke((Object)manager, key);
            return (class_2378)optional.orElseThrow(() -> RegistryLookup.missingRegistry(key));
        }
        catch (NoSuchMethodException ignored) {
            return RegistryLookup.resolveUsingGet(manager, key);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Failed to resolve registry: " + String.valueOf(key.method_29177()), ex);
        }
    }

    private static <T> class_2378<T> resolveUsingGet(class_5455 manager, class_5321<class_2378<T>> key) {
        try {
            Method get = class_5455.class.getMethod("get", class_5321.class);
            Object result = get.invoke((Object)manager, key);
            if (result instanceof Optional) {
                Optional optional = (Optional)result;
                return (class_2378)optional.orElseThrow(() -> RegistryLookup.missingRegistry(key));
            }
            return (class_2378)Objects.requireNonNull(result, () -> RegistryLookup.missingRegistry(key).getMessage());
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Failed to resolve registry: " + String.valueOf(key.method_29177()), ex);
        }
    }

    private static IllegalStateException missingRegistry(class_5321<?> key) {
        return new IllegalStateException("Missing registry: " + String.valueOf(key.method_29177()));
    }
}

