/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.init;

import com.sheath.veinminer.config.AllowedBlocksConfig;
import com.sheath.veinminer.config.AllowedBlocksPerToolConfig;
import com.sheath.veinminer.config.AllowedToolsConfig;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.utils.ModLogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_7923;

public class ConfigInit {
    public static GeneralConfig GENERAL;
    public static AllowedToolsConfig TOOLS;
    public static AllowedBlocksConfig BLOCKS;
    public static AllowedBlocksPerToolConfig BLOCKS_PER_TOOL;

    public static void load() {
        try {
            GENERAL = new GeneralConfig();
            GENERAL.load();
            TOOLS = new AllowedToolsConfig();
            TOOLS.load(ConfigInit.getDefaultTools());
            BLOCKS = new AllowedBlocksConfig();
            BLOCKS.load(ConfigInit.getDefaultBlocks());
            BLOCKS_PER_TOOL = new AllowedBlocksPerToolConfig();
            BLOCKS_PER_TOOL.load(ConfigInit.getDefaultBlocksPerTool());
        }
        catch (Exception e) {
            ModLogger.error("While registering config files, one or more failed!", new Object[0]);
            return;
        }
        ModLogger.info("Registering of config files.... Completed!", new Object[0]);
    }

    private static Set<String> getDefaultTools() {
        return new HashSet<String>(Arrays.asList(class_7923.field_41178.method_10221((Object)class_1802.field_8647).toString(), class_7923.field_41178.method_10221((Object)class_1802.field_8387).toString(), class_7923.field_41178.method_10221((Object)class_1802.field_8403).toString(), class_7923.field_41178.method_10221((Object)class_1802.field_8335).toString(), class_7923.field_41178.method_10221((Object)class_1802.field_8377).toString(), class_7923.field_41178.method_10221((Object)class_1802.field_22024).toString()));
    }

    private static Set<String> getDefaultBlocks() {
        return new HashSet<String>(Arrays.asList(class_7923.field_41175.method_10221((Object)class_2246.field_10418).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_10212).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_27120).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_10571).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_10080).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_10090).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_10013).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_10442).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_29219).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_29027).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_29221).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_29026).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_29030).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_29028).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_29220).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_29029).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_23077).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_10213).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_23880).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_22109).toString()));
    }

    private static Map<String, Set<String>> getDefaultBlocksPerTool() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String tool : ConfigInit.getDefaultTools()) {
            map.put(tool, new HashSet<String>(ConfigInit.getDefaultBlocks()));
        }
        return map;
    }
}

