/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.config;

import com.sheath.libs.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class AllowedToolsConfig {
    private static final File FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "Veinminer/AllowedTools.toml");
    public static Set<String> allowedTools = new HashSet<String>();

    public void load(Set<String> defaultTools) {
        File parentDir = FILE.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            System.err.println("\u26a0 Failed to create config directory: " + parentDir.getAbsolutePath());
        }
        if (!FILE.exists()) {
            allowedTools = defaultTools;
            this.save();
            return;
        }
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(FILE).autosave().sync().preserveInsertionOrder().build();){
            config.load();
            List loaded = (List)config.get("tools");
            allowedTools = loaded == null ? defaultTools : new HashSet<String>(loaded);
        }
    }

    public void save() {
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(FILE).autosave().sync().preserveInsertionOrder().build();){
            config.load();
            config.set("tools", new ArrayList<String>(allowedTools));
            config.setComment("tools", "Allowed tool registry ids or tag strings starting with '#'");
            config.save();
        }
    }
}

