/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer;

import com.mojang.brigadier.CommandDispatcher;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.util.Log;
import com.sheath.veinminer.visual.ParticleOutlineManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@Mod(value="veinminermod")
public final class Veinminer {
    public static final Bootstrap BOOTSTRAP = new Bootstrap();

    public Veinminer(IEventBus modEventBus) {
        Log.info("Starting {} (id={})", "Veinminer", "veinminermod");
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(this::onClientSetup);
        if (FMLEnvironment.getDist().isClient()) {
            this.registerClientHooks(modEventBus);
        }
        BOOTSTRAP.registerNetwork(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void registerClientHooks(IEventBus modEventBus) {
        try {
            Class.forName("com.sheath.veinminer.client.VeinminerClient", false, Veinminer.class.getClassLoader()).getMethod("register", IEventBus.class).invoke(null, modEventBus);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Unable to register client listeners", ex);
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BOOTSTRAP.onCommonSetup();
            Log.info("{} common setup complete", "Veinminer");
        });
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(BOOTSTRAP::onClientSetup);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        BOOTSTRAP.commandHandler().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        BOOTSTRAP.controller().onServerStarted();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        BOOTSTRAP.controller().onServerStopping();
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        if (event.getServer() != null) {
            BOOTSTRAP.controller().onServerTick(event.getServer());
        }
    }

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ParticleOutlineManager.onWorldTick(level2);
        }
    }

    @SubscribeEvent
    public void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            ParticleOutlineManager.onWorldUnload(level);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        boolean allowed = BOOTSTRAP.controller().handleBlockBreak(level, player2, event.getPos(), event.getState());
        if (!allowed) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            BOOTSTRAP.controller().onPlayerDisconnect(player2);
        }
    }
}

