/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.util.Translations;
import java.util.NavigableSet;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

final class BlockPerToolCommand {
    private BlockPerToolCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> build(Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blockpertool").requires(managePermission::test)).then(Commands.literal((String)"help").executes(ctx -> BlockPerToolCommand.showHelp((CommandSourceStack)ctx.getSource())))).then(BlockPerToolCommand.buildBlocksNode(bootstrap, managePermission))).then(BlockPerToolCommand.buildToolNode(bootstrap, managePermission));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> buildBlocksNode(Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission) {
        return Commands.literal((String)"blocks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"tool", (ArgumentType)StringArgumentType.greedyString()).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(managePermission::test)).then(Commands.argument((String)"block", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BlockPerToolCommand.addBlock((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool"), StringArgumentType.getString((CommandContext)ctx, (String)"block")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(managePermission::test)).then(Commands.argument((String)"block", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BlockPerToolCommand.removeBlock((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool"), StringArgumentType.getString((CommandContext)ctx, (String)"block")))))).then(Commands.literal((String)"list").executes(ctx -> BlockPerToolCommand.listBlocks((CommandSourceStack)ctx.getSource(), bootstrap, StringArgumentType.getString((CommandContext)ctx, (String)"tool")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> buildToolNode(Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tool").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(managePermission::test)).then(Commands.argument((String)"tool", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BlockPerToolCommand.addTool((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(managePermission::test)).then(Commands.argument((String)"tool", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> BlockPerToolCommand.removeTool((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool")))))).then(Commands.literal((String)"list").executes(ctx -> BlockPerToolCommand.listTools((CommandSourceStack)ctx.getSource(), bootstrap)));
    }

    private static int addBlock(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, String tool, String block) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission) || !BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        Component listDescriptor = BlockPerToolCommand.describePerToolList(mode);
        ConfigService.ChangeResult result = bootstrap.configService().addBlocksPerToolBlock(tool, block);
        return switch (result) {
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.sendSuccess(() -> Translations.translate("command.veinminer.blockpertool.block_added", block, listDescriptor, tool), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT -> {
                source.sendFailure(Translations.translate("command.veinminer.blockpertool.block_exists", block, listDescriptor, tool));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID, ConfigService.ChangeResult.NOT_FOUND -> {
                source.sendFailure(Translations.translate("command.veinminer.blockpertool.block_not_found", block, listDescriptor, tool));
                yield 0;
            }
            default -> {
                source.sendFailure(Translations.translate("command.veinminer.blockpertool.block_not_found", block, listDescriptor, tool));
                yield 0;
            }
        };
    }

    private static int removeBlock(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, String tool, String block) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission) || !BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        Component listDescriptor = BlockPerToolCommand.describePerToolList(mode);
        ConfigService.ChangeResult result = bootstrap.configService().removeBlocksPerToolBlock(tool, block);
        return switch (result) {
            default -> throw new MatchException(null, null);
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.sendSuccess(() -> Translations.translate("command.veinminer.blockpertool.block_removed", block, listDescriptor, tool), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT, ConfigService.ChangeResult.INVALID, ConfigService.ChangeResult.NOT_FOUND -> {
                source.sendFailure(Translations.translate("command.veinminer.blockpertool.block_not_found", block, listDescriptor, tool));
                yield 0;
            }
        };
    }

    private static int listBlocks(CommandSourceStack source, Bootstrap bootstrap, String tool) {
        if (!BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        Component listDescriptor = BlockPerToolCommand.describePerToolList(mode);
        NavigableSet<String> blocks = bootstrap.configService().getBlocksForTool(tool);
        if (blocks == null || blocks.isEmpty()) {
            source.sendSuccess(() -> Translations.translate("command.veinminer.blockpertool.no_blocks", listDescriptor, tool), false);
        } else {
            source.sendSuccess(() -> Translations.translate("command.veinminer.blockpertool.blocks_for_tool", listDescriptor, tool), false);
            blocks.forEach(block -> source.sendSuccess(() -> Translations.translate("command.veinminer.list_entry", block), false));
        }
        return 1;
    }

    private static int addTool(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, String tool) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission) || !BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        ConfigService.ChangeResult result = bootstrap.configService().addBlocksPerToolTool(tool);
        return switch (result) {
            default -> throw new MatchException(null, null);
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.sendSuccess(() -> Translations.translate("command.veinminer.blockpertool.tool_added", tool), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT -> {
                source.sendFailure(Translations.translate("command.veinminer.blockpertool.tool_exists", tool));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID, ConfigService.ChangeResult.NOT_FOUND -> {
                source.sendFailure(Translations.translate("command.veinminer.blockpertool.tool_not_found", tool));
                yield 0;
            }
        };
    }

    private static int removeTool(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, String tool) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission) || !BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        ConfigService.ChangeResult result = bootstrap.configService().removeBlocksPerToolTool(tool);
        return switch (result) {
            default -> throw new MatchException(null, null);
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.sendSuccess(() -> Translations.translate("command.veinminer.blockpertool.tool_removed", tool), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT, ConfigService.ChangeResult.INVALID, ConfigService.ChangeResult.NOT_FOUND -> {
                source.sendFailure(Translations.translate("command.veinminer.blockpertool.tool_not_found", tool));
                yield 0;
            }
        };
    }

    private static int listTools(CommandSourceStack source, Bootstrap bootstrap) {
        if (!BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        NavigableSet<String> tools = bootstrap.configService().getAllToolKeys();
        if (tools == null || tools.isEmpty()) {
            source.sendSuccess(() -> Translations.translate("command.veinminer.blockpertool.no_tools", new Object[0]), false);
        } else {
            source.sendSuccess(() -> Translations.translate("command.veinminer.blockpertool.tools_header", new Object[0]), false);
            tools.forEach(tool -> source.sendSuccess(() -> Translations.translate("command.veinminer.list_entry", tool), false));
        }
        return 1;
    }

    private static boolean ensurePerToolMode(CommandSourceStack source, Bootstrap bootstrap) {
        if (bootstrap.configService().general().blockListMode().perTool()) {
            return true;
        }
        source.sendFailure(Translations.translate("command.veinminer.blockpertool.not_enabled", new Object[0]));
        return false;
    }

    private static Component describePerToolList(GeneralConfig.BlockListMode mode) {
        String key = mode.blacklist() ? "command.veinminer.block_list_type.per_tool_blacklist" : "command.veinminer.block_list_type.per_tool_whitelist";
        return Translations.translate(key, new Object[0]);
    }

    private static boolean ensurePermission(CommandSourceStack source, Predicate<CommandSourceStack> managePermission) {
        if (managePermission.test(source)) {
            return true;
        }
        source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
        return false;
    }

    private static int showHelp(CommandSourceStack source) {
        source.sendSuccess(() -> Translations.translate("command.veinminer.help.blockpertool", new Object[0]), false);
        return 1;
    }
}

