/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.util.Log;
import com.sheath.veinminer.util.Translations;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

final class BlocksCommand {
    private BlocksCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> build(Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blocks").requires(managePermission::test)).then(Commands.literal((String)"help").executes(ctx -> BlocksCommand.showHelp((CommandSourceStack)ctx.getSource())))).executes(ctx -> BlocksCommand.list((CommandSourceStack)ctx.getSource(), bootstrap))).then(Commands.literal((String)"list").executes(ctx -> BlocksCommand.list((CommandSourceStack)ctx.getSource(), bootstrap)))).then(Commands.literal((String)"add").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(BlocksCommand.suggestBlocks()).executes(ctx -> BlocksCommand.add((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"id")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(BlocksCommand.suggestBlocks()).executes(ctx -> BlocksCommand.remove((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"id")))));
    }

    private static SuggestionProvider<CommandSourceStack> suggestBlocks() {
        return (ctx, builder) -> BlocksCommand.suggestBlocks((CommandSourceStack)ctx.getSource(), builder);
    }

    private static CompletableFuture<Suggestions> suggestBlocks(CommandSourceStack source, SuggestionsBuilder builder) {
        ArrayList<String> suggestions = new ArrayList<String>(BuiltInRegistries.BLOCK.keySet().size());
        for (ResourceLocation id : BuiltInRegistries.BLOCK.keySet()) {
            suggestions.add(id.toString());
        }
        return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)builder);
    }

    private static int list(CommandSourceStack source, Bootstrap bootstrap) {
        ConfigService.ConfigSnapshot snapshot = bootstrap.configService().snapshot();
        List<String> entries = List.copyOf(snapshot.allowedBlocks().raw());
        GeneralConfig.BlockListMode mode = snapshot.general().blockListMode();
        Component descriptor = BlocksCommand.describeGlobalList(mode);
        if (entries.isEmpty()) {
            source.sendSuccess(() -> Translations.translate("command.veinminer.blocks.none", descriptor), false);
            if (mode.perTool()) {
                source.sendSuccess(() -> Translations.translate("command.veinminer.blocks.per_tool_hint", new Object[0]), false);
            }
            return 1;
        }
        source.sendSuccess(() -> Translations.translate("command.veinminer.blocks.header", descriptor), false);
        if (mode.perTool()) {
            source.sendSuccess(() -> Translations.translate("command.veinminer.blocks.per_tool_hint", new Object[0]), false);
        }
        entries.forEach(entry -> source.sendSuccess(() -> Translations.translate("command.veinminer.list_entry", entry), false));
        return 1;
    }

    private static int add(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, String rawEntry) {
        if (!BlocksCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        ConfigService.ChangeResult result = bootstrap.configService().addAllowedBlock(rawEntry);
        return switch (result) {
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.sendSuccess(() -> Translations.translate("command.veinminer.blocks.added", rawEntry, BlocksCommand.describeGlobalList(mode)), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT -> {
                source.sendFailure(Translations.translate("command.veinminer.blocks.exists", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID -> {
                source.sendFailure(Translations.translate("command.veinminer.blocks.not_found", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
            default -> {
                Log.warn("Unexpected change result {} when adding block {}", new Object[]{result, rawEntry});
                source.sendFailure(Translations.translate("command.veinminer.blocks.not_found", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
        };
    }

    private static int remove(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, String rawEntry) {
        if (!BlocksCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        ConfigService.ChangeResult result = bootstrap.configService().removeAllowedBlock(rawEntry);
        return switch (result) {
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.sendSuccess(() -> Translations.translate("command.veinminer.blocks.removed", rawEntry, BlocksCommand.describeGlobalList(mode)), true);
                yield 1;
            }
            case ConfigService.ChangeResult.NOT_FOUND -> {
                source.sendFailure(Translations.translate("command.veinminer.blocks.not_found", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID -> {
                source.sendFailure(Translations.translate("command.veinminer.blocks.not_found", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
            default -> {
                Log.warn("Unexpected change result {} when removing block {}", new Object[]{result, rawEntry});
                source.sendFailure(Translations.translate("command.veinminer.blocks.not_found", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
        };
    }

    private static boolean ensurePermission(CommandSourceStack source, Predicate<CommandSourceStack> managePermission) {
        if (managePermission.test(source)) {
            return true;
        }
        source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
        return false;
    }

    private static Component describeGlobalList(GeneralConfig.BlockListMode mode) {
        String key = mode.blacklist() ? "command.veinminer.block_list_type.global_blacklist" : "command.veinminer.block_list_type.global_whitelist";
        return Translations.translate(key, new Object[0]);
    }

    private static int showHelp(CommandSourceStack source) {
        source.sendSuccess(() -> Translations.translate("command.veinminer.help.blocks", new Object[0]), false);
        return 1;
    }
}

