/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.util.Translations;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

final class ParticlesCommand {
    private ParticlesCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> build(Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"particles").requires(managePermission::test)).then(Commands.literal((String)"help").executes(ctx -> ParticlesCommand.showHelp((CommandSourceStack)ctx.getSource())))).executes(ctx -> ParticlesCommand.showHelp((CommandSourceStack)ctx.getSource()))).then(Commands.literal((String)"enable").executes(ctx -> ParticlesCommand.toggleParticles((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, true)))).then(Commands.literal((String)"disable").executes(ctx -> ParticlesCommand.toggleParticles((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, false)))).then(Commands.literal((String)"setcolor").then(Commands.argument((String)"red", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(Commands.argument((String)"green", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(Commands.argument((String)"blue", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(ctx -> ParticlesCommand.setColor((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"red"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"green"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"blue")))))))).then(Commands.literal((String)"setduration").then(Commands.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ParticlesCommand.setDuration((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"ticks")))));
    }

    private static int toggleParticles(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, boolean enable) {
        if (!managePermission.test(source)) {
            source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        GeneralConfig.ParticleSettings particles = bootstrap.configService().general().particles();
        particles.setEnabled(enable);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.sendSuccess(() -> Translations.translate("command.veinminer.particles.toggle", Translations.translate(enable ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
        return 1;
    }

    private static int setColor(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, int red, int green, int blue) {
        if (!managePermission.test(source)) {
            source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        GeneralConfig.ParticleSettings particles = bootstrap.configService().general().particles();
        particles.setRed(red);
        particles.setGreen(green);
        particles.setBlue(blue);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.sendSuccess(() -> Translations.translate("command.veinminer.particles.color_set", new Object[0]), true);
        return 1;
    }

    private static int setDuration(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, int ticks) {
        if (!managePermission.test(source)) {
            source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        bootstrap.configService().general().particles().setDurationTicks(ticks);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.sendSuccess(() -> Translations.translate("command.veinminer.particles.duration_set", ticks), true);
        return 1;
    }

    private static int showHelp(CommandSourceStack source) {
        source.sendSuccess(() -> Translations.translate("command.veinminer.help.particles", new Object[0]), false);
        return 1;
    }
}

