/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.util.Translations;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

final class SettingsCommand {
    private SettingsCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> build(Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"settings").requires(managePermission::test)).then(Commands.literal((String)"help").executes(ctx -> SettingsCommand.showHelp((CommandSourceStack)ctx.getSource())))).executes(ctx -> SettingsCommand.showSettings((CommandSourceStack)ctx.getSource(), bootstrap))).then(Commands.literal((String)"blockpertool").executes(ctx -> SettingsCommand.toggleBlockPerTool((CommandSourceStack)ctx.getSource(), bootstrap, managePermission)))).then(Commands.literal((String)"blocklistmode").then(Commands.argument((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (GeneralConfig.BlockListMode mode : GeneralConfig.BlockListMode.values()) {
                builder.suggest(mode.name().toLowerCase(Locale.ROOT));
            }
            return builder.buildFuture();
        }).executes(ctx -> SettingsCommand.setBlockListMode((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"mode")))))).then(SettingsCommand.buildCooldownNode(bootstrap, managePermission))).then(SettingsCommand.buildLuckPermsNode(bootstrap, managePermission))).then(Commands.literal((String)"maxblocks").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> SettingsCommand.setMaxBlocks((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> buildCooldownNode(Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cooldown").then(Commands.literal((String)"enable").executes(ctx -> SettingsCommand.setCooldownEnabled((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, true)))).then(Commands.literal((String)"disable").executes(ctx -> SettingsCommand.setCooldownEnabled((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, false)))).then(Commands.literal((String)"set").then(Commands.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> SettingsCommand.setCooldownSeconds((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> buildLuckPermsNode(Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"luckperms").then(Commands.literal((String)"enable").executes(ctx -> SettingsCommand.setLuckPerms((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, true)))).then(Commands.literal((String)"disable").executes(ctx -> SettingsCommand.setLuckPerms((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, false)));
    }

    private static int toggleBlockPerTool(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission) {
        if (!managePermission.test(source)) {
            source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        GeneralConfig general = bootstrap.configService().general();
        GeneralConfig.BlockListMode current = general.blockListMode();
        GeneralConfig.BlockListMode next = current.perTool() ? (current.blacklist() ? GeneralConfig.BlockListMode.GLOBAL_BLACKLIST : GeneralConfig.BlockListMode.GLOBAL_WHITELIST) : (current.blacklist() ? GeneralConfig.BlockListMode.PER_TOOL_BLACKLIST : GeneralConfig.BlockListMode.PER_TOOL_WHITELIST);
        general.setBlockListMode(next);
        general.save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.sendSuccess(() -> Translations.translate("command.veinminer.settings.blockpertool", SettingsCommand.describeMode(next)), true);
        return 1;
    }

    private static int setBlockListMode(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, String rawMode) {
        GeneralConfig.BlockListMode mode;
        if (!managePermission.test(source)) {
            source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        try {
            mode = GeneralConfig.BlockListMode.valueOf(rawMode.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            source.sendFailure(Translations.translate("command.veinminer.settings.blocklistmode_invalid", rawMode));
            return 0;
        }
        bootstrap.configService().general().setBlockListMode(mode);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.sendSuccess(() -> Translations.translate("command.veinminer.settings.blocklistmode_set", SettingsCommand.describeMode(mode)), true);
        return 1;
    }

    private static int setCooldownSeconds(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, int seconds) {
        if (!managePermission.test(source)) {
            source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        bootstrap.configService().general().cooldown().setSeconds(seconds);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.sendSuccess(() -> Translations.translate("command.veinminer.settings.cooldown_time_set", seconds), true);
        return 1;
    }

    private static int setCooldownEnabled(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, boolean enabled) {
        if (!managePermission.test(source)) {
            source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        bootstrap.configService().general().cooldown().setEnabled(enabled);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.sendSuccess(() -> Translations.translate("command.veinminer.settings.cooldown_state", Translations.translate(enabled ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
        return 1;
    }

    private static int setLuckPerms(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, boolean enabled) {
        if (!managePermission.test(source)) {
            source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        bootstrap.configService().general().setAutoLuckPerms(enabled);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.sendSuccess(() -> Translations.translate("command.veinminer.settings.luckperms_state", Translations.translate(enabled ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
        return 1;
    }

    private static int setMaxBlocks(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, int maxBlocks) {
        if (!managePermission.test(source)) {
            source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        bootstrap.configService().general().blockLimits().setMaxBlocks(maxBlocks);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.sendSuccess(() -> Translations.translate("command.veinminer.settings.max_blocks_set", maxBlocks), true);
        return 1;
    }

    private static int showSettings(CommandSourceStack source, Bootstrap bootstrap) {
        ConfigService.ConfigSnapshot snapshot = bootstrap.configService().snapshot();
        source.sendSuccess(() -> Translations.translate("command.veinminer.settings.show.block_list_mode", SettingsCommand.describeMode(snapshot.general().blockListMode())), false);
        source.sendSuccess(() -> Translations.translate("command.veinminer.settings.show.max_blocks", snapshot.general().blockLimits().maxBlocks()), false);
        source.sendSuccess(() -> Translations.translate("command.veinminer.settings.show.cooldown_enabled", snapshot.general().cooldown().enabled()), false);
        source.sendSuccess(() -> Translations.translate("command.veinminer.settings.show.cooldown_time", snapshot.general().cooldown().seconds()), false);
        return 1;
    }

    private static int showHelp(CommandSourceStack source) {
        source.sendSuccess(() -> Translations.translate("command.veinminer.help.settings", new Object[0]), false);
        return 1;
    }

    private static Component describeMode(GeneralConfig.BlockListMode mode) {
        String key = switch (mode) {
            default -> throw new MatchException(null, null);
            case GeneralConfig.BlockListMode.GLOBAL_WHITELIST -> "command.veinminer.block_list_type.global_whitelist";
            case GeneralConfig.BlockListMode.PER_TOOL_WHITELIST -> "command.veinminer.block_list_type.per_tool_whitelist";
            case GeneralConfig.BlockListMode.GLOBAL_BLACKLIST -> "command.veinminer.block_list_type.global_blacklist";
            case GeneralConfig.BlockListMode.PER_TOOL_BLACKLIST -> "command.veinminer.block_list_type.per_tool_blacklist";
        };
        return Translations.translate(key, new Object[0]);
    }

    private static boolean ensurePerToolMode(CommandSourceStack source, Bootstrap bootstrap) {
        if (bootstrap.configService().general().blockListMode().perTool()) {
            return true;
        }
        source.sendFailure(Translations.translate("command.veinminer.blockpertool.not_enabled", new Object[0]));
        return false;
    }

    private static boolean ensurePermission(CommandSourceStack source, Predicate<CommandSourceStack> managePermission) {
        if (managePermission.test(source)) {
            return true;
        }
        source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
        return false;
    }
}

