/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.util.Log;
import com.sheath.veinminer.util.Translations;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

final class ToolsCommand {
    private ToolsCommand() {
    }

    static ArgumentBuilder<CommandSourceStack, ?> build(Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tools").requires(managePermission::test)).then(Commands.literal((String)"help").executes(ctx -> ToolsCommand.showHelp((CommandSourceStack)ctx.getSource())))).executes(ctx -> ToolsCommand.list((CommandSourceStack)ctx.getSource(), bootstrap))).then(Commands.literal((String)"list").executes(ctx -> ToolsCommand.list((CommandSourceStack)ctx.getSource(), bootstrap)))).then(Commands.literal((String)"add").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(ToolsCommand.suggestTools()).executes(ctx -> ToolsCommand.add((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"id")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(ToolsCommand.suggestTools()).executes(ctx -> ToolsCommand.remove((CommandSourceStack)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"id")))));
    }

    private static SuggestionProvider<CommandSourceStack> suggestTools() {
        return (ctx, builder) -> ToolsCommand.suggestTools((CommandSourceStack)ctx.getSource(), builder);
    }

    private static CompletableFuture<Suggestions> suggestTools(CommandSourceStack source, SuggestionsBuilder builder) {
        ArrayList<String> options = new ArrayList<String>(BuiltInRegistries.ITEM.keySet().size() + 1);
        for (ResourceLocation id : BuiltInRegistries.ITEM.keySet()) {
            options.add(id.toString());
        }
        options.add("hand");
        return SharedSuggestionProvider.suggest(options, (SuggestionsBuilder)builder);
    }

    private static int list(CommandSourceStack source, Bootstrap bootstrap) {
        ConfigService.ConfigSnapshot snapshot = bootstrap.configService().snapshot();
        List<String> entries = List.copyOf(snapshot.allowedTools().raw());
        if (entries.isEmpty()) {
            source.sendSuccess(() -> Translations.translate("command.veinminer.tools.none", new Object[0]), false);
            return 1;
        }
        source.sendSuccess(() -> Translations.translate("command.veinminer.tools.header", new Object[0]), false);
        entries.forEach(entry -> source.sendSuccess(() -> Translations.translate("command.veinminer.list_entry", entry), false));
        return 1;
    }

    private static int add(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, String rawEntry) {
        if (!ToolsCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        ConfigService.ChangeResult result = bootstrap.configService().addAllowedTool(rawEntry);
        return switch (result) {
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.sendSuccess(() -> Translations.translate("command.veinminer.tools.added", rawEntry), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT -> {
                source.sendFailure(Translations.translate("command.veinminer.tools.exists", rawEntry));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID -> {
                source.sendFailure(Translations.translate("command.veinminer.tools.not_found", rawEntry));
                yield 0;
            }
            default -> {
                Log.warn("Unexpected change result {} when adding tool {}", new Object[]{result, rawEntry});
                source.sendFailure(Translations.translate("command.veinminer.tools.not_found", rawEntry));
                yield 0;
            }
        };
    }

    private static int remove(CommandSourceStack source, Bootstrap bootstrap, Predicate<CommandSourceStack> managePermission, String rawEntry) {
        if (!ToolsCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        ConfigService.ChangeResult result = bootstrap.configService().removeAllowedTool(rawEntry);
        return switch (result) {
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.sendSuccess(() -> Translations.translate("command.veinminer.tools.removed", rawEntry), true);
                yield 1;
            }
            case ConfigService.ChangeResult.NOT_FOUND -> {
                source.sendFailure(Translations.translate("command.veinminer.tools.not_found", rawEntry));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID -> {
                source.sendFailure(Translations.translate("command.veinminer.tools.not_found", rawEntry));
                yield 0;
            }
            default -> {
                Log.warn("Unexpected change result {} when removing tool {}", new Object[]{result, rawEntry});
                source.sendFailure(Translations.translate("command.veinminer.tools.not_found", rawEntry));
                yield 0;
            }
        };
    }

    private static boolean ensurePermission(CommandSourceStack source, Predicate<CommandSourceStack> managePermission) {
        if (managePermission.test(source)) {
            return true;
        }
        source.sendFailure(Translations.translate("message.veinminer.no_permission", new Object[0]));
        return false;
    }

    private static int showHelp(CommandSourceStack source) {
        source.sendSuccess(() -> Translations.translate("command.veinminer.help.tools", new Object[0]), false);
        return 1;
    }
}

