/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sheath.veinminer.command.BlockPerToolCommand;
import com.sheath.veinminer.command.BlocksCommand;
import com.sheath.veinminer.command.ParticlesCommand;
import com.sheath.veinminer.command.SettingsCommand;
import com.sheath.veinminer.command.TestCommand;
import com.sheath.veinminer.command.ToolsCommand;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.player.PlayerSettingsStore;
import com.sheath.veinminer.util.Log;
import com.sheath.veinminer.util.Translations;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public final class VeinMinerCommand {
    private static final Map<String, String> HELP_TOPICS = VeinMinerCommand.createHelpTopics();
    private final Bootstrap bootstrap;

    public VeinMinerCommand(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"veinminer").requires(source -> source.hasPermission(0))).executes(ctx -> this.showHelp((CommandSourceStack)ctx.getSource()))).then(((LiteralArgumentBuilder)Commands.literal((String)"help").executes(ctx -> this.showHelp((CommandSourceStack)ctx.getSource()))).then(Commands.argument((String)"topic", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            HELP_TOPICS.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> this.showHelp((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"topic")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(this::canReload)).executes(ctx -> this.reload((CommandSourceStack)ctx.getSource())))).then(Commands.literal((String)"toggle").executes(ctx -> this.withPlayer((CommandSourceStack)ctx.getSource(), this::toggleVeinminer)))).then(Commands.literal((String)"toggleparticles").executes(ctx -> this.withPlayer((CommandSourceStack)ctx.getSource(), this::toggleParticles)))).then(this.buildToggleMessagesNode());
        root.then(BlocksCommand.build(this.bootstrap, this::canReload));
        root.then(ToolsCommand.build(this.bootstrap, this::canReload));
        root.then(BlockPerToolCommand.build(this.bootstrap, this::canReload));
        root.then(ParticlesCommand.build(this.bootstrap, this::canReload));
        root.then(SettingsCommand.build(this.bootstrap, this::canReload));
        root.then(this.buildActivationNode());
        root.then(TestCommand.build(this.bootstrap, this::canReload));
        dispatcher.register(root);
    }

    private int showHelp(CommandSourceStack source) {
        return this.showHelp(source, "overview");
    }

    private int showHelp(CommandSourceStack source, String topic) {
        String normalized = topic == null ? "overview" : topic.toLowerCase(Locale.ROOT);
        String key = HELP_TOPICS.getOrDefault(normalized, HELP_TOPICS.get("overview"));
        source.sendSuccess(() -> Translations.translate(key, new Object[0]), false);
        return 1;
    }

    private int reload(CommandSourceStack source) {
        try {
            this.bootstrap.configService().loadAll();
            this.bootstrap.controller().reloadFromConfig();
            source.sendSuccess(() -> Translations.translate("command.veinminer.reload", new Object[0]), true);
            return 1;
        }
        catch (ConfigService.ConfigLoadException ex) {
            Log.error("Config reload failed", ex);
            String fileName = ex.path().getFileName().toString();
            int line = ex.line();
            String lineArg = line >= 0 ? Integer.toString(line) : "?";
            source.sendFailure(Translations.translate("command.veinminer.reload_failed", fileName, lineArg, ex.getMessage()));
            return 0;
        }
        catch (Exception ex) {
            Log.error("Config reload failed", ex);
            String message = ex.getMessage() != null ? ex.getMessage() : ex.getClass().getSimpleName();
            source.sendFailure(Translations.translate("command.veinminer.reload_failed", message));
            return 0;
        }
    }

    private void toggleVeinminer(ServerPlayer player) {
        PlayerSettingsStore store = this.bootstrap.playerSettings();
        boolean newState = !store.isVeinminerEnabled(player);
        store.setVeinminerEnabled(player, newState);
        store.saveAsync();
        player.displayClientMessage(Translations.translate("command.veinminer.toggle", Translations.translate(newState ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
    }

    private void toggleParticles(ServerPlayer player) {
        PlayerSettingsStore store = this.bootstrap.playerSettings();
        boolean newState = !store.isParticlesEnabled(player);
        store.setParticlesEnabled(player, newState);
        store.saveAsync();
        player.displayClientMessage(Translations.translate("command.veinminer.particles_player_toggle", Translations.translate(newState ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
    }

    private ArgumentBuilder<CommandSourceStack, ?> buildToggleMessagesNode() {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"togglemessages").executes(ctx -> this.showToggleMessagesHelp((CommandSourceStack)ctx.getSource()))).then(Commands.literal((String)"help").executes(ctx -> this.showToggleMessagesHelp((CommandSourceStack)ctx.getSource())));
        for (PlayerSettingsStore.MessageType type : PlayerSettingsStore.MessageType.values()) {
            root.then(Commands.literal((String)type.id()).executes(ctx -> this.withPlayer((CommandSourceStack)ctx.getSource(), player -> this.toggleMessage((ServerPlayer)player, type))));
        }
        return root;
    }

    private ArgumentBuilder<CommandSourceStack, ?> buildActivationNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"activation").executes(ctx -> this.showActivationHelp((CommandSourceStack)ctx.getSource()))).then(Commands.literal((String)"help").executes(ctx -> this.showActivationHelp((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"keybind").then(Commands.literal((String)"enable").executes(ctx -> this.withPlayer((CommandSourceStack)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setUseKeybind((ServerPlayer)player, true);
            store.resetKeyToggleState((ServerPlayer)player);
            store.saveAsync();
            player.displayClientMessage(Translations.translate("command.veinminer.activation.keybind", Translations.translate("command.veinminer.enabled", new Object[0])), true);
        })))).then(Commands.literal((String)"disable").executes(ctx -> this.withPlayer((CommandSourceStack)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setUseKeybind((ServerPlayer)player, false);
            store.resetKeyToggleState((ServerPlayer)player);
            store.saveAsync();
            player.displayClientMessage(Translations.translate("command.veinminer.activation.keybind", Translations.translate("command.veinminer.disabled", new Object[0])), true);
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"keymode").then(Commands.literal((String)"hold").executes(ctx -> this.withPlayer((CommandSourceStack)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setKeyToggleMode((ServerPlayer)player, false);
            store.resetKeyToggleState((ServerPlayer)player);
            store.saveAsync();
            player.displayClientMessage(Translations.translate("command.veinminer.activation.key_mode", Translations.translate("command.veinminer.activation.mode.hold", new Object[0])), true);
        })))).then(Commands.literal((String)"toggle").executes(ctx -> this.withPlayer((CommandSourceStack)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setKeyToggleMode((ServerPlayer)player, true);
            store.saveAsync();
            player.displayClientMessage(Translations.translate("command.veinminer.activation.key_mode", Translations.translate("command.veinminer.activation.mode.toggle", new Object[0])), true);
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"crouchmode").then(Commands.literal((String)"hold").executes(ctx -> this.withPlayer((CommandSourceStack)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setCrouchToggleMode((ServerPlayer)player, false);
            store.resetCrouchToggleState((ServerPlayer)player);
            store.saveAsync();
            player.displayClientMessage(Translations.translate("command.veinminer.activation.crouch_mode", Translations.translate("command.veinminer.activation.mode.hold", new Object[0])), true);
        })))).then(Commands.literal((String)"toggle").executes(ctx -> this.withPlayer((CommandSourceStack)ctx.getSource(), player -> {
            PlayerSettingsStore store = this.bootstrap.playerSettings();
            store.setCrouchToggleMode((ServerPlayer)player, true);
            store.saveAsync();
            player.displayClientMessage(Translations.translate("command.veinminer.activation.crouch_mode", Translations.translate("command.veinminer.activation.mode.toggle", new Object[0])), true);
        }))));
    }

    private void toggleMessage(ServerPlayer player, PlayerSettingsStore.MessageType type) {
        PlayerSettingsStore store = this.bootstrap.playerSettings();
        boolean newState = !store.isMessageEnabled(player, type);
        store.setMessageEnabled(player, type, newState);
        store.saveAsync();
        player.displayClientMessage(Translations.translate("command.veinminer.togglemessage", Component.literal((String)VeinMinerCommand.capitalize(type.id())), Translations.translate(newState ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
    }

    private int withPlayer(CommandSourceStack source, Consumer<ServerPlayer> consumer) {
        try {
            ServerPlayer player = source.getPlayer();
            if (player == null) {
                source.sendFailure(Translations.translate("command.veinminer.player_only", new Object[0]));
                return 0;
            }
            consumer.accept(player);
            return 1;
        }
        catch (Exception ex) {
            Log.error("Command execution failed", ex);
            source.sendFailure((Component)Component.literal((String)(ex.getMessage() == null ? "Unknown error" : ex.getMessage())));
            return 0;
        }
    }

    private static String capitalize(String input) {
        if (input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase(Locale.ROOT) + input.substring(1);
    }

    private int showToggleMessagesHelp(CommandSourceStack source) {
        source.sendSuccess(() -> Translations.translate("command.veinminer.help.togglemessages", new Object[0]), false);
        return 1;
    }

    private int showActivationHelp(CommandSourceStack source) {
        source.sendSuccess(() -> Translations.translate("command.veinminer.help.activation", new Object[0]), false);
        return 1;
    }

    private static Map<String, String> createHelpTopics() {
        return Map.ofEntries(Map.entry("overview", "command.veinminer.help"), Map.entry("blocks", "command.veinminer.help.blocks"), Map.entry("blockpertool", "command.veinminer.help.blockpertool"), Map.entry("tools", "command.veinminer.help.tools"), Map.entry("settings", "command.veinminer.help.settings"), Map.entry("blocklistmode", "command.veinminer.help.settings"), Map.entry("activation", "command.veinminer.help.activation"), Map.entry("togglemessages", "command.veinminer.help.togglemessages"), Map.entry("particles", "command.veinminer.help.particles"), Map.entry("reload", "command.veinminer.help.reload"), Map.entry("toggle", "command.veinminer.help.toggle"));
    }

    private boolean canReload(CommandSourceStack source) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return this.bootstrap.permissionService().hasPermission(player, "veinminer.reload");
        }
        return source.hasPermission(2);
    }

    private static final class Command {
        static final int SINGLE_SUCCESS = 1;

        private Command() {
        }
    }
}

