/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.sheath.veinminer.util.Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.fml.loading.FMLPaths;

abstract class TomlConfigFile {
    private final Path path;

    protected TomlConfigFile(String fileName) {
        this.path = FMLPaths.CONFIGDIR.get().resolve("Veinminer").resolve(fileName);
    }

    protected CommentedFileConfig loadConfig() {
        this.ensureParentExists();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.path).autosave().sync().preserveInsertionOrder().build();
        config.load();
        return config;
    }

    protected void save(CommentedFileConfig config) {
        config.save();
    }

    public Path path() {
        return this.path;
    }

    private void ensureParentExists() {
        Path parent = this.path.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException ex) {
                Log.error("Failed to create config directory " + String.valueOf(parent), ex);
            }
        }
    }
}

