/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.core;

import com.sheath.veinminer.command.VeinMinerCommand;
import com.sheath.veinminer.concurrent.TaskExecutor;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.logic.VeinMinerController;
import com.sheath.veinminer.metrics.ServerTpsTracker;
import com.sheath.veinminer.network.NetworkService;
import com.sheath.veinminer.permission.PermissionService;
import com.sheath.veinminer.player.PlayerSettingsStore;
import com.sheath.veinminer.state.CooldownTracker;
import com.sheath.veinminer.state.KeyStateRegistry;
import com.sheath.veinminer.testing.FeatureTestHarness;
import com.sheath.veinminer.util.Log;
import net.neoforged.bus.api.IEventBus;

public final class Bootstrap {
    private final ConfigService configService = new ConfigService();
    private final TaskExecutor taskExecutor = new TaskExecutor();
    private final PlayerSettingsStore playerSettings = new PlayerSettingsStore(this.taskExecutor);
    private final ServerTpsTracker tpsTracker = new ServerTpsTracker();
    private final PermissionService permissionService = new PermissionService();
    private final KeyStateRegistry keyStates = new KeyStateRegistry();
    private final CooldownTracker cooldowns = new CooldownTracker();
    private final NetworkService networkService = new NetworkService(this.keyStates, this.playerSettings);
    private final VeinMinerController controller = new VeinMinerController(this.configService, this.taskExecutor, this.playerSettings, this.tpsTracker, this.permissionService, this.keyStates, this.cooldowns);
    private final VeinMinerCommand commandHandler = new VeinMinerCommand(this);
    private final FeatureTestHarness featureTestHarness = new FeatureTestHarness(this);
    private boolean commonSetupComplete;
    private boolean clientSetupComplete;

    public synchronized void onCommonSetup() {
        if (this.commonSetupComplete) {
            Log.debug("Common bootstrap already executed; skipping", new Object[0]);
            return;
        }
        Log.debug("Bootstrapping common services", new Object[0]);
        this.configService.loadAll();
        this.playerSettings.load();
        this.controller.reloadFromConfig();
        this.taskExecutor.configure(this.configService.general().threadCount());
        this.commonSetupComplete = true;
        Log.debug("Common bootstrap finished", new Object[0]);
    }

    public void registerNetwork(IEventBus modEventBus) {
        this.networkService.register(modEventBus);
    }

    public synchronized void onClientSetup() {
        if (this.clientSetupComplete) {
            Log.debug("Client bootstrap already executed; skipping", new Object[0]);
            return;
        }
        Log.debug("Bootstrapping client services", new Object[0]);
        this.clientSetupComplete = true;
    }

    public ConfigService configService() {
        return this.configService;
    }

    public TaskExecutor taskExecutor() {
        return this.taskExecutor;
    }

    public PlayerSettingsStore playerSettings() {
        return this.playerSettings;
    }

    public ServerTpsTracker tpsTracker() {
        return this.tpsTracker;
    }

    public PermissionService permissionService() {
        return this.permissionService;
    }

    public KeyStateRegistry keyStates() {
        return this.keyStates;
    }

    public CooldownTracker cooldowns() {
        return this.cooldowns;
    }

    public NetworkService networkService() {
        return this.networkService;
    }

    public VeinMinerController controller() {
        return this.controller;
    }

    public VeinMinerCommand commandHandler() {
        return this.commandHandler;
    }

    public FeatureTestHarness featureTestHarness() {
        return this.featureTestHarness;
    }

    public boolean isCommonSetupComplete() {
        return this.commonSetupComplete;
    }

    public boolean isClientSetupComplete() {
        return this.clientSetupComplete;
    }
}

