/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.logic.rules;

import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.config.GeneralConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public final class RuleIndex {
    private final GeneralConfig.BlockListMode blockListMode;
    private final BlockRules globalBlockRules;
    private final boolean allowEmptyHand;
    private final Set<ResourceLocation> allowedToolIds;
    private final Set<TagKey<Item>> allowedToolTags;
    private final Map<ResourceLocation, BlockRules> perToolIdRules;
    private final Map<TagKey<Item>, BlockRules> perToolTagRules;
    private final BlockRules handRules;

    private RuleIndex(GeneralConfig.BlockListMode blockListMode, BlockRules globalBlockRules, boolean allowEmptyHand, Set<ResourceLocation> allowedToolIds, Set<TagKey<Item>> allowedToolTags, Map<ResourceLocation, BlockRules> perToolIdRules, Map<TagKey<Item>, BlockRules> perToolTagRules, BlockRules handRules) {
        this.blockListMode = blockListMode;
        this.globalBlockRules = globalBlockRules;
        this.allowEmptyHand = allowEmptyHand;
        this.allowedToolIds = allowedToolIds;
        this.allowedToolTags = allowedToolTags;
        this.perToolIdRules = perToolIdRules;
        this.perToolTagRules = perToolTagRules;
        this.handRules = handRules;
    }

    public static RuleIndex fromSnapshot(ConfigService.ConfigSnapshot snapshot) {
        ConfigService.RegistryList<Block> blocks = snapshot.allowedBlocks();
        ConfigService.RegistryList<Item> tools = snapshot.allowedTools();
        LinkedHashMap<ResourceLocation, BlockRules> perToolIds = new LinkedHashMap<ResourceLocation, BlockRules>();
        LinkedHashMap<TagKey, BlockRules> perToolTags = new LinkedHashMap<TagKey, BlockRules>();
        for (Map.Entry<ResourceLocation, ConfigService.RegistryList<Block>> entry : snapshot.blocksPerTool().byToolId().entrySet()) {
            perToolIds.put(entry.getKey(), BlockRules.from(entry.getValue()));
        }
        for (Map.Entry<ResourceLocation, ConfigService.RegistryList<Block>> entry : snapshot.blocksPerTool().byToolTag().entrySet()) {
            perToolTags.put((TagKey)entry.getKey(), BlockRules.from(entry.getValue()));
        }
        ConfigService.RegistryList<Block> handList = snapshot.blocksPerTool().handRules();
        BlockRules blockRules = handList != null ? BlockRules.from(handList) : null;
        return new RuleIndex(snapshot.general().blockListMode(), BlockRules.from(blocks), tools.allowEmptyHand(), Collections.unmodifiableSet(tools.identifiers()), Collections.unmodifiableSet(tools.tags()), Collections.unmodifiableMap(perToolIds), Collections.unmodifiableMap(perToolTags), blockRules);
    }

    public boolean isToolAllowed(ItemStack tool) {
        if (tool.isEmpty()) {
            return this.allowEmptyHand;
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)tool.getItem());
        if (this.allowedToolIds.contains(id)) {
            return true;
        }
        for (TagKey<Item> tag : this.allowedToolTags) {
            if (!tool.is(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockAllowed(BlockState state, ItemStack tool) {
        BlockRules rules;
        BlockRules blockRules = rules = this.blockListMode.perTool() ? this.rulesFor(tool) : this.globalBlockRules;
        if (this.blockListMode.whitelist()) {
            return rules != null && rules.matches(state);
        }
        if (rules == null) {
            return true;
        }
        return !rules.matches(state);
    }

    public BlockRules rulesFor(ItemStack tool) {
        if (!this.blockListMode.perTool()) {
            return this.globalBlockRules;
        }
        if (tool.isEmpty()) {
            return this.handRules;
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)tool.getItem());
        BlockRules rules = this.perToolIdRules.get(id);
        if (rules != null) {
            return rules;
        }
        for (TagKey<Item> tag : this.perToolTagRules.keySet()) {
            if (!tool.is(tag)) continue;
            return this.perToolTagRules.get(tag);
        }
        return null;
    }

    public GeneralConfig.BlockListMode blockListMode() {
        return this.blockListMode;
    }

    public BlockRules globalBlockRules() {
        return this.globalBlockRules;
    }

    public Map<ResourceLocation, BlockRules> perToolIdRules() {
        return this.perToolIdRules;
    }

    public Map<TagKey<Item>, BlockRules> perToolTagRules() {
        return this.perToolTagRules;
    }

    public boolean allowEmptyHand() {
        return this.allowEmptyHand;
    }

    public static final class BlockRules {
        private final Set<ResourceLocation> resourceLocations;
        private final Set<TagKey<Block>> tags;

        private BlockRules(Set<ResourceLocation> resourceLocations, Set<TagKey<Block>> tags) {
            this.resourceLocations = resourceLocations;
            this.tags = tags;
        }

        public static BlockRules from(ConfigService.RegistryList<Block> list) {
            Objects.requireNonNull(list, "registry list");
            return new BlockRules(Collections.unmodifiableSet(list.identifiers()), Collections.unmodifiableSet(list.tags()));
        }

        public boolean matches(BlockState state) {
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            if (this.resourceLocations.contains(id)) {
                return true;
            }
            for (TagKey<Block> tag : this.tags) {
                if (!state.is(tag)) continue;
                return true;
            }
            return false;
        }

        public Set<ResourceLocation> resourceLocations() {
            return this.resourceLocations;
        }

        public Set<TagKey<Block>> tags() {
            return this.tags;
        }
    }
}

