/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.network;

import com.sheath.veinminer.network.message.HandshakeMessage;
import com.sheath.veinminer.network.message.KeyStateMessage;
import com.sheath.veinminer.player.PlayerSettingsStore;
import com.sheath.veinminer.state.KeyStateRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class NetworkService {
    private static final String PROTOCOL = "1";
    private final KeyStateRegistry keyStates;
    private final PlayerSettingsStore playerSettings;

    public NetworkService(KeyStateRegistry keyStates, PlayerSettingsStore playerSettings) {
        this.keyStates = keyStates;
        this.playerSettings = playerSettings;
    }

    public void register(IEventBus modEventBus) {
        modEventBus.addListener(this::registerPayloadHandlers);
    }

    private void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("veinminermod").versioned(PROTOCOL).optional().executesOn(HandlerThread.MAIN);
        registrar.playToServer(HandshakeMessage.TYPE, HandshakeMessage.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                this.keyStates.registerClient(player);
            }
        }));
        registrar.playToServer(KeyStateMessage.TYPE, KeyStateMessage.STREAM_CODEC, (payload, context) -> context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                this.handleKeyState((KeyStateMessage)payload, player);
            }
        }));
    }

    private void handleKeyState(KeyStateMessage message, ServerPlayer player) {
        boolean wasPressed = this.keyStates.setKeyState(player, message.pressed());
        if (!this.playerSettings.useKeybind(player)) {
            return;
        }
        if (this.playerSettings.keyToggleMode(player) && message.pressed() && !wasPressed) {
            this.playerSettings.flipKeyToggleState(player);
        }
    }
}

