/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.state;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.server.level.ServerPlayer;

public final class CooldownTracker {
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();

    public boolean isOnCooldown(ServerPlayer player, int cooldownSeconds) {
        long last;
        if (cooldownSeconds <= 0) {
            return false;
        }
        long now = Util.getMillis();
        return now - (last = this.cooldowns.getOrDefault(player.getUUID(), 0L).longValue()) < (long)cooldownSeconds * 1000L;
    }

    public void startCooldown(ServerPlayer player) {
        this.cooldowns.put(player.getUUID(), Util.getMillis());
    }

    public void clear(ServerPlayer player) {
        this.cooldowns.remove(player.getUUID());
    }

    public void clearAll() {
        this.cooldowns.clear();
    }
}

