/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.state;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;

public final class KeyStateRegistry {
    private final Set<UUID> modPlayers = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Boolean> keyStates = new ConcurrentHashMap<UUID, Boolean>();

    public void registerClient(ServerPlayer player) {
        this.modPlayers.add(player.getUUID());
    }

    public void unregister(ServerPlayer player) {
        UUID uuid = player.getUUID();
        this.modPlayers.remove(uuid);
        this.keyStates.remove(uuid);
    }

    public boolean setKeyState(ServerPlayer player, boolean pressed) {
        UUID uuid = player.getUUID();
        Boolean previous = this.keyStates.put(uuid, pressed);
        return previous != null && previous != false;
    }

    public boolean hasClient(ServerPlayer player) {
        return this.modPlayers.contains(player.getUUID());
    }

    public boolean isKeyPressed(ServerPlayer player) {
        return this.keyStates.getOrDefault(player.getUUID(), false);
    }

    public void clearKeyState(ServerPlayer player) {
        this.keyStates.remove(player.getUUID());
    }
}

