/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.testing;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.logic.VeinMinerController;
import com.sheath.veinminer.player.PlayerSettingsStore;
import com.sheath.veinminer.util.Log;
import com.sheath.veinminer.util.Translations;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public final class FeatureTestHarness {
    private final Bootstrap bootstrap;
    private boolean running;
    private static final Method FIND_VEIN = FeatureTestHarness.lookupFindVein();
    private static final Method APPLY_PLAN = FeatureTestHarness.lookupApplyPlan();
    private static final Method COMPUTE_BLOCK_CAP = FeatureTestHarness.lookupComputeBlockCap();

    public FeatureTestHarness(Bootstrap bootstrap) {
        this.bootstrap = Objects.requireNonNull(bootstrap, "bootstrap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(CommandSourceStack source) {
        boolean bl;
        block11: {
            ServerPlayer serverPlayer;
            PlayerSettingsStore store;
            PlayerSnapshot snapshot;
            ServerPlayer player;
            block9: {
                boolean bl2;
                block10: {
                    if (!this.acquire()) {
                        return false;
                    }
                    player = null;
                    snapshot = null;
                    store = this.bootstrap.playerSettings();
                    Entity entity = source.getEntity();
                    if (entity instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)entity;
                        break block9;
                    }
                    source.sendFailure(Translations.translate("command.veinminer.test.player_only", new Object[0]));
                    Log.warn("Feature test aborted: non-player source '{}'", source.getTextName());
                    bl2 = true;
                    if (snapshot == null || player == null) break block10;
                    snapshot.restore(store, player);
                    store.saveAsync();
                }
                this.release();
                return bl2;
            }
            try {
                player = serverPlayer;
                snapshot = PlayerSnapshot.capture(store, player);
                source.sendSuccess(() -> Translations.translate("command.veinminer.test.starting", new Object[0]), false);
                source.sendSuccess(() -> Translations.translate("command.veinminer.test.running", new Object[0]), false);
                Log.info("Feature test harness invoked by {}", player.getGameProfile().name());
                TestContext context = new TestContext(this.bootstrap, source, player, store);
                List<TestStep> steps = this.createSteps();
                ArrayList<TestResult> results = new ArrayList<TestResult>(steps.size());
                for (TestStep step : steps) {
                    results.add(this.runStep(step, context));
                }
                long passed = results.stream().filter(TestResult::success).count();
                source.sendSuccess(() -> Translations.translate("command.veinminer.test.summary", passed, steps.size()), false);
                Log.info("Feature test harness completed with {}/{} successes", passed, steps.size());
                for (TestResult result : results) {
                    if (result.success()) {
                        source.sendSuccess(() -> Translations.translate("command.veinminer.test.step.pass", result.name()), false);
                        continue;
                    }
                    source.sendFailure(Translations.translate("command.veinminer.test.step.fail", result.name(), result.message()));
                    Log.warn("Feature test step '{}' failed: {}", result.name(), result.message());
                }
                bl = true;
                if (snapshot == null || player == null) break block11;
                snapshot.restore(store, player);
                store.saveAsync();
            }
            catch (Throwable throwable) {
                if (snapshot != null && player != null) {
                    snapshot.restore(store, player);
                    store.saveAsync();
                }
                this.release();
                throw throwable;
            }
        }
        this.release();
        return bl;
    }

    private synchronized boolean acquire() {
        if (this.running) {
            return false;
        }
        this.running = true;
        return true;
    }

    private synchronized void release() {
        this.running = false;
    }

    private List<TestStep> createSteps() {
        ArrayList<TestStep> steps = new ArrayList<TestStep>();
        steps.add(new TestStep("Veinminer Toggle", ctx -> {
            boolean before = ctx.store().isVeinminerEnabled(ctx.player());
            ctx.expectCommandSuccess("veinminer toggle");
            boolean after = ctx.store().isVeinminerEnabled(ctx.player());
            ctx.assertEquals(!before, after, "Veinminer toggle did not invert player state");
        }));
        steps.add(new TestStep("Particle Toggle", ctx -> {
            boolean before = ctx.store().isParticlesEnabled(ctx.player());
            ctx.expectCommandSuccess("veinminer toggleparticles");
            boolean after = ctx.store().isParticlesEnabled(ctx.player());
            ctx.assertEquals(!before, after, "Particle toggle did not invert player state");
        }));
        steps.add(new TestStep("Permission Message Toggle", ctx -> {
            boolean before = ctx.store().isMessageEnabled(ctx.player(), PlayerSettingsStore.MessageType.PERMISSION);
            ctx.expectCommandSuccess("veinminer togglemessages permission");
            boolean after = ctx.store().isMessageEnabled(ctx.player(), PlayerSettingsStore.MessageType.PERMISSION);
            ctx.assertEquals(!before, after, "Message toggle did not invert permission message state");
        }));
        steps.add(new TestStep("Keybind Disable", ctx -> {
            ctx.expectCommandSuccess("veinminer activation keybind disable");
            ctx.assertTrue(!ctx.store().useKeybind(ctx.player()), "Keybind disable command left keybind enabled");
        }));
        steps.add(new TestStep("Keybind Enable", ctx -> {
            ctx.expectCommandSuccess("veinminer activation keybind enable");
            ctx.assertTrue(ctx.store().useKeybind(ctx.player()), "Keybind enable command did not enable keybind usage");
        }));
        steps.add(new TestStep("Key Mode Toggle", ctx -> {
            ctx.expectCommandSuccess("veinminer activation keymode toggle");
            ctx.assertTrue(ctx.store().keyToggleMode(ctx.player()), "Key mode toggle command did not enable toggle mode");
        }));
        steps.add(new TestStep("Key Mode Hold", ctx -> {
            ctx.expectCommandSuccess("veinminer activation keymode hold");
            ctx.assertTrue(!ctx.store().keyToggleMode(ctx.player()), "Key mode hold command did not disable toggle mode");
        }));
        steps.add(new TestStep("Crouch Mode Toggle", ctx -> {
            ctx.expectCommandSuccess("veinminer activation crouchmode toggle");
            ctx.assertTrue(ctx.store().crouchToggleMode(ctx.player()), "Crouch mode toggle command did not enable toggle mode");
        }));
        steps.add(new TestStep("Crouch Mode Hold", ctx -> {
            ctx.expectCommandSuccess("veinminer activation crouchmode hold");
            ctx.assertTrue(!ctx.store().crouchToggleMode(ctx.player()), "Crouch mode hold command did not disable toggle mode");
        }));
        steps.add(new TestStep("World Veinminer Simulation", this::runWorldSimulation));
        steps.add(new TestStep("Config Reload", ctx -> ctx.expectCommandSuccess("veinminer reload")));
        return steps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWorldSimulation(TestContext ctx) throws Exception {
        VeinMinerController controller = this.bootstrap.controller();
        ConfigService.ConfigSnapshot snapshot = this.bootstrap.configService().snapshot();
        ServerLevel level = ctx.player().level();
        BlockPos origin = ctx.player().blockPosition().above();
        List<BlockPos> cluster = List.of(origin, origin.east(), origin.above());
        HashMap<BlockPos, BlockState> originalStates = new HashMap<BlockPos, BlockState>();
        for (BlockPos pos : cluster) {
            originalStates.put(pos, level.getBlockState(pos));
            level.setBlock(pos, Blocks.IRON_ORE.defaultBlockState(), 3);
        }
        boolean originalSneaking = ctx.player().isShiftKeyDown();
        ItemStack originalMainHand = ctx.player().getMainHandItem().copy();
        ItemStack tool = new ItemStack((ItemLike)Items.IRON_PICKAXE);
        ctx.player().setItemInHand(InteractionHand.MAIN_HAND, tool);
        ctx.player().setShiftKeyDown(snapshot.general().requireCrouch());
        PlayerSettingsStore store = ctx.store();
        store.setVeinminerEnabled(ctx.player(), true);
        store.setParticlesEnabled(ctx.player(), false);
        store.setUseKeybind(ctx.player(), false);
        store.setKeyToggleMode(ctx.player(), false);
        store.resetKeyToggleState(ctx.player());
        store.setCrouchToggleMode(ctx.player(), false);
        store.setCrouchToggleState(ctx.player(), snapshot.general().requireCrouch());
        store.setLastCrouchInput(ctx.player(), snapshot.general().requireCrouch());
        try {
            int reserve = snapshot.general().durabilityReserveFor(tool.getMaxDamage());
            int remaining = tool.getMaxDamage() - tool.getDamageValue();
            int limit = (Integer)COMPUTE_BLOCK_CAP.invoke((Object)controller, tool, remaining, reserve);
            Object plan = FIND_VEIN.invoke((Object)controller, level, origin, level.getBlockState(origin), limit, 0, tool.copy());
            APPLY_PLAN.invoke((Object)controller, level, ctx.player(), tool, plan, reserve);
            for (BlockPos pos : cluster) {
                ctx.assertTrue(level.isEmptyBlock(pos), "Expected block at " + String.valueOf(pos) + " to be mined");
            }
            this.clearEntities(level, cluster);
        }
        finally {
            ctx.player().setItemInHand(InteractionHand.MAIN_HAND, originalMainHand);
            ctx.player().setShiftKeyDown(originalSneaking);
            for (Map.Entry entry : originalStates.entrySet()) {
                level.setBlock((BlockPos)entry.getKey(), (BlockState)entry.getValue(), 3);
            }
            this.clearEntities(level, cluster);
        }
    }

    private void clearEntities(ServerLevel level, List<BlockPos> cluster) {
        AABB area = new AABB(cluster.get(0)).inflate(2.0);
        for (ItemEntity item : level.getEntitiesOfClass(ItemEntity.class, area)) {
            item.discard();
        }
        for (ExperienceOrb orb : level.getEntitiesOfClass(ExperienceOrb.class, area)) {
            orb.discard();
        }
    }

    private TestResult runStep(TestStep step, TestContext context) {
        try {
            step.action().run(context);
            return TestResult.success(step.name());
        }
        catch (AssertionError ex) {
            return TestResult.failure(step.name(), ((Throwable)((Object)ex)).getMessage());
        }
        catch (CommandSyntaxException ex) {
            return TestResult.failure(step.name(), ex.getMessage());
        }
        catch (Exception ex) {
            String message = ex.getMessage() != null ? ex.getMessage() : ex.getClass().getSimpleName();
            return TestResult.failure(step.name(), message);
        }
    }

    private static Method lookupFindVein() {
        try {
            Method method = VeinMinerController.class.getDeclaredMethod("findVein", ServerLevel.class, BlockPos.class, BlockState.class, Integer.TYPE, Integer.TYPE, ItemStack.class);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Unable to access VeinMinerController#findVein", ex);
        }
    }

    private static Method lookupApplyPlan() {
        try {
            Method method = VeinMinerController.class.getDeclaredMethod("applyPlan", ServerLevel.class, ServerPlayer.class, ItemStack.class, FIND_VEIN.getReturnType(), Integer.TYPE);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Unable to access VeinMinerController#applyPlan", ex);
        }
    }

    private static Method lookupComputeBlockCap() {
        try {
            Method method = VeinMinerController.class.getDeclaredMethod("computeBlockCap", ItemStack.class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Unable to access VeinMinerController#computeBlockCap", ex);
        }
    }

    private static final class PlayerSnapshot {
        private final boolean veinminerEnabled;
        private final boolean particlesEnabled;
        private final Map<PlayerSettingsStore.MessageType, Boolean> messages;
        private final boolean useKeybind;
        private final boolean keyToggleMode;
        private final boolean keyToggleActive;
        private final boolean crouchToggleMode;
        private final boolean crouchToggleActive;
        private final boolean lastCrouchInput;

        private PlayerSnapshot(boolean veinminerEnabled, boolean particlesEnabled, Map<PlayerSettingsStore.MessageType, Boolean> messages, boolean useKeybind, boolean keyToggleMode, boolean keyToggleActive, boolean crouchToggleMode, boolean crouchToggleActive, boolean lastCrouchInput) {
            this.veinminerEnabled = veinminerEnabled;
            this.particlesEnabled = particlesEnabled;
            this.messages = messages;
            this.useKeybind = useKeybind;
            this.keyToggleMode = keyToggleMode;
            this.keyToggleActive = keyToggleActive;
            this.crouchToggleMode = crouchToggleMode;
            this.crouchToggleActive = crouchToggleActive;
            this.lastCrouchInput = lastCrouchInput;
        }

        static PlayerSnapshot capture(PlayerSettingsStore store, ServerPlayer player) {
            EnumMap<PlayerSettingsStore.MessageType, Boolean> messages = new EnumMap<PlayerSettingsStore.MessageType, Boolean>(PlayerSettingsStore.MessageType.class);
            for (PlayerSettingsStore.MessageType type : PlayerSettingsStore.MessageType.values()) {
                messages.put(type, store.isMessageEnabled(player, type));
            }
            return new PlayerSnapshot(store.isVeinminerEnabled(player), store.isParticlesEnabled(player), messages, store.useKeybind(player), store.keyToggleMode(player), store.isKeyToggleActive(player), store.crouchToggleMode(player), store.isCrouchToggleActive(player), store.lastCrouchInput(player));
        }

        void restore(PlayerSettingsStore store, ServerPlayer player) {
            store.setVeinminerEnabled(player, this.veinminerEnabled);
            store.setParticlesEnabled(player, this.particlesEnabled);
            for (Map.Entry<PlayerSettingsStore.MessageType, Boolean> entry : this.messages.entrySet()) {
                store.setMessageEnabled(player, entry.getKey(), entry.getValue());
            }
            store.setUseKeybind(player, this.useKeybind);
            store.setKeyToggleMode(player, this.keyToggleMode);
            store.setKeyToggleState(player, this.keyToggleActive);
            store.setCrouchToggleMode(player, this.crouchToggleMode);
            store.setCrouchToggleState(player, this.crouchToggleActive);
            store.setLastCrouchInput(player, this.lastCrouchInput);
        }
    }

    private static final class TestContext {
        private final Bootstrap bootstrap;
        private final CommandSourceStack source;
        private final ServerPlayer player;
        private final PlayerSettingsStore store;
        private final CommandDispatcher<CommandSourceStack> dispatcher;

        TestContext(Bootstrap bootstrap, CommandSourceStack source, ServerPlayer player, PlayerSettingsStore store) {
            this.bootstrap = bootstrap;
            this.source = source;
            this.player = player;
            this.store = store;
            this.dispatcher = source.getServer().getCommands().getDispatcher();
        }

        Bootstrap bootstrap() {
            return this.bootstrap;
        }

        ServerPlayer player() {
            return this.player;
        }

        PlayerSettingsStore store() {
            return this.store;
        }

        MinecraftServer server() {
            return this.source.getServer();
        }

        void expectCommandSuccess(String command) throws CommandSyntaxException {
            int result = this.dispatcher.execute(command, (Object)this.source);
            if (result <= 0) {
                throw new AssertionError((Object)("Command '" + command + "' completed with result " + result));
            }
        }

        void assertTrue(boolean condition, String message) {
            if (!condition) {
                throw new AssertionError((Object)message);
            }
        }

        void assertEquals(boolean expected, boolean actual, String message) {
            if (expected != actual) {
                throw new AssertionError((Object)(message + " (expected: " + expected + ", actual: " + actual + ")"));
            }
        }
    }

    private record TestStep(String name, TestAction action) {
    }

    private record TestResult(String name, boolean success, String message) {
        static TestResult success(String name) {
            return new TestResult(name, true, "");
        }

        static TestResult failure(String name, String message) {
            return new TestResult(name, false, message);
        }
    }

    @FunctionalInterface
    private static interface TestAction {
        public void run(TestContext var1) throws Exception;
    }
}

