/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.visual;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;

public final class ParticleOutlineManager {
    private static final int SPAWN_INTERVAL_TICKS = 5;
    private static final double[][] EDGE_OFFSETS = new double[][]{{0.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 1.0, 1.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 1.0}};
    private static final List<ParticleTask> TASKS = new ArrayList<ParticleTask>();

    private ParticleOutlineManager() {
    }

    public static void register() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spawnOutline(ServerLevel level, BlockPos pos, int red, int green, int blue, int durationTicks) {
        DustParticleOptions effect = new DustParticleOptions(ParticleOutlineManager.packColor(red, green, blue), 1.0f);
        List<ParticleTask> list = TASKS;
        synchronized (list) {
            TASKS.removeIf(task -> task.level == level && task.pos.equals((Object)pos));
            TASKS.add(new ParticleTask(level, pos.immutable(), effect, durationTicks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onWorldTick(ServerLevel level) {
        List<ParticleTask> list = TASKS;
        synchronized (list) {
            Iterator<ParticleTask> iterator = TASKS.iterator();
            while (iterator.hasNext()) {
                ParticleTask task = iterator.next();
                if (task.level != level) continue;
                --task.remaining;
                --task.cooldown;
                if (task.cooldown <= 0) {
                    ParticleOutlineManager.spawnEdges(task.level, task.pos, task.effect);
                    task.cooldown = 5;
                }
                if (task.remaining > 0) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onWorldUnload(ServerLevel level) {
        List<ParticleTask> list = TASKS;
        synchronized (list) {
            TASKS.removeIf(task -> task.level == level);
        }
    }

    private static void spawnEdges(ServerLevel level, BlockPos pos, DustParticleOptions effect) {
        for (double[] offset : EDGE_OFFSETS) {
            double x = (double)pos.getX() + offset[0];
            double y = (double)pos.getY() + offset[1];
            double z = (double)pos.getZ() + offset[2];
            level.sendParticles((ParticleOptions)effect, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    private static int packColor(int r, int g, int b) {
        int clampedR = Math.max(0, Math.min(255, r));
        int clampedG = Math.max(0, Math.min(255, g));
        int clampedB = Math.max(0, Math.min(255, b));
        return 0xFF000000 | clampedR << 16 | clampedG << 8 | clampedB;
    }

    private static final class ParticleTask {
        final ServerLevel level;
        final BlockPos pos;
        final DustParticleOptions effect;
        int remaining;
        int cooldown = 0;

        ParticleTask(ServerLevel level, BlockPos pos, DustParticleOptions effect, int duration) {
            this.level = level;
            this.pos = pos;
            this.effect = effect;
            this.remaining = duration;
        }
    }
}

