/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.events;

import com.sheath.veinminer.dataManagement.PlayerDataManager;
import com.sheath.veinminer.events.VeinminerChecks;
import com.sheath.veinminer.events.VeinminerThreadPool;
import com.sheath.veinminer.init.ConfigInit;
import com.sheath.veinminer.mixin.ExperienceDroppingBlockAccessor;
import com.sheath.veinminer.utils.ParticleUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1303;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2431;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_6017;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8567;

public final class VeinminerProcess {
    public static void runAsyncVeinMining(class_3218 world, class_3222 player, class_2338 originPos, class_2680 originState) {
        CompletableFuture.supplyAsync(() -> {
            class_6880.class_6883 silk = world.method_30349().method_30530(class_7924.field_41265).method_46747(class_1893.field_9099);
            class_1799 tool = player.method_6047();
            int silkTouchLevel = class_1890.method_8225((class_6880)silk, (class_1799)tool);
            return new VeinContext(silkTouchLevel, tool.method_7972(), originPos, originState);
        }, VeinminerThreadPool.threadPool).thenAccept(ctx -> world.method_8503().execute(() -> VeinminerProcess.executeOnServerThread(world, player, ctx)));
    }

    private static Set<class_2338> findVeinBlocks(class_3218 world, class_2338 origin, class_2680 originState) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        visited.add(origin);
        queue.add(origin);
        class_2248 originBlock = originState.method_26204();
        while (!queue.isEmpty() && visited.size() < ConfigInit.GENERAL.maxBlocks) {
            class_2338 current = (class_2338)queue.poll();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        class_2338 n;
                        if (dx == 0 && dy == 0 && dz == 0 || visited.contains(n = current.method_10069(dx, dy, dz)) || world.method_8320(n).method_26204() != originBlock) continue;
                        visited.add(n);
                        queue.add(n);
                    }
                }
            }
        }
        return visited;
    }

    private static void executeOnServerThread(class_3218 world, class_3222 player, VeinContext ctx) {
        Set<class_2338> vein = VeinminerProcess.findVeinBlocks(world, ctx.originPos, ctx.originState);
        int broken = 0;
        int totalXp = 0;
        HashMap<class_1792, class_1799> combinedDrops = new HashMap<class_1792, class_1799>();
        for (class_2338 pos : vein) {
            class_2248 class_22482;
            if (broken >= ConfigInit.GENERAL.maxBlocks) break;
            class_2680 state = world.method_8320(pos);
            if (state.method_26215()) continue;
            if (PlayerDataManager.isParticlesEnabled(player) && ConfigInit.GENERAL.enableParticleOutline) {
                ParticleUtils.spawnPersistentEdgeParticles(world, pos, ConfigInit.GENERAL.particleRed, ConfigInit.GENERAL.particleGreen, ConfigInit.GENERAL.particleBlue, ConfigInit.GENERAL.particleDurationTicks);
            }
            List<class_1799> drops = VeinminerProcess.collectBlockDrops(world, pos, state, ctx.toolStack, ctx.silkTouchLevel);
            for (class_1799 drop : drops) {
                combinedDrops.merge(drop.method_7909(), drop.method_7972(), (existing, incoming) -> {
                    existing.method_7933(incoming.method_7947());
                    return existing;
                });
            }
            if (ctx.silkTouchLevel == 0 && (class_22482 = state.method_26204()) instanceof class_2431) {
                class_2431 block = (class_2431)class_22482;
                totalXp += VeinminerProcess.resolveExperience(block, world);
            }
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            ++broken;
        }
        for (class_1799 stack : combinedDrops.values()) {
            class_2248.method_9577((class_1937)world, (class_2338)ctx.originPos, (class_1799)stack);
        }
        if (totalXp > 0) {
            class_1303.method_31493((class_3218)world, (class_243)class_243.method_24954((class_2382)ctx.originPos), (int)totalXp);
        }
        world.method_8396(null, ctx.originPos, world.method_8320(ctx.originPos).method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
        VeinminerChecks.setCooldown(player);
    }

    private static List<class_1799> collectBlockDrops(class_3218 world, class_2338 dropPos, class_2680 state, class_1799 tool, int silkTouchLevel) {
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        if (silkTouchLevel > 0) {
            drops.add(new class_1799((class_1935)state.method_26204()));
        } else {
            class_8567.class_8568 builder = new class_8567.class_8568(world).method_51874(class_181.field_1224, (Object)state).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)dropPos)).method_51874(class_181.field_1229, (Object)tool).method_51871(world.method_8409().method_43057());
            drops.addAll(state.method_26189(builder));
        }
        return drops;
    }

    private static int resolveExperience(class_2431 block, class_3218 world) {
        class_6017 provider = ((ExperienceDroppingBlockAccessor)block).getExperienceDropped();
        return provider.method_35008(world.field_9229);
    }

    private record VeinContext(int silkTouchLevel, class_1799 toolStack, class_2338 originPos, class_2680 originState) {
    }
}

