/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.network;

import com.sheath.veinminer.network.payload.HandshakeC2SPayload;
import com.sheath.veinminer.network.payload.KeyStateC2SPayload;
import com.sheath.veinminer.player.PlayerSettingsStore;
import com.sheath.veinminer.state.KeyStateRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class NetworkService {
    private final KeyStateRegistry keyStates;
    private final PlayerSettingsStore playerSettings;

    public NetworkService(KeyStateRegistry keyStates, PlayerSettingsStore playerSettings) {
        this.keyStates = keyStates;
        this.playerSettings = playerSettings;
    }

    public void register() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)HandshakeC2SPayload.ID, (server, player, handler, buf, responseSender) -> this.handleHandshake(player));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)KeyStateC2SPayload.ID, (server, player, handler, buf, responseSender) -> this.handleKeyState(player, KeyStateC2SPayload.read(buf)));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> this.keyStates.unregister(handler.field_14140));
    }

    private void handleHandshake(class_3222 player) {
        this.keyStates.registerClient(player);
    }

    private void handleKeyState(class_3222 player, boolean pressed) {
        boolean wasPressed = this.keyStates.setKeyState(player, pressed);
        if (!this.playerSettings.useKeybind(player)) {
            return;
        }
        if (this.playerSettings.keyToggleMode(player) && pressed && !wasPressed) {
            this.playerSettings.flipKeyToggleState(player);
        }
    }
}

