/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.sheath.veinminer.Veinminer;
import com.sheath.veinminer.config.AllowedToolsConfig;
import com.sheath.veinminer.dataManagement.PlayerDataManager;
import com.sheath.veinminer.init.ConfigInit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7924;

public class VeinminerCommand {
    private static final SuggestionProvider<class_2168> BLOCK_SUGGESTIONS = (context, builder) -> ((class_2168)context.getSource()).method_41213(class_7924.field_41254, class_2172.class_7078.field_37264, builder, context);
    private static final SuggestionProvider<class_2168> ITEM_SUGGESTIONS = (context, builder) -> ((class_2168)context.getSource()).method_41213(class_7924.field_41197, class_2172.class_7078.field_37264, builder, context);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"veinminer").requires(source -> VeinminerCommand.hasPermission(source, "veinminer.use"))).executes(ctx -> VeinminerCommand.showHelp((class_2168)ctx.getSource()))).then(class_2170.method_9247((String)"help").executes(ctx -> VeinminerCommand.showHelp((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(s -> VeinminerCommand.hasPermission(s, "veinminer.reload"))).executes(ctx -> VeinminerCommand.reloadConfig((class_2168)ctx.getSource())))).then(VeinminerCommand.buildBlocksCommand())).then(VeinminerCommand.buildToolsCommand())).then(VeinminerCommand.buildSettingsCommand())).then(VeinminerCommand.buildBlockPerToolCommand())).then(VeinminerCommand.buildParticlesCommand())).then(class_2170.method_9247((String)"toggle").executes(ctx -> VeinminerCommand.toggleVeinminer((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"toggleparticles").executes(ctx -> VeinminerCommand.toggleParticles((class_2168)ctx.getSource())))).then(VeinminerCommand.buildToggleMessagesCommand()));
    }

    private static LiteralCommandNode<class_2168> buildBlocksCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blocks").requires(VeinminerCommand.hasAny("veinminer.blocks.manage", "veinminer.blocks.*", "veinminer.*"))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(VeinminerCommand.hasAny("veinminer.blocks.add", "veinminer.blocks.*", "veinminer.*"))).then(class_2170.method_9244((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests(BLOCK_SUGGESTIONS).executes(VeinminerCommand::addBlock)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(VeinminerCommand.hasAny("veinminer.blocks.remove", "veinminer.blocks.*", "veinminer.*"))).then(class_2170.method_9244((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests(BLOCK_SUGGESTIONS).executes(VeinminerCommand::removeBlock)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(VeinminerCommand.hasAny("veinminer.blocks.list", "veinminer.blocks.*", "veinminer.*"))).executes(ctx -> VeinminerCommand.listBlocks((class_2168)ctx.getSource())))).build();
    }

    private static LiteralCommandNode<class_2168> buildToolsCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tools").requires(VeinminerCommand.hasAny("veinminer.tools.manage", "veinminer.tools.*", "veinminer.*"))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(VeinminerCommand.hasAny("veinminer.tools.add", "veinminer.tools.*", "veinminer.*"))).then(class_2170.method_9244((String)"tool", (ArgumentType)StringArgumentType.greedyString()).suggests(ITEM_SUGGESTIONS).executes(VeinminerCommand::addTool)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(VeinminerCommand.hasAny("veinminer.tools.remove", "veinminer.tools.*", "veinminer.*"))).then(class_2170.method_9244((String)"tool", (ArgumentType)StringArgumentType.greedyString()).suggests(ITEM_SUGGESTIONS).executes(VeinminerCommand::removeTool)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(VeinminerCommand.hasAny("veinminer.tools.list", "veinminer.tools.*", "veinminer.*"))).executes(ctx -> VeinminerCommand.listTools((class_2168)ctx.getSource())))).build();
    }

    private static LiteralCommandNode<class_2168> buildSettingsCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"settings").requires(VeinminerCommand.hasAny("veinminer.settings.manage", "veinminer.*"))).then(class_2170.method_9247((String)"blockpertool").executes(ctx -> VeinminerCommand.toggleBlockPerTool((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cooldown").then(class_2170.method_9247((String)"enable").executes(ctx -> VeinminerCommand.enableCooldown((class_2168)ctx.getSource(), true)))).then(class_2170.method_9247((String)"disable").executes(ctx -> VeinminerCommand.enableCooldown((class_2168)ctx.getSource(), false)))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> VeinminerCommand.setCooldown((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"luckperms").then(class_2170.method_9247((String)"enable").executes(ctx -> VeinminerCommand.enableLuckPerms((class_2168)ctx.getSource(), true)))).then(class_2170.method_9247((String)"disable").executes(ctx -> VeinminerCommand.enableLuckPerms((class_2168)ctx.getSource(), false))))).then(class_2170.method_9247((String)"maxblocks").then(class_2170.method_9244((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> VeinminerCommand.setMaxBlocks((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"number")))))).executes(ctx -> VeinminerCommand.showSettings((class_2168)ctx.getSource()))).build();
    }

    private static LiteralCommandNode<class_2168> buildBlockPerToolCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blockpertool").requires(VeinminerCommand.hasAny("veinminer.blockpertool.manage", "veinminer.*"))).then(class_2170.method_9247((String)"blocks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"tool", (ArgumentType)StringArgumentType.greedyString()).suggests(ITEM_SUGGESTIONS).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(VeinminerCommand.hasAny("veinminer.blockpertool.blocks.add", "veinminer.blockpertool.blocks.*", "veinminer.*"))).then(class_2170.method_9244((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests(BLOCK_SUGGESTIONS).executes(ctx -> VeinminerCommand.addBlockPerTool((class_2168)ctx.getSource(), (String)ctx.getArgument("tool", String.class), (String)ctx.getArgument("block", String.class)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(VeinminerCommand.hasAny("veinminer.blockpertool.blocks.remove", "veinminer.blockpertool.blocks.*", "veinminer.*"))).then(class_2170.method_9244((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests(BLOCK_SUGGESTIONS).executes(ctx -> VeinminerCommand.removeBlockPerTool((class_2168)ctx.getSource(), (String)ctx.getArgument("tool", String.class), (String)ctx.getArgument("block", String.class)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(VeinminerCommand.hasAny("veinminer.blockpertool.blocks.list", "veinminer.blockpertool.blocks.*", "veinminer.*"))).executes(ctx -> VeinminerCommand.listBlocksPerTool((class_2168)ctx.getSource(), (String)ctx.getArgument("tool", String.class))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tool").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(VeinminerCommand.hasAny("veinminer.blockpertool.tools.add", "veinminer.blockpertool.tools.*", "veinminer.*"))).then(class_2170.method_9244((String)"tool", (ArgumentType)StringArgumentType.greedyString()).suggests(ITEM_SUGGESTIONS).executes(ctx -> VeinminerCommand.addToolPerTool((class_2168)ctx.getSource(), (String)ctx.getArgument("tool", String.class)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(VeinminerCommand.hasAny("veinminer.blockpertool.tools.remove", "veinminer.blockpertool.tools.*", "veinminer.*"))).then(class_2170.method_9244((String)"tool", (ArgumentType)StringArgumentType.greedyString()).suggests(ITEM_SUGGESTIONS).executes(ctx -> VeinminerCommand.removeToolPerTool((class_2168)ctx.getSource(), (String)ctx.getArgument("tool", String.class)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(VeinminerCommand.hasAny("veinminer.blockpertool.tools.list", "veinminer.blockpertool.tools.*", "veinminer.*"))).executes(ctx -> VeinminerCommand.listToolsPerTool((class_2168)ctx.getSource()))))).build();
    }

    private static LiteralCommandNode<class_2168> buildParticlesCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"particles").requires(VeinminerCommand.hasAny("veinminer.particles.manage", "veinminer.*"))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"enable").requires(s -> VeinminerCommand.hasPermission(s, "veinminer.particles.enable"))).executes(ctx -> VeinminerCommand.toggleParticles((class_2168)ctx.getSource(), true)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"disable").requires(s -> VeinminerCommand.hasPermission(s, "veinminer.particles.disable"))).executes(ctx -> VeinminerCommand.toggleParticles((class_2168)ctx.getSource(), false)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setcolor").requires(s -> VeinminerCommand.hasPermission(s, "veinminer.particles.setcolor"))).then(class_2170.method_9244((String)"red", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(class_2170.method_9244((String)"green", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(class_2170.method_9244((String)"blue", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(ctx -> VeinminerCommand.setParticleColor((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"red"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"green"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"blue")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setduration").requires(s -> VeinminerCommand.hasPermission(s, "veinminer.particles.setduration"))).then(class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> VeinminerCommand.setParticleDuration((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration")))))).build();
    }

    private static Predicate<class_2168> hasAny(String ... permissions) {
        return source -> Arrays.stream(permissions).anyMatch(p -> VeinminerCommand.hasPermission(source, p));
    }

    private static LiteralCommandNode<class_2168> buildToggleMessagesCommand() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"togglemessages").then(class_2170.method_9247((String)"permission").executes(ctx -> VeinminerCommand.toggleMessage((class_2168)ctx.getSource(), PlayerDataManager.MessageType.PERMISSION)))).then(class_2170.method_9247((String)"disabled").executes(ctx -> VeinminerCommand.toggleMessage((class_2168)ctx.getSource(), PlayerDataManager.MessageType.DISABLED)))).then(class_2170.method_9247((String)"cooldown").executes(ctx -> VeinminerCommand.toggleMessage((class_2168)ctx.getSource(), PlayerDataManager.MessageType.COOLDOWN)))).then(class_2170.method_9247((String)"durability").executes(ctx -> VeinminerCommand.toggleMessage((class_2168)ctx.getSource(), PlayerDataManager.MessageType.DURABILITY)))).build();
    }

    private static boolean hasPermission(class_2168 source, String permission) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            return Veinminer.hasPermission(player, permission);
        }
        return source.method_9259(2);
    }

    private static int toggleVeinminer(class_2168 source) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            boolean state = !PlayerDataManager.isVeinminerEnabled(player);
            PlayerDataManager.setVeinminerEnabled(player, state);
            source.method_9226(() -> class_2561.method_43470((String)("Veinminer is now " + (state ? "enabled" : "disabled") + ".")), true);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players."));
        }
        return 1;
    }

    private static int toggleParticles(class_2168 source) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            boolean state = !PlayerDataManager.isParticlesEnabled(player);
            PlayerDataManager.setParticlesEnabled(player, state);
            source.method_9226(() -> class_2561.method_43470((String)("Particles is now " + (state ? "enabled" : "disabled") + " for you.")), true);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players."));
        }
        return 1;
    }

    private static int toggleParticles(class_2168 source, boolean enable) {
        ConfigInit.GENERAL.enableParticleOutline = enable;
        ConfigInit.GENERAL.save();
        source.method_9226(() -> class_2561.method_43470((String)("Particles " + (enable ? "enabled" : "disabled") + ".")), true);
        return 1;
    }

    private static int toggleMessage(class_2168 source, PlayerDataManager.MessageType type) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            boolean state = !PlayerDataManager.isMessageEnabled(player, type);
            PlayerDataManager.setMessageEnabled(player, type, state);
            source.method_9226(() -> class_2561.method_43470((String)(type.display() + " messages are now " + (state ? "enabled" : "disabled") + " for you.")), true);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players."));
        }
        return 1;
    }

    private static int setParticleColor(class_2168 source, int r, int g, int b) {
        ConfigInit.GENERAL.particleRed = r;
        ConfigInit.GENERAL.particleGreen = g;
        ConfigInit.GENERAL.particleBlue = b;
        ConfigInit.GENERAL.save();
        source.method_9226(() -> class_2561.method_43470((String)"Particle color set"), true);
        return 1;
    }

    private static int setParticleDuration(class_2168 source, int ticks) {
        ConfigInit.GENERAL.particleDurationTicks = ticks;
        ConfigInit.GENERAL.save();
        source.method_9226(() -> class_2561.method_43470((String)("Particle duration set to " + ticks + " ticks.")), true);
        return 1;
    }

    private static int toggleBlockPerTool(class_2168 source) {
        ConfigInit.GENERAL.blocksPerTool = !ConfigInit.GENERAL.blocksPerTool;
        ConfigInit.GENERAL.save();
        source.method_9226(() -> class_2561.method_43470((String)("BlockPerTool is now " + (ConfigInit.GENERAL.blocksPerTool ? "enabled" : "disabled"))), true);
        return 1;
    }

    private static int setCooldown(class_2168 source, int seconds) {
        ConfigInit.GENERAL.cooldownSeconds = seconds;
        ConfigInit.GENERAL.save();
        source.method_9226(() -> class_2561.method_43470((String)("Cooldown time set to " + seconds + " seconds")), true);
        return 1;
    }

    private static int enableCooldown(class_2168 source, boolean enabled) {
        ConfigInit.GENERAL.cooldownEnabled = enabled;
        ConfigInit.GENERAL.save();
        source.method_9226(() -> class_2561.method_43470((String)("Cooldown is now " + (enabled ? "enabled" : "disabled"))), true);
        return 1;
    }

    private static int enableLuckPerms(class_2168 source, boolean enable) {
        ConfigInit.GENERAL.autoLuckPerms = enable;
        ConfigInit.GENERAL.save();
        source.method_9226(() -> class_2561.method_43470((String)("LuckPerms integration " + (enable ? "enabled" : "disabled"))), true);
        return 1;
    }

    private static int setMaxBlocks(class_2168 source, int max) {
        ConfigInit.GENERAL.maxBlocks = max;
        ConfigInit.GENERAL.save();
        source.method_9226(() -> class_2561.method_43470((String)("Max blocks set to " + max)), true);
        return 1;
    }

    private static int reloadConfig(class_2168 source) {
        ConfigInit.load();
        source.method_9226(() -> class_2561.method_43470((String)"Veinminer config reloaded."), true);
        return 1;
    }

    private static int showHelp(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"/veinminer help - Show this help message"), false);
        source.method_9226(() -> class_2561.method_43470((String)"/veinminer reload - Reload config"), false);
        source.method_9226(() -> class_2561.method_43470((String)"/veinminer blocks/tools - Manage allowed blocks/tools by registry ID or tag (prefixed with '#')"), false);
        source.method_9226(() -> class_2561.method_43470((String)"/veinminer settings - Configure cooldown, blockPerTool, etc."), false);
        source.method_9226(() -> class_2561.method_43470((String)"/veinminer togglemessages <permission|disabled|cooldown|durability> - Toggle specific informational messages"), false);
        return 1;
    }

    private static int showSettings(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)("Max Blocks: " + ConfigInit.GENERAL.maxBlocks)), false);
        source.method_9226(() -> class_2561.method_43470((String)("Cooldown Enabled: " + ConfigInit.GENERAL.cooldownEnabled)), false);
        source.method_9226(() -> class_2561.method_43470((String)("Cooldown Time: " + ConfigInit.GENERAL.cooldownSeconds + " seconds")), false);
        return 1;
    }

    private static int addBlock(CommandContext<class_2168> ctx) {
        String block = (String)ctx.getArgument("block", String.class);
        if (ConfigInit.BLOCKS.allowedBlocks.add(block)) {
            ConfigInit.BLOCKS.save();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Block ID " + block + " added to Veinminer.")), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Block ID " + block + " is already in the list.")), false);
        }
        return 1;
    }

    private static int removeBlock(CommandContext<class_2168> ctx) {
        String block = (String)ctx.getArgument("block", String.class);
        if (ConfigInit.BLOCKS.allowedBlocks.remove(block)) {
            ConfigInit.BLOCKS.save();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Block ID " + block + " removed from Veinminer.")), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Block ID " + block + " is not in the list.")), false);
        }
        return 1;
    }

    private static int listBlocks(class_2168 source) {
        if (ConfigInit.BLOCKS.allowedBlocks.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No blocks in the list."), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"Allowed blocks:"), false);
            ConfigInit.BLOCKS.allowedBlocks.forEach(b -> source.method_9226(() -> class_2561.method_43470((String)("- " + b)), false));
        }
        return 1;
    }

    private static int addTool(CommandContext<class_2168> ctx) {
        String tool = (String)ctx.getArgument("tool", String.class);
        if (AllowedToolsConfig.allowedTools.add(tool)) {
            ConfigInit.TOOLS.save();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Tool ID " + tool + " added to Veinminer.")), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Tool ID " + tool + " is already in the list.")), false);
        }
        return 1;
    }

    private static int removeTool(CommandContext<class_2168> ctx) {
        String tool = (String)ctx.getArgument("tool", String.class);
        if (AllowedToolsConfig.allowedTools.remove(tool)) {
            ConfigInit.TOOLS.save();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Tool ID " + tool + " removed from Veinminer.")), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Tool ID " + tool + " is not in the list.")), false);
        }
        return 1;
    }

    private static int listTools(class_2168 source) {
        if (AllowedToolsConfig.allowedTools.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No tools in the list."), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"Allowed tools:"), false);
            AllowedToolsConfig.allowedTools.forEach(t -> source.method_9226(() -> class_2561.method_43470((String)("- " + t)), false));
        }
        return 1;
    }

    private static int addBlockPerTool(class_2168 source, String tool, String block) {
        Set blocks = ConfigInit.BLOCKS_PER_TOOL.allowedBlocksPerTool.computeIfAbsent(tool, k -> new HashSet());
        if (blocks.add(block)) {
            ConfigInit.BLOCKS_PER_TOOL.save();
            source.method_9226(() -> class_2561.method_43470((String)("Block ID " + block + " added for tool " + tool + ".")), true);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("Block ID " + block + " is already in the list.")), false);
        }
        return 1;
    }

    private static int removeBlockPerTool(class_2168 source, String tool, String block) {
        Set<String> blocks = ConfigInit.BLOCKS_PER_TOOL.allowedBlocksPerTool.get(tool);
        if (blocks != null && blocks.remove(block)) {
            ConfigInit.BLOCKS_PER_TOOL.save();
            source.method_9226(() -> class_2561.method_43470((String)("Block ID " + block + " removed from tool " + tool + ".")), true);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("Block ID " + block + " not found for tool " + tool + ".")), false);
        }
        return 1;
    }

    private static int listBlocksPerTool(class_2168 source, String tool) {
        Set<String> blocks = ConfigInit.BLOCKS_PER_TOOL.allowedBlocksPerTool.get(tool);
        if (blocks == null || blocks.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)("No blocks for tool " + tool + ".")), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("Blocks for tool " + tool + ":")), false);
            blocks.forEach(b -> source.method_9226(() -> class_2561.method_43470((String)("- " + b)), false));
        }
        return 1;
    }

    private static int addToolPerTool(class_2168 source, String tool) {
        if (ConfigInit.BLOCKS_PER_TOOL.allowedBlocksPerTool.containsKey(tool)) {
            source.method_9226(() -> class_2561.method_43470((String)("Tool ID " + tool + " already exists.")), false);
        } else {
            ConfigInit.BLOCKS_PER_TOOL.allowedBlocksPerTool.put(tool, new HashSet());
            ConfigInit.BLOCKS_PER_TOOL.save();
            source.method_9226(() -> class_2561.method_43470((String)("Tool ID " + tool + " added.")), true);
        }
        return 1;
    }

    private static int removeToolPerTool(class_2168 source, String tool) {
        if (ConfigInit.BLOCKS_PER_TOOL.allowedBlocksPerTool.remove(tool) != null) {
            ConfigInit.BLOCKS_PER_TOOL.save();
            source.method_9226(() -> class_2561.method_43470((String)("Tool ID " + tool + " removed.")), true);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("Tool ID " + tool + " not found.")), false);
        }
        return 1;
    }

    private static int listToolsPerTool(class_2168 source) {
        if (ConfigInit.BLOCKS_PER_TOOL.allowedBlocksPerTool.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No tools found."), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"Tools:"), false);
            ConfigInit.BLOCKS_PER_TOOL.allowedBlocksPerTool.keySet().forEach(t -> source.method_9226(() -> class_2561.method_43470((String)("- " + t)), false));
        }
        return 1;
    }

    private static class Permission {
        static final String USE = "veinminer.use";
        static final String RELOAD = "veinminer.reload";
        static final String SETTINGS_MANAGE = "veinminer.settings.manage";
        static final String ALL = "veinminer.*";

        private Permission() {
        }

        static class Particles {
            static final String MANAGE = "veinminer.particles.manage";
            static final String ENABLE = "veinminer.particles.enable";
            static final String DISABLE = "veinminer.particles.disable";
            static final String SET_COLOR = "veinminer.particles.setcolor";
            static final String SET_DURATION = "veinminer.particles.setduration";

            Particles() {
            }
        }

        static class BlockPerTool {
            static final String MANAGE = "veinminer.blockpertool.manage";

            BlockPerTool() {
            }

            static class Tools {
                static final String ADD = "veinminer.blockpertool.tools.add";
                static final String REMOVE = "veinminer.blockpertool.tools.remove";
                static final String LIST = "veinminer.blockpertool.tools.list";
                static final String ALL = "veinminer.blockpertool.tools.*";

                Tools() {
                }
            }

            static class Blocks {
                static final String ADD = "veinminer.blockpertool.blocks.add";
                static final String REMOVE = "veinminer.blockpertool.blocks.remove";
                static final String LIST = "veinminer.blockpertool.blocks.list";
                static final String ALL = "veinminer.blockpertool.blocks.*";

                Blocks() {
                }
            }
        }

        static class Tools {
            static final String MANAGE = "veinminer.tools.manage";
            static final String ADD = "veinminer.tools.add";
            static final String REMOVE = "veinminer.tools.remove";
            static final String LIST = "veinminer.tools.list";
            static final String ALL = "veinminer.tools.*";

            Tools() {
            }
        }

        static class Blocks {
            static final String MANAGE = "veinminer.blocks.manage";
            static final String ADD = "veinminer.blocks.add";
            static final String REMOVE = "veinminer.blocks.remove";
            static final String LIST = "veinminer.blocks.list";
            static final String ALL = "veinminer.blocks.*";

            Blocks() {
            }
        }
    }
}

