/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.utils;

import com.sheath.veinminer.utils.ColorUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import org.joml.Vector3i;

public class ParticleUtils {
    private static final int SPAWN_INTERVAL_TICKS = 5;
    private static final List<ParticleTask> TASKS = new ArrayList<ParticleTask>();

    private static void onWorldTick(class_3218 world) {
        Iterator<ParticleTask> it = TASKS.iterator();
        while (it.hasNext()) {
            ParticleTask task = it.next();
            if (task.world != world) continue;
            --task.ticksUntilNext;
            --task.remainingDuration;
            if (task.ticksUntilNext <= 0) {
                ParticleUtils.spawnEdges(task.world, task.pos, task.particle);
                task.ticksUntilNext = 5;
            }
            if (task.remainingDuration > 0) continue;
            it.remove();
        }
    }

    private static void spawnEdges(class_3218 world, class_2338 pos, class_2390 particle) {
        double[][] edgeOffsets;
        for (double[] offset : edgeOffsets = new double[][]{{0.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 1.0, 1.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 1.0}}) {
            double x = (double)pos.method_10263() + offset[0];
            double y = (double)pos.method_10264() + offset[1];
            double z = (double)pos.method_10260() + offset[2];
            world.method_65096((class_2394)particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    public static void spawnPersistentEdgeParticles(class_3218 world, class_2338 pos, int r, int g, int b, int durationTicks) {
        Vector3i color = new Vector3i(r, g, b);
        int packedColor = ColorUtils.vector3fToInt(color);
        class_2390 particle = new class_2390(packedColor, 1.0f);
        TASKS.add(new ParticleTask(world, pos, particle, durationTicks));
    }

    static {
        ServerTickEvents.END_WORLD_TICK.register(ParticleUtils::onWorldTick);
    }

    private static class ParticleTask {
        final class_3218 world;
        final class_2338 pos;
        final class_2390 particle;
        int remainingDuration;
        int ticksUntilNext = 0;

        ParticleTask(class_3218 world, class_2338 pos, class_2390 particle, int duration) {
            this.world = world;
            this.pos = pos;
            this.particle = particle;
            this.remainingDuration = duration;
        }
    }
}

