/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.dataManagement;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.sheath.veinminer.utils.ModLogger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;

public class PlayerDataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File DATA_FILE = FabricLoader.getInstance().getConfigDir().resolve("Veinminer/Players/PlayerData.json").toFile();
    private static Map<UUID, Boolean> playerVeinminerStates = new HashMap<UUID, Boolean>();
    private static Map<UUID, Boolean> playerParticlesStates = new HashMap<UUID, Boolean>();

    public static void load() {
        File parentDir = DATA_FILE.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            ModLogger.error("\u26a0 Failed to create directory: " + parentDir.getAbsolutePath(), new Object[0]);
        }
        if (!DATA_FILE.exists()) {
            PlayerDataManager.save();
            return;
        }
        try (FileReader fileReader = new FileReader(DATA_FILE);
             JsonReader reader = new JsonReader((Reader)fileReader);){
            reader.setLenient(true);
            JsonElement element = JsonParser.parseReader((JsonReader)reader);
            playerVeinminerStates = new HashMap<UUID, Boolean>();
            playerParticlesStates = new HashMap<UUID, Boolean>();
            if (element != null && element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                if (obj.has("veinminer") || obj.has("particles")) {
                    if (obj.has("veinminer") && obj.get("veinminer").isJsonObject()) {
                        for (Map.Entry entry : obj.getAsJsonObject("veinminer").entrySet()) {
                            playerVeinminerStates.put(UUID.fromString((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsBoolean());
                        }
                    }
                    if (obj.has("particles") && obj.get("particles").isJsonObject()) {
                        for (Map.Entry entry : obj.getAsJsonObject("particles").entrySet()) {
                            playerParticlesStates.put(UUID.fromString((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsBoolean());
                        }
                    }
                } else {
                    for (Map.Entry entry : obj.entrySet()) {
                        playerVeinminerStates.put(UUID.fromString((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsBoolean());
                    }
                }
            }
        }
        catch (IOException e) {
            ModLogger.error("Failed to load player data: " + e.getMessage(), new Object[0]);
            playerVeinminerStates = new HashMap<UUID, Boolean>();
            playerParticlesStates = new HashMap<UUID, Boolean>();
        }
        ModLogger.info("Registered and loaded PlayerData!", new Object[0]);
    }

    public static void save() {
        File parentDir = DATA_FILE.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            ModLogger.error("\u26a0 Failed to create directory: " + parentDir.getAbsolutePath(), new Object[0]);
        }
        try (FileWriter writer = new FileWriter(DATA_FILE);){
            GSON.toJson(PlayerDataManager.buildSerializableData(), (Appendable)writer);
        }
        catch (IOException e) {
            ModLogger.error("Failed to save player data: " + e.getMessage(), new Object[0]);
        }
    }

    private static Map<String, Map<String, Boolean>> buildSerializableData() {
        HashMap<String, Map<String, Boolean>> serializableData = new HashMap<String, Map<String, Boolean>>();
        HashMap<String, Boolean> veinminerMap = new HashMap<String, Boolean>();
        for (Map.Entry<UUID, Boolean> entry : playerVeinminerStates.entrySet()) {
            veinminerMap.put(entry.getKey().toString(), entry.getValue());
        }
        HashMap<String, Boolean> particlesMap = new HashMap<String, Boolean>();
        for (Map.Entry<UUID, Boolean> entry : playerParticlesStates.entrySet()) {
            particlesMap.put(entry.getKey().toString(), entry.getValue());
        }
        serializableData.put("veinminer", veinminerMap);
        serializableData.put("particles", particlesMap);
        return serializableData;
    }

    public static void setVeinminerEnabled(class_3222 player, boolean enabled) {
        playerVeinminerStates.put(player.method_5667(), enabled);
    }

    public static boolean isVeinminerEnabled(class_3222 player) {
        return playerVeinminerStates.getOrDefault(player.method_5667(), true);
    }

    public static void setParticlesEnabled(class_3222 player, boolean enabled) {
        playerParticlesStates.put(player.method_5667(), enabled);
    }

    public static boolean isParticlesEnabled(class_3222 player) {
        return playerParticlesStates.getOrDefault(player.method_5667(), true);
    }
}

