/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.util.Translations;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

final class SettingsCommand {
    private SettingsCommand() {
    }

    static ArgumentBuilder<class_2168, ?> build(Bootstrap bootstrap, Predicate<class_2168> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"settings").requires(managePermission::test)).then(class_2170.method_9247((String)"help").executes(ctx -> SettingsCommand.showHelp((class_2168)ctx.getSource())))).executes(ctx -> SettingsCommand.showSettings((class_2168)ctx.getSource(), bootstrap))).then(class_2170.method_9247((String)"blockpertool").executes(ctx -> SettingsCommand.toggleBlockPerTool((class_2168)ctx.getSource(), bootstrap, managePermission)))).then(class_2170.method_9247((String)"blocklistmode").then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (GeneralConfig.BlockListMode mode : GeneralConfig.BlockListMode.values()) {
                builder.suggest(mode.name().toLowerCase(Locale.ROOT));
            }
            return builder.buildFuture();
        }).executes(ctx -> SettingsCommand.setBlockListMode((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"mode")))))).then(SettingsCommand.buildCooldownNode(bootstrap, managePermission))).then(SettingsCommand.buildLuckPermsNode(bootstrap, managePermission))).then(class_2170.method_9247((String)"maxblocks").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> SettingsCommand.setMaxBlocks((class_2168)ctx.getSource(), bootstrap, managePermission, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
    }

    private static ArgumentBuilder<class_2168, ?> buildCooldownNode(Bootstrap bootstrap, Predicate<class_2168> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cooldown").then(class_2170.method_9247((String)"enable").executes(ctx -> SettingsCommand.setCooldownEnabled((class_2168)ctx.getSource(), bootstrap, managePermission, true)))).then(class_2170.method_9247((String)"disable").executes(ctx -> SettingsCommand.setCooldownEnabled((class_2168)ctx.getSource(), bootstrap, managePermission, false)))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> SettingsCommand.setCooldownSeconds((class_2168)ctx.getSource(), bootstrap, managePermission, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds")))));
    }

    private static ArgumentBuilder<class_2168, ?> buildLuckPermsNode(Bootstrap bootstrap, Predicate<class_2168> managePermission) {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"luckperms").then(class_2170.method_9247((String)"enable").executes(ctx -> SettingsCommand.setLuckPerms((class_2168)ctx.getSource(), bootstrap, managePermission, true)))).then(class_2170.method_9247((String)"disable").executes(ctx -> SettingsCommand.setLuckPerms((class_2168)ctx.getSource(), bootstrap, managePermission, false)));
    }

    private static int toggleBlockPerTool(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission) {
        if (!managePermission.test(source)) {
            source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        GeneralConfig general = bootstrap.configService().general();
        GeneralConfig.BlockListMode current = general.blockListMode();
        GeneralConfig.BlockListMode next = current.perTool() ? (current.blacklist() ? GeneralConfig.BlockListMode.GLOBAL_BLACKLIST : GeneralConfig.BlockListMode.GLOBAL_WHITELIST) : (current.blacklist() ? GeneralConfig.BlockListMode.PER_TOOL_BLACKLIST : GeneralConfig.BlockListMode.PER_TOOL_WHITELIST);
        general.setBlockListMode(next);
        general.save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.method_9226(() -> Translations.translate("command.veinminer.settings.blockpertool", SettingsCommand.describeMode(next)), true);
        return 1;
    }

    private static int setBlockListMode(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String rawMode) {
        if (!managePermission.test(source)) {
            source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        GeneralConfig.BlockListMode mode = GeneralConfig.BlockListMode.parse(rawMode, null);
        if (mode == null) {
            source.method_9213(Translations.translate("command.veinminer.settings.blocklistmode_invalid", rawMode));
            return 0;
        }
        GeneralConfig general = bootstrap.configService().general();
        general.setBlockListMode(mode);
        general.save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.method_9226(() -> Translations.translate("command.veinminer.settings.blocklistmode_set", SettingsCommand.describeMode(mode)), true);
        return 1;
    }

    private static int setCooldownSeconds(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, int seconds) {
        if (!managePermission.test(source)) {
            source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        bootstrap.configService().general().cooldown().setSeconds(seconds);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.method_9226(() -> Translations.translate("command.veinminer.settings.cooldown_time_set", seconds), true);
        return 1;
    }

    private static int setCooldownEnabled(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, boolean enabled) {
        if (!managePermission.test(source)) {
            source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        bootstrap.configService().general().cooldown().setEnabled(enabled);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.method_9226(() -> Translations.translate("command.veinminer.settings.cooldown_state", Translations.translate(enabled ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
        return 1;
    }

    private static int setLuckPerms(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, boolean enabled) {
        if (!managePermission.test(source)) {
            source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        bootstrap.configService().general().setAutoLuckPerms(enabled);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.method_9226(() -> Translations.translate("command.veinminer.settings.luckperms_state", Translations.translate(enabled ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
        return 1;
    }

    private static class_2561 describeMode(GeneralConfig.BlockListMode mode) {
        String key = switch (mode) {
            default -> throw new MatchException(null, null);
            case GeneralConfig.BlockListMode.GLOBAL_WHITELIST -> "command.veinminer.block_list_type.global_whitelist";
            case GeneralConfig.BlockListMode.PER_TOOL_WHITELIST -> "command.veinminer.block_list_type.per_tool_whitelist";
            case GeneralConfig.BlockListMode.GLOBAL_BLACKLIST -> "command.veinminer.block_list_type.global_blacklist";
            case GeneralConfig.BlockListMode.PER_TOOL_BLACKLIST -> "command.veinminer.block_list_type.per_tool_blacklist";
        };
        return Translations.translate(key, new Object[0]);
    }

    private static int setMaxBlocks(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, int maxBlocks) {
        if (!managePermission.test(source)) {
            source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        bootstrap.configService().general().blockLimits().setMaxBlocks(maxBlocks);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.method_9226(() -> Translations.translate("command.veinminer.settings.max_blocks_set", maxBlocks), true);
        return 1;
    }

    private static int showSettings(class_2168 source, Bootstrap bootstrap) {
        ConfigService.ConfigSnapshot snapshot = bootstrap.configService().snapshot();
        source.method_9226(() -> Translations.translate("command.veinminer.settings.show.block_list_mode", SettingsCommand.describeMode(snapshot.general().blockListMode())), false);
        source.method_9226(() -> Translations.translate("command.veinminer.settings.show.max_blocks", snapshot.general().blockLimits().maxBlocks()), false);
        source.method_9226(() -> Translations.translate("command.veinminer.settings.show.cooldown_enabled", snapshot.general().cooldown().enabled()), false);
        source.method_9226(() -> Translations.translate("command.veinminer.settings.show.cooldown_time", snapshot.general().cooldown().seconds()), false);
        return 1;
    }

    private static int showHelp(class_2168 source) {
        source.method_9226(() -> Translations.translate("command.veinminer.help.settings", new Object[0]), false);
        return 1;
    }
}

