/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.visual;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import org.joml.Vector3f;

public final class ParticleOutlineManager {
    private static final int SPAWN_INTERVAL_TICKS = 5;
    private static final double[][] EDGE_OFFSETS = new double[][]{{0.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 1.0, 1.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 1.0}};
    private static final List<ParticleTask> TASKS = new ArrayList<ParticleTask>();
    private static boolean registered = false;

    private ParticleOutlineManager() {
    }

    public static synchronized void register() {
        if (registered) {
            return;
        }
        registered = true;
        ServerTickEvents.END_WORLD_TICK.register(ParticleOutlineManager::onWorldTick);
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            List<ParticleTask> list = TASKS;
            synchronized (list) {
                TASKS.removeIf(task -> task.world == world);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spawnOutline(class_3218 world, class_2338 pos, int red, int green, int blue, int durationTicks) {
        class_2390 effect = ParticleOutlineManager.createDustEffect(red, green, blue);
        List<ParticleTask> list = TASKS;
        synchronized (list) {
            TASKS.removeIf(task -> task.world == world && task.pos.equals((Object)pos));
            TASKS.add(new ParticleTask(world, pos.method_10062(), effect, durationTicks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onWorldTick(class_3218 world) {
        List<ParticleTask> list = TASKS;
        synchronized (list) {
            Iterator<ParticleTask> iterator = TASKS.iterator();
            while (iterator.hasNext()) {
                ParticleTask task = iterator.next();
                if (task.world != world) continue;
                --task.remaining;
                --task.cooldown;
                if (task.cooldown <= 0) {
                    ParticleOutlineManager.spawnEdges(task.world, task.pos, task.effect);
                    task.cooldown = 5;
                }
                if (task.remaining > 0) continue;
                iterator.remove();
            }
        }
    }

    private static void spawnEdges(class_3218 world, class_2338 pos, class_2390 effect) {
        for (double[] offset : EDGE_OFFSETS) {
            double x = (double)pos.method_10263() + offset[0];
            double y = (double)pos.method_10264() + offset[1];
            double z = (double)pos.method_10260() + offset[2];
            world.method_14199((class_2394)effect, x, y, z, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    private static int packColor(int r, int g, int b) {
        int clampedR = Math.max(0, Math.min(255, r));
        int clampedG = Math.max(0, Math.min(255, g));
        int clampedB = Math.max(0, Math.min(255, b));
        return clampedR << 16 | clampedG << 8 | clampedB;
    }

    private static class_2390 createDustEffect(int red, int green, int blue) {
        int packed = ParticleOutlineManager.packColor(red, green, blue);
        try {
            Constructor intCtor = class_2390.class.getConstructor(Integer.TYPE, Float.TYPE);
            return (class_2390)intCtor.newInstance(packed, Float.valueOf(1.0f));
        }
        catch (NoSuchMethodException ignored) {
            try {
                Constructor vectorCtor = class_2390.class.getConstructor(Vector3f.class, Float.TYPE);
                float r = (float)(packed >> 16 & 0xFF) / 255.0f;
                float g = (float)(packed >> 8 & 0xFF) / 255.0f;
                float b = (float)(packed & 0xFF) / 255.0f;
                return (class_2390)vectorCtor.newInstance(new Vector3f(r, g, b), Float.valueOf(1.0f));
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException("Unable to construct dust particle effect", ex);
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Unable to construct dust particle effect", ex);
        }
    }

    private static final class ParticleTask {
        final class_3218 world;
        final class_2338 pos;
        final class_2390 effect;
        int remaining;
        int cooldown = 0;

        ParticleTask(class_3218 world, class_2338 pos, class_2390 effect, int duration) {
            this.world = world;
            this.pos = pos;
            this.effect = effect;
            this.remaining = duration;
        }
    }
}

