/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer;

import com.mojang.brigadier.CommandDispatcher;
import com.sheath.veinminer.commands.VeinminerCommand;
import com.sheath.veinminer.dataManagement.PlayerDataManager;
import com.sheath.veinminer.events.VeinminerThreadPool;
import com.sheath.veinminer.init.ConfigInit;
import com.sheath.veinminer.init.VeinminerInit;
import com.sheath.veinminer.miscellaneous.TPSTracker;
import com.sheath.veinminer.miscellaneous.UpdateChecker;
import com.sheath.veinminer.utils.ModLogger;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class Veinminer
implements ModInitializer {
    public static final String MOD_ID = "veinminermod";
    private static final long SAVE_INTERVAL_TICKS = 6000L;
    private static final AtomicLong tickCounter = new AtomicLong();
    private static LuckPerms luckPerms;

    public void onInitialize() {
        ModLogger.info("Registering and loading mod events and files!", new Object[0]);
        ConfigInit.load();
        PlayerDataManager.load();
        VeinminerInit.register();
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        ServerTickEvents.END_SERVER_TICK.register(this::onEndServerTick);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> VeinminerCommand.register((CommandDispatcher<class_2168>)dispatcher));
        if (ConfigInit.GENERAL.updateCheckerEnabled) {
            ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> UpdateChecker.notifyPlayerIfUpdateAvailable(handler.method_32311()));
        }
    }

    private void onServerStarted(MinecraftServer minecraftServer) {
        VeinminerThreadPool.initializeThreadPool();
        if (ConfigInit.GENERAL.updateCheckerEnabled) {
            UpdateChecker.checkForUpdates();
        }
        if (ConfigInit.GENERAL.autoLuckPerms) {
            try {
                Class.forName("net.luckperms.api.LuckPermsProvider");
                luckPerms = LuckPermsProvider.get();
                ModLogger.info("LuckPerms detected, integrating permissions.", new Object[0]);
            }
            catch (ClassNotFoundException | IllegalStateException e) {
                ModLogger.info("LuckPerms not detected, skipping integration.", new Object[0]);
                luckPerms = null;
            }
        } else {
            ModLogger.info("LuckPerms integration disabled by config.", new Object[0]);
            luckPerms = null;
        }
        ModLogger.info("Registered and loaded mod events and files!", new Object[0]);
    }

    private void onServerStopping(MinecraftServer minecraftServer) {
        PlayerDataManager.save();
        ModLogger.info("Shutting down Veinminer thread pool", new Object[0]);
        VeinminerThreadPool.shutdownThreadPool();
    }

    private void onEndServerTick(MinecraftServer server) {
        TPSTracker.tick(System.currentTimeMillis());
        if (tickCounter.incrementAndGet() >= 6000L) {
            PlayerDataManager.save();
            tickCounter.set(0L);
        }
        if (ConfigInit.GENERAL.dynamicMaxBlocks) {
            double tps = TPSTracker.getTPS();
            int adjustedMaxBlocks = (int)(tps / 20.0 * (double)(ConfigInit.GENERAL.maxDynamicBlocks - ConfigInit.GENERAL.minBlocks)) + ConfigInit.GENERAL.minBlocks;
            ConfigInit.GENERAL.maxBlocks = Math.max(ConfigInit.GENERAL.minBlocks, adjustedMaxBlocks);
        }
    }

    public static boolean hasPermission(class_3222 player, String permission) {
        User user;
        if (luckPerms != null && (user = luckPerms.getUserManager().getUser(player.method_5667())) != null) {
            return user.getCachedData().getPermissionData().checkPermission(permission).asBoolean();
        }
        return true;
    }
}

