/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.config;

import com.sheath.libs.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class AllowedBlocksPerToolConfig {
    private static final File FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "Veinminer/AllowedBlocksPerTool.toml");
    public Map<String, Set<String>> allowedBlocksPerTool = new HashMap<String, Set<String>>();

    public void load(Map<String, Set<String>> defaultMap) {
        File parentDir = FILE.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            System.err.println("\u26a0 Failed to create config directory: " + parentDir.getAbsolutePath());
        }
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(FILE).autosave().sync().preserveInsertionOrder().build();){
            config.load();
            if (config.isEmpty()) {
                this.allowedBlocksPerTool = defaultMap;
                this.save();
            } else {
                this.allowedBlocksPerTool.clear();
                for (String key : config.valueMap().keySet()) {
                    Object raw = config.get(key);
                    HashSet<String> blocks = new HashSet<String>();
                    if (raw instanceof Iterable) {
                        Iterable iterable = (Iterable)raw;
                        for (Object obj : iterable) {
                            if (obj == null) continue;
                            blocks.add(obj.toString());
                        }
                    }
                    this.allowedBlocksPerTool.put(key, blocks);
                }
            }
        }
    }

    public void save() {
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(FILE).autosave().sync().preserveInsertionOrder().build();){
            config.load();
            config.clear();
            config.setComment("", "Mapping of tool registry ids or tag strings starting with '#' to lists of block registry ids or tag strings.\nFormat: tool = [\"block1\", \"#block_tag\", ...]");
            for (Map.Entry<String, Set<String>> entry : this.allowedBlocksPerTool.entrySet()) {
                config.set(entry.getKey(), new ArrayList(entry.getValue()));
            }
            config.save();
        }
    }
}

