/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.config;

import com.sheath.libs.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import net.fabricmc.loader.api.FabricLoader;

public class GeneralConfig {
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "Veinminer/GeneralConfig.toml");
    public boolean veinminerEnabled = true;
    public boolean requireCrouch = true;
    public boolean checkToolDurability = true;
    public boolean cooldownEnabled = false;
    public int cooldownSeconds = 5;
    public boolean dynamicMaxBlocks = false;
    public int maxBlocks = 64;
    public int minBlocks = 16;
    public int maxDynamicBlocks = 64;
    public boolean enableParticleOutline = true;
    public int particleDurationTicks = 60;
    public int particleRed = 255;
    public int particleGreen = 0;
    public int particleBlue = 0;
    public boolean autoLuckPerms = false;
    public boolean updateCheckerEnabled = true;
    public boolean blocksPerTool = false;

    public void load() {
        File parentDir = CONFIG_FILE.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            System.err.println("\u26a0 Failed to create config directory: " + parentDir.getAbsolutePath());
        }
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(CONFIG_FILE).autosave().sync().preserveInsertionOrder().build();){
            config.load();
            this.veinminerEnabled = config.getOrElse("General.veinminerEnabled", Boolean.valueOf(this.veinminerEnabled));
            this.requireCrouch = config.getOrElse("General.requireCrouch", Boolean.valueOf(this.requireCrouch));
            this.checkToolDurability = config.getOrElse("General.checkToolDurability", Boolean.valueOf(this.checkToolDurability));
            this.cooldownEnabled = config.getOrElse("Cooldown.enabled", Boolean.valueOf(this.cooldownEnabled));
            this.cooldownSeconds = config.getOrElse("Cooldown.seconds", Integer.valueOf(this.cooldownSeconds));
            this.dynamicMaxBlocks = config.getOrElse("BlockLimits.dynamicMaxBlocks", Boolean.valueOf(this.dynamicMaxBlocks));
            this.maxBlocks = config.getOrElse("BlockLimits.maxBlocks", Integer.valueOf(this.maxBlocks));
            this.minBlocks = config.getOrElse("BlockLimits.minBlocks", Integer.valueOf(this.minBlocks));
            this.maxDynamicBlocks = config.getOrElse("BlockLimits.maxDynamicBlocks", Integer.valueOf(this.maxDynamicBlocks));
            this.enableParticleOutline = config.getOrElse("Particles.enabled", Boolean.valueOf(this.enableParticleOutline));
            this.particleDurationTicks = config.getOrElse("Particles.durationTicks", Integer.valueOf(this.particleDurationTicks));
            this.particleRed = config.getOrElse("Particles.red", Integer.valueOf(this.particleRed));
            this.particleGreen = config.getOrElse("Particles.green", Integer.valueOf(this.particleGreen));
            this.particleBlue = config.getOrElse("Particles.blue", Integer.valueOf(this.particleBlue));
            this.blocksPerTool = config.getOrElse("Advanced.blocksPerTool", Boolean.valueOf(this.blocksPerTool));
            this.autoLuckPerms = config.getOrElse("Integration.autoLuckPerms", Boolean.valueOf(this.autoLuckPerms));
            this.updateCheckerEnabled = config.getOrElse("Integration.updateCheckerEnabled", Boolean.valueOf(this.updateCheckerEnabled));
            config.set("General.veinminerEnabled", (Object)this.veinminerEnabled);
            config.setComment("General.veinminerEnabled", "Enable or disable Veinminer entirely");
            config.set("General.requireCrouch", (Object)this.requireCrouch);
            config.setComment("General.requireCrouch", "Require the player to crouch (sneak) to activate Veinminer");
            config.set("General.checkToolDurability", (Object)this.checkToolDurability);
            config.setComment("General.checkToolDurability", "Prevent Veinminer from activating if tool would break");
            config.set("Cooldown.enabled", (Object)this.cooldownEnabled);
            config.setComment("Cooldown.enabled", "Enable a cooldown between Veinminer uses");
            config.set("Cooldown.seconds", (Object)this.cooldownSeconds);
            config.setComment("Cooldown.seconds", "Cooldown duration in seconds");
            config.set("BlockLimits.dynamicMaxBlocks", (Object)this.dynamicMaxBlocks);
            config.setComment("BlockLimits.dynamicMaxBlocks", "Enable dynamic scaling of max mined blocks based on tool type");
            config.set("BlockLimits.maxBlocks", (Object)this.maxBlocks);
            config.setComment("BlockLimits.maxBlocks", "Maximum number of blocks that can be mined at once (if not dynamic)");
            config.set("BlockLimits.minBlocks", (Object)this.minBlocks);
            config.setComment("BlockLimits.minBlocks", "Minimum block count when using dynamic mode");
            config.set("BlockLimits.maxDynamicBlocks", (Object)this.maxDynamicBlocks);
            config.setComment("BlockLimits.maxDynamicBlocks", "Maximum dynamic block count (when dynamic mode is enabled)");
            config.set("Particles.enabled", (Object)this.enableParticleOutline);
            config.setComment("Particles.enabled", "Show particles around affected blocks when Veinminer activates");
            config.set("Particles.durationTicks", (Object)this.particleDurationTicks);
            config.setComment("Particles.durationTicks", "How long particles last (in ticks)");
            config.set("Particles.red", (Object)this.particleRed);
            config.setComment("Particles.red", "Particle color red value (0\u2013255)");
            config.set("Particles.green", (Object)this.particleGreen);
            config.setComment("Particles.green", "Particle color green value (0\u2013255)");
            config.set("Particles.blue", (Object)this.particleBlue);
            config.setComment("Particles.blue", "Particle color blue value (0\u2013255)");
            config.set("Advanced.blocksPerTool", (Object)this.blocksPerTool);
            config.setComment("Advanced.blocksPerTool", "Enable per-tool allowed block lists instead of global list");
            config.set("Integration.autoLuckPerms", (Object)this.autoLuckPerms);
            config.setComment("Integration.autoLuckPerms", "Automatically hook into LuckPerms if present");
            config.set("Integration.updateCheckerEnabled", (Object)this.updateCheckerEnabled);
            config.setComment("Integration.updateCheckerEnabled", "Check Modrinth for newer versions on server start");
            config.save();
        }
    }

    public void save() {
        try (CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(CONFIG_FILE).autosave().sync().preserveInsertionOrder().build();){
            config.load();
            config.set("General.veinminerEnabled", (Object)this.veinminerEnabled);
            config.set("General.requireCrouch", (Object)this.requireCrouch);
            config.set("General.checkToolDurability", (Object)this.checkToolDurability);
            config.set("Cooldown.enabled", (Object)this.cooldownEnabled);
            config.set("Cooldown.seconds", (Object)this.cooldownSeconds);
            config.set("BlockLimits.dynamicMaxBlocks", (Object)this.dynamicMaxBlocks);
            config.set("BlockLimits.maxBlocks", (Object)this.maxBlocks);
            config.set("BlockLimits.minBlocks", (Object)this.minBlocks);
            config.set("BlockLimits.maxDynamicBlocks", (Object)this.maxDynamicBlocks);
            config.set("Particles.enabled", (Object)this.enableParticleOutline);
            config.set("Particles.durationTicks", (Object)this.particleDurationTicks);
            config.set("Particles.red", (Object)this.particleRed);
            config.set("Particles.green", (Object)this.particleGreen);
            config.set("Particles.blue", (Object)this.particleBlue);
            config.set("Advanced.blocksPerTool", (Object)this.blocksPerTool);
            config.set("Integration.autoLuckPerms", (Object)this.autoLuckPerms);
            config.setComment("Integration.autoLuckPerms", "Automatically hook into LuckPerms if present");
            config.set("Integration.updateCheckerEnabled", (Object)this.updateCheckerEnabled);
            config.setComment("Integration.updateCheckerEnabled", "Check Modrinth for newer versions on server start");
            config.save();
        }
    }
}

